/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class ChannelExchange
extends ColorOperatorImpl {
    private final PATTERN exchangePattern;

    public ChannelExchange(String exchangePattern) throws ImageManipulatorException {
        try {
            this.exchangePattern = PATTERN.valueOf(exchangePattern.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ImageManipulatorException("Invalid Pattern " + exchangePattern);
        }
    }

    @Override
    public int transform(int argb, int pos) {
        int newargb;
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        switch (this.exchangePattern) {
            case RGB: {
                newargb = alpha << 24 | red << 16 | green << 8 | blue;
                break;
            }
            case RBG: {
                newargb = alpha << 24 | red << 16 | blue << 8 | green;
                break;
            }
            case BGR: {
                newargb = alpha << 24 | blue << 16 | green << 8 | red;
                break;
            }
            case BRG: {
                newargb = alpha << 24 | blue << 16 | red << 8 | green;
                break;
            }
            case GRB: {
                newargb = alpha << 24 | green << 16 | red << 8 | blue;
                break;
            }
            default: {
                newargb = alpha << 24 | green << 16 | blue << 8 | red;
            }
        }
        return newargb;
    }

    private static enum PATTERN {
        RGB,
        RBG,
        BGR,
        BRG,
        GRB,
        GBR;

    }
}

