/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class ChannelLevel
extends ColorOperatorImpl {
    private final PATTERN channel;
    private final int min;
    private final int range;

    public ChannelLevel(String channelPattern, int min, int max) throws ImageManipulatorException {
        try {
            this.channel = PATTERN.valueOf(channelPattern.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ImageManipulatorException("Invalid Pattern " + channelPattern);
        }
        if (min < 0 || min > 255) {
            throw new ImageManipulatorException("Min value out of range (0-255):" + min);
        }
        this.min = min;
        if (max < 0 || max > 255) {
            throw new ImageManipulatorException("Max value out of range (0-255):" + max);
        }
        this.range = max - min;
    }

    @Override
    public int transform(int argb, int pos) {
        int newargb;
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        switch (this.channel) {
            case RED: {
                newargb = alpha << 24 | red * this.range / 255 + this.min << 16 | green << 8 | blue;
                break;
            }
            case GREEN: {
                newargb = alpha << 24 | red << 16 | green * this.range / 255 + this.min << 8 | blue;
                break;
            }
            case BLUE: {
                newargb = alpha << 24 | red << 16 | green << 8 | blue * this.range / 255 + this.min;
                break;
            }
            default: {
                newargb = alpha << 24 | red * this.range / 255 + this.min << 16 | green * this.range / 255 + this.min << 8 | blue * this.range / 255 + this.min;
            }
        }
        return newargb;
    }

    private static enum PATTERN {
        RED,
        GREEN,
        BLUE,
        ALL;

    }
}

