/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class ChannelLevelTrunk
extends ColorOperatorImpl {
    private final PATTERN channel;
    private final int min;
    private final int max;
    private final int pad;

    public ChannelLevelTrunk(String channelPattern, int min, int max, int pad) throws ImageManipulatorException {
        try {
            this.channel = PATTERN.valueOf(channelPattern.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ImageManipulatorException("Invalid Pattern " + channelPattern);
        }
        if (min < 0 || min > 255) {
            throw new ImageManipulatorException("Min value out of range (0-255):" + min);
        }
        this.min = min;
        if (max < 0 || max > 255) {
            throw new ImageManipulatorException("Max value out of range (0-255):" + max);
        }
        this.max = max;
        if (pad < 0 || pad > 255) {
            throw new ImageManipulatorException("Pad value out of range (0-255):" + pad);
        }
        this.pad = pad;
    }

    @Override
    public int transform(int argb, int pos) {
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        switch (this.channel) {
            case RED: {
                if (red >= this.min && red <= this.max) break;
                red = this.pad;
                break;
            }
            case GREEN: {
                if (green >= this.min && green <= this.max) break;
                green = this.pad;
                break;
            }
            case BLUE: {
                if (blue >= this.min && blue <= this.max) break;
                blue = this.pad;
                break;
            }
            default: {
                if (red < this.min || red > this.max) {
                    red = this.pad;
                }
                if (green < this.min || green > this.max) {
                    green = this.pad;
                }
                if (blue >= this.min && blue <= this.max) break;
                blue = this.pad;
            }
        }
        int newargb = alpha << 24 | red << 16 | green << 8 | blue;
        return newargb;
    }

    private static enum PATTERN {
        RED,
        GREEN,
        BLUE,
        ALL;

    }
}

