/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class ChannelSelect
extends ColorOperatorImpl {
    private final PATTERN selectPattern;

    public ChannelSelect(String exchangePattern) throws ImageManipulatorException {
        try {
            this.selectPattern = PATTERN.valueOf(exchangePattern.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ImageManipulatorException("Invalid Pattern " + exchangePattern);
        }
    }

    @Override
    public int transform(int argb, int pos) {
        int newargb;
        int alpha = argb >>> 24 & 0xFF;
        int c = 0;
        switch (this.selectPattern) {
            case RED: {
                c = argb >> 16 & 0xFF;
                newargb = alpha << 24 | c << 16 | c << 8 | c;
                break;
            }
            case GREEN: {
                c = argb >> 8 & 0xFF;
                newargb = alpha << 24 | c << 16 | c << 8 | c;
                break;
            }
            case BLUE: {
                c = argb & 0xFF;
                newargb = alpha << 24 | c << 16 | c << 8 | c;
                break;
            }
            case HUE: {
                float[] hsb = BaseImageUtils.rgbToHsb(argb);
                c = (int)(hsb[0] * 255.0f);
                newargb = alpha << 24 | c << 16 | c << 8 | c;
                break;
            }
            case SATURATION: {
                if ((argb & 0xFFFFFF) > 0) {
                    float[] hsb = BaseImageUtils.rgbToHsb(argb);
                    c = (int)(hsb[1] * 255.0f);
                } else {
                    c = 0;
                }
                newargb = alpha << 24 | c << 16 | c << 8 | c;
                break;
            }
            case BRIGHTNESS: {
                float[] hsb = BaseImageUtils.rgbToHsb(argb);
                c = (int)(hsb[2] * 255.0f);
                newargb = alpha << 24 | c << 16 | c << 8 | c;
                break;
            }
            default: {
                newargb = argb;
            }
        }
        return newargb;
    }

    private static enum PATTERN {
        RED,
        GREEN,
        BLUE,
        HUE,
        SATURATION,
        BRIGHTNESS;

    }
}

