/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;
import java.util.Random;

public final class ColorOverlay
extends ColorOperatorImpl {
    private final BlendMode mode;
    private int r1;
    private int g1;
    private int b1;
    private final float r1f;
    private final float g1f;
    private final float b1f;
    private final float[] hsl1;
    private final float opacity;
    private float[] pattern;
    private final int patternLength = 8192;

    public ColorOverlay(BlendMode mode, int argb, float opacity) throws ImageManipulatorException {
        if (opacity < 0.0f) {
            opacity = 0.0f;
        } else if (opacity > 100.0f) {
            opacity = 100.0f;
        }
        this.mode = mode;
        this.r1 = argb >> 16 & 0xFF;
        this.g1 = argb >> 8 & 0xFF;
        this.b1 = argb & 0xFF;
        this.r1f = (float)this.r1 / 255.0f;
        this.g1f = (float)this.g1 / 255.0f;
        this.b1f = (float)this.b1 / 255.0f;
        this.opacity = opacity / 100.0f;
        this.hsl1 = BaseImageUtils.rgbToHsl(this.r1f, this.g1f, this.b1f);
        if (mode == BlendMode.DISSOLVE) {
            this.initDissolvePattern();
        }
    }

    private void initDissolvePattern() {
        this.pattern = new float[8192];
        Random rand = new Random(71262782L);
        for (int c = 0; c < 8192; ++c) {
            this.pattern[c] = rand.nextFloat();
        }
    }

    @Override
    public final int transform(int argb, int pos) {
        int a0 = argb >>> 24 & 0xFF;
        int r0 = argb >> 16 & 0xFF;
        int g0 = argb >> 8 & 0xFF;
        int b0 = argb & 0xFF;
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        switch (this.mode) {
            case NORMAL: {
                r2 = this.r1;
                g2 = this.g1;
                b2 = this.b1;
                break;
            }
            case MULTIPLY: {
                r2 = r0 * this.r1 / 255;
                g2 = g0 * this.g1 / 255;
                b2 = b0 * this.b1 / 255;
                break;
            }
            case DIVIDE: {
                r0 = r0 * 256 / (1 + this.r1);
                r2 = r0 <= 255 ? r0 : 255;
                g0 = g0 * 256 / (1 + this.g1);
                g2 = g0 <= 255 ? g0 : 255;
                b0 = b0 * 256 / (1 + this.b1);
                b2 = b0 <= 255 ? b0 : 255;
                break;
            }
            case DIFFERENCE: {
                r0 = Math.abs(r0 - this.r1);
                r2 = r0 < 0 ? -r0 : r0;
                g0 = Math.abs(g0 - this.g1);
                g2 = g0 < 0 ? -g0 : g0;
                b0 = Math.abs(b0 - this.b1);
                b2 = b0 < 0 ? -b0 : b0;
                break;
            }
            case SCREEN: {
                r2 = 255 - ((255 - r0) * (255 - this.r1) >> 8);
                g2 = 255 - ((255 - g0) * (255 - this.g1) >> 8);
                b2 = 255 - ((255 - b0) * (255 - this.b1) >> 8);
                break;
            }
            case LIGHTEN: {
                r2 = this.r1 > r0 ? this.r1 : r0;
                g2 = this.g1 > g0 ? this.g1 : g0;
                b2 = this.b1 > b0 ? this.b1 : b0;
                break;
            }
            case DARKEN: {
                r2 = this.r1 > r0 ? r0 : this.r1;
                g2 = this.g1 > g0 ? g0 : this.g1;
                b2 = this.b1 > b0 ? b0 : this.b1;
                break;
            }
            case EXCLUSION: {
                r2 = r0 + this.r1 - 2 * r0 * this.r1 / 255;
                g2 = g0 + this.g1 - 2 * g0 * this.g1 / 255;
                b2 = b0 + this.b1 - 2 * b0 * this.b1 / 255;
                break;
            }
            case OVERLAY: {
                r2 = r0 < 128 ? 2 * this.r1 * r0 / 255 : 255 - 2 * (255 - this.r1) * (255 - r0) / 255;
                g2 = g0 < 128 ? 2 * this.g1 * g0 / 255 : 255 - 2 * (255 - this.g1) * (255 - g0) / 255;
                b2 = b0 < 128 ? 2 * this.b1 * b0 / 255 : 255 - 2 * (255 - this.b1) * (255 - b0) / 255;
                break;
            }
            case HARDLIGHT: {
                r2 = this.r1 < 128 ? 2 * r0 * this.r1 / 255 : 255 - 2 * (255 - r0) * (255 - this.r1) / 255;
                g2 = this.g1 < 128 ? 2 * g0 * this.g1 / 255 : 255 - 2 * (255 - g0) * (255 - this.g1) / 255;
                b2 = this.b1 < 128 ? 2 * b0 * this.b1 / 255 : 255 - 2 * (255 - b0) * (255 - this.b1) / 255;
                break;
            }
            case SOFTLIGHT: {
                float r0f = (float)r0 / 255.0f;
                float g0f = (float)g0 / 255.0f;
                float b0f = (float)b0 / 255.0f;
                float r2f = (float)((double)this.r1f < 0.5 ? 2.0 * (double)r0f * (double)this.r1f + (double)(r0f * r0f) * (1.0 - 2.0 * (double)this.r1f) : Math.sqrt(r0f) * (2.0 * (double)this.r1f - 1.0) + 2.0 * (double)r0f * (1.0 - (double)this.r1f));
                float g2f = (float)((double)this.g1f < 0.5 ? 2.0 * (double)g0f * (double)this.g1f + (double)(g0f * g0f) * (1.0 - 2.0 * (double)this.g1f) : Math.sqrt(g0f) * (2.0 * (double)this.g1f - 1.0) + 2.0 * (double)g0f * (1.0 - (double)this.g1f));
                float b2f = (float)((double)this.b1f < 0.5 ? 2.0 * (double)b0f * (double)this.b1f + (double)(b0f * b0f) * (1.0 - 2.0 * (double)this.b1f) : Math.sqrt(b0f) * (2.0 * (double)this.b1f - 1.0) + 2.0 * (double)b0f * (1.0 - (double)this.b1f));
                r2 = (int)(r2f * 255.0f);
                g2 = (int)(g2f * 255.0f);
                b2 = (int)(b2f * 255.0f);
                break;
            }
            case LINEARDODGEADD: {
                r2 = Math.min(255, r0 + this.r1);
                g2 = Math.min(255, g0 + this.g1);
                b2 = Math.min(255, b0 + this.b1);
                break;
            }
            case LINEARBURN: {
                r2 = r0 + this.r1 < 255 ? 0 : r0 + this.r1 - 255;
                g2 = g0 + this.g1 < 255 ? 0 : g0 + this.g1 - 255;
                b2 = b0 + this.b1 < 255 ? 0 : b0 + this.b1 - 255;
                break;
            }
            case VIVIDLIGHT: {
                r2 = this.r1 == 0 | this.r1 == 255 ? this.r1 : (this.r1 < 128 ? Math.max(0, 255 - (255 - r0 << 8) / (this.r1 * 2 + 1)) : Math.min((r0 << 8) / (256 - 2 * (this.r1 - 128)), 255));
                g2 = this.g1 == 0 | this.g1 == 255 ? this.g1 : (this.g1 < 128 ? Math.max(0, 255 - (255 - g0 << 8) / (this.g1 * 2 + 1)) : Math.min((g0 << 8) / (256 - 2 * (this.g1 - 128)), 255));
                if (this.b1 == 0 | this.b1 == 255) {
                    b2 = this.b1;
                    break;
                }
                b2 = this.b1 < 128 ? Math.max(0, 255 - (255 - b0 << 8) / (this.b1 * 2 + 1)) : Math.min((b0 << 8) / (256 - 2 * (this.b1 - 128)), 255);
                break;
            }
            case HARDMIX: {
                r2 = this.r1 < 128 ? Math.max(0, 255 - (255 - r0 << 8) / (this.r1 * 2 + 1)) : Math.min((r0 << 8) / (256 - 2 * (this.r1 - 128)), 255);
                r2 = r2 < 128 ? 0 : 255;
                g2 = this.g1 < 128 ? Math.max(0, 255 - (255 - g0 << 8) / (this.g1 * 2 + 1)) : Math.min((g0 << 8) / (256 - 2 * (this.g1 - 128)), 255);
                g2 = g2 < 128 ? 0 : 255;
                b2 = this.b1 < 128 ? Math.max(0, 255 - (255 - b0 << 8) / (this.b1 * 2 + 1)) : Math.min((b0 << 8) / (256 - 2 * (this.b1 - 128)), 255);
                b2 = b2 < 128 ? 0 : 255;
                break;
            }
            case COLORBURN: {
                r2 = Math.max(0, 255 - (255 - r0 << 8) / (this.r1 + 1));
                g2 = Math.max(0, 255 - (255 - g0 << 8) / (this.g1 + 1));
                b2 = Math.max(0, 255 - (255 - b0 << 8) / (this.b1 + 1));
                break;
            }
            case COLORDODGE: {
                r2 = Math.min((r0 << 8) / (256 - this.r1), 255);
                g2 = Math.min((g0 << 8) / (256 - this.g1), 255);
                b2 = Math.min((b0 << 8) / (256 - this.b1), 255);
                break;
            }
            case DARKENCOLOR: {
                if (BaseImageUtils.getBrightnessRGB(r0, g0, b0) >= BaseImageUtils.getBrightnessRGB(this.r1, this.g1, this.b1)) {
                    r2 = this.r1;
                    g2 = this.g1;
                    b2 = this.b1;
                    break;
                }
                r2 = r0;
                g2 = g0;
                b2 = b0;
                break;
            }
            case LIGHTERCOLOR: {
                if (BaseImageUtils.getBrightnessRGB(r0, g0, b0) < BaseImageUtils.getBrightnessRGB(this.r1, this.g1, this.b1)) {
                    r2 = this.r1;
                    g2 = this.g1;
                    b2 = this.b1;
                    break;
                }
                r2 = r0;
                g2 = g0;
                b2 = b0;
                break;
            }
            case LINEARLIGHT: {
                int n = this.r1 < 128 ? (r0 + this.r1 * 2 < 255 ? 0 : r0 + this.r1 * 2 - 255) : (r2 = Math.min(255, r0 + 2 * (this.r1 - 128)));
                int n2 = this.g1 < 128 ? (g0 + this.g1 * 2 < 255 ? 0 : g0 + this.g1 * 2 - 255) : (g2 = Math.min(255, g0 + 2 * (this.g1 - 128)));
                b2 = this.b1 < 128 ? (b0 + this.b1 * 2 < 255 ? 0 : b0 + this.b1 * 2 - 255) : Math.min(255, b0 + 2 * (this.b1 - 128));
                break;
            }
            case PINLIGHT: {
                int n = this.r1 < 128 ? (this.r1 * 2 > r0 ? r0 : this.r1 * 2) : (r2 = 2 * (this.r1 - 128) > r0 ? 2 * (this.r1 - 128) : r0);
                int n3 = this.g1 < 128 ? (this.g1 * 2 > g0 ? g0 : this.g1 * 2) : (g2 = 2 * (this.g1 - 128) > g0 ? 2 * (this.g1 - 128) : g0);
                b2 = this.b1 < 128 ? (this.b1 * 2 > b0 ? b0 : this.b1 * 2) : (2 * (this.b1 - 128) > b0 ? 2 * (this.b1 - 128) : b0);
                break;
            }
            case SUBSTRACT: {
                r2 = r0 - this.r1;
                r2 = r2 < 0 ? 0 : r2;
                g2 = g0 - this.g1;
                g2 = g2 < 0 ? 0 : g2;
                b2 = b0 - this.b1;
                b2 = b2 < 0 ? 0 : b2;
                break;
            }
            case HUEHSL: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)r0 / 255.0f, (float)g0 / 255.0f, (float)b0 / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(this.hsl1[0], hsl0[1], hsl0[2]);
                r2 = (int)(rgb[0] * 255.0f);
                g2 = (int)(rgb[1] * 255.0f);
                b2 = (int)(rgb[2] * 255.0f);
                break;
            }
            case LUMINOSITYHSL: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)r0 / 255.0f, (float)g0 / 255.0f, (float)b0 / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(hsl0[0], hsl0[1], this.hsl1[2]);
                r2 = (int)(rgb[0] * 255.0f);
                g2 = (int)(rgb[1] * 255.0f);
                b2 = (int)(rgb[2] * 255.0f);
                break;
            }
            case SATURATIONHSL: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)r0 / 255.0f, (float)g0 / 255.0f, (float)b0 / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(hsl0[0], this.hsl1[1], hsl0[2]);
                r2 = (int)(rgb[0] * 255.0f);
                g2 = (int)(rgb[1] * 255.0f);
                b2 = (int)(rgb[2] * 255.0f);
                break;
            }
            case COLORHSL: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)r0 / 255.0f, (float)g0 / 255.0f, (float)b0 / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(this.hsl1[0], this.hsl1[1], hsl0[2]);
                r2 = (int)(rgb[0] * 255.0f);
                g2 = (int)(rgb[1] * 255.0f);
                b2 = (int)(rgb[2] * 255.0f);
                break;
            }
            case HUEHSB: {
                int br1 = (int)BaseImageUtils.getBrightnessRGB(r0, g0, b0);
                int[] shsl0 = BaseImageUtils.srgbToHSLInt(r0, g0, b0);
                int[] rgb = BaseImageUtils.hslToSRGBInt(shsl0[0], shsl0[1], br1);
                r2 = rgb[0];
                g2 = rgb[1];
                b2 = rgb[2];
                break;
            }
            case LUMINOSITYHSB: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)r0 / 255.0f, (float)g0 / 255.0f, (float)b0 / 255.0f);
                int min = Math.min(r0, Math.min(g0, b0));
                int max = Math.max(r0, Math.max(g0, b0));
                float sat = max - min;
                float lum = (float)(max + min) / 2.0f;
                float bright0 = BaseImageUtils.getBrightnessRGB(r0, g0, b0);
                if (bright0 > 127.0f) {
                    // empty if block
                }
                float[] rgbt = BaseImageUtils.hslToRgb(hsl0[0], 1.0f, 0.5f);
                float r = BaseImageUtils.scaleValue(rgbt[0], 0.0f, 255.0f, lum - sat / 2.0f, lum + sat / 2.0f);
                float g = BaseImageUtils.scaleValue(rgbt[1], 0.0f, 255.0f, lum - sat / 2.0f, lum + sat / 2.0f);
                float b = BaseImageUtils.scaleValue(rgbt[2], 0.0f, 255.0f, lum - sat / 2.0f, lum + sat / 2.0f);
                r2 = (int)r;
                g2 = (int)g;
                b2 = (int)b;
                break;
            }
            case SATURATIONHSB: {
                int rx = r0;
                int gx = g0;
                int bx = b0;
                r0 = this.r1;
                g0 = this.g1;
                b0 = this.b1;
                this.r1 = rx;
                this.g1 = gx;
                this.b1 = bx;
                int min1 = this.r1 < this.g1 ? this.r1 : this.g1;
                min1 = min1 < this.b1 ? min1 : this.b1;
                int max1 = this.r1 > this.g1 ? this.r1 : this.g1;
                int n = max1 = max1 > this.b1 ? max1 : this.b1;
                if (min1 == max1) {
                    r2 = this.g1;
                    g2 = this.g1;
                    b2 = this.g1;
                    break;
                }
                int min0 = r0 < g0 ? r0 : g0;
                min0 = min0 < b0 ? min0 : b0;
                int max0 = r0 > g0 ? r0 : g0;
                int y = this.r1 * 77 + this.g1 * 151 + this.b1 * 28 + 128 >> 8;
                int scale = ((max0 = max0 > b0 ? max0 : b0) - min0 << 16) / (max1 - min1);
                r2 = y + ((this.r1 - y) * scale + 32768 >> 16);
                if (((r2 | (g2 = y + ((this.g1 - y) * scale + 32768 >> 16)) | (b2 = y + ((this.b1 - y) * scale + 32768 >> 16))) & 0x100) <= 0) break;
                int min2 = r2 < g2 ? r2 : g2;
                min2 = min2 < b2 ? min2 : b2;
                int max2 = r2 > g2 ? r2 : g2;
                max2 = max2 > b2 ? max2 : b2;
                int scalemin = min2 < 0 ? (y << 16) / (y - min2) : 65536;
                int scalemax = max2 > 255 ? (255 - y << 16) / (max2 - y) : 65536;
                scale = scalemin < scalemax ? scalemin : scalemax;
                r2 = y + ((r2 - y) * scale + 32768 >> 16);
                g2 = y + ((g2 - y) * scale + 32768 >> 16);
                b2 = y + ((b2 - y) * scale + 32768 >> 16);
                break;
            }
            case COLORHSB: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)r0 / 255.0f, (float)g0 / 255.0f, (float)b0 / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(this.hsl1[0], this.hsl1[1], hsl0[2]);
                r2 = (int)(rgb[0] * 255.0f);
                g2 = (int)(rgb[1] * 255.0f);
                b2 = (int)(rgb[2] * 255.0f);
                break;
            }
            case GRAINEXTRACT: {
                r2 = BaseImageUtils.clampFT255(r0 - this.r1 + 128);
                g2 = BaseImageUtils.clampFT255(g0 - this.g1 + 128);
                b2 = BaseImageUtils.clampFT255(b0 - this.b1 + 128);
                break;
            }
            case GRAINMERGE: {
                r2 = BaseImageUtils.clampFT255(r0 + this.r1 - 128);
                g2 = BaseImageUtils.clampFT255(g0 + this.g1 - 128);
                b2 = BaseImageUtils.clampFT255(b0 + this.b1 - 128);
                break;
            }
            case DISSOLVE: {
                if (this.opacity < this.pattern[pos % 8192]) {
                    r2 = r0;
                    g2 = g0;
                    b2 = b0;
                    break;
                }
                r2 = this.r1;
                g2 = this.g1;
                b2 = this.b1;
            }
        }
        if (this.opacity >= 0.0f && this.mode != BlendMode.DISSOLVE) {
            r2 = BaseImageUtils.clampFT255((1.0f - this.opacity) * (float)r0 + this.opacity * (float)r2);
            g2 = BaseImageUtils.clampFT255((1.0f - this.opacity) * (float)g0 + this.opacity * (float)g2);
            b2 = BaseImageUtils.clampFT255((1.0f - this.opacity) * (float)b0 + this.opacity * (float)b2);
        }
        return a0 << 24 | r2 << 16 | g2 << 8 | b2;
    }
}

