/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;
import java.util.Random;

public final class ColorOverlay2
extends ColorOperatorImpl {
    private final BlendMode mode;
    private final AlphaMode alphaMode;
    private final float opacity;
    private float[] pattern;
    private final int patternLength = 8192;

    public ColorOverlay2(BlendMode mode, float opacity) throws ImageManipulatorException {
        this(mode, AlphaMode.NORMAL, opacity);
    }

    public ColorOverlay2(BlendMode mode, AlphaMode alphaMode, float opacity) throws ImageManipulatorException {
        if (opacity < 0.0f || opacity > 100.0f) {
            throw new ImageManipulatorException("Opacity value out of range (0-100): " + opacity);
        }
        this.mode = mode;
        this.alphaMode = alphaMode;
        this.opacity = opacity / 100.0f;
        if (mode == BlendMode.DISSOLVE) {
            this.initDissolvePattern();
        }
    }

    public ColorOverlay2(BlendMode mode, AlphaMode alphaMode) {
        this.mode = mode;
        this.alphaMode = alphaMode;
        if (mode == BlendMode.DISSOLVE) {
            this.initDissolvePattern();
        }
        this.opacity = 0.0f;
    }

    private void initDissolvePattern() {
        this.pattern = new float[8192];
        Random rand = new Random(71262782L);
        for (int c = 0; c < 8192; ++c) {
            this.pattern[c] = rand.nextFloat();
        }
    }

    @Override
    public int transform(int argb, int pos) {
        return 0;
    }

    public final int transform(int sourceARGB, int overlayARGB, int dissolvePos) {
        return this.transform(sourceARGB, overlayARGB, dissolvePos, this.opacity);
    }

    public final int transform(int sourceARGB, int overlayARGB, int dissolvePos, float opacity) {
        float os;
        float ox;
        int sA = sourceARGB >>> 24;
        int sR = sourceARGB >> 16 & 0xFF;
        int sG = sourceARGB >> 8 & 0xFF;
        int sB = sourceARGB & 0xFF;
        float sA01 = (float)sA / 255.0f;
        int oA = overlayARGB >>> 24;
        int oR = overlayARGB >> 16 & 0xFF;
        int oG = overlayARGB >> 8 & 0xFF;
        int oB = overlayARGB & 0xFF;
        float oA01 = opacity * (float)oA / 255.0f;
        int dR = sR;
        int dG = sG;
        int dB = sB;
        switch (this.mode) {
            case NORMAL: {
                dR = oR;
                dG = oG;
                dB = oB;
                break;
            }
            case MULTIPLY: {
                dR = sR * oR / 255;
                dG = sG * oG / 255;
                dB = sB * oB / 255;
                break;
            }
            case DIVIDE: {
                sR = sR * 256 / (1 + oR);
                dR = sR <= 255 ? sR : 255;
                sG = sG * 256 / (1 + oG);
                dG = sG <= 255 ? sG : 255;
                sB = sB * 256 / (1 + oB);
                dB = sB <= 255 ? sB : 255;
                break;
            }
            case DIFFERENCE: {
                sR = Math.abs(sR - oR);
                dR = sR < 0 ? -sR : sR;
                sG = Math.abs(sG - oG);
                dG = sG < 0 ? -sG : sG;
                sB = Math.abs(sB - oB);
                dB = sB < 0 ? -sB : sB;
                break;
            }
            case SCREEN: {
                dR = 255 - ((255 - sR) * (255 - oR) >> 8);
                dG = 255 - ((255 - sG) * (255 - oG) >> 8);
                dB = 255 - ((255 - sB) * (255 - oB) >> 8);
                break;
            }
            case LIGHTEN: {
                dR = oR > sR ? oR : sR;
                dG = oG > sG ? oG : sG;
                dB = oB > sB ? oB : sB;
                break;
            }
            case DARKEN: {
                dR = oR > sR ? sR : oR;
                dG = oG > sG ? sG : oG;
                dB = oB > sB ? sB : oB;
                break;
            }
            case EXCLUSION: {
                dR = sR + oR - 2 * sR * oR / 255;
                dG = sG + oG - 2 * sG * oG / 255;
                dB = sB + oB - 2 * sB * oB / 255;
                break;
            }
            case OVERLAY: {
                dR = sR < 128 ? 2 * oR * sR / 255 : 255 - 2 * (255 - oR) * (255 - sR) / 255;
                dG = sG < 128 ? 2 * oG * sG / 255 : 255 - 2 * (255 - oG) * (255 - sG) / 255;
                dB = sB < 128 ? 2 * oB * sB / 255 : 255 - 2 * (255 - oB) * (255 - sB) / 255;
                break;
            }
            case HARDLIGHT: {
                dR = oR < 128 ? 2 * sR * oR / 255 : 255 - 2 * (255 - sR) * (255 - oR) / 255;
                dG = oG < 128 ? 2 * sG * oG / 255 : 255 - 2 * (255 - sG) * (255 - oG) / 255;
                dB = oB < 128 ? 2 * sB * oB / 255 : 255 - 2 * (255 - sB) * (255 - oB) / 255;
                break;
            }
            case SOFTLIGHT: {
                float r0f = (float)sR / 255.0f;
                float g0f = (float)sG / 255.0f;
                float b0f = (float)sB / 255.0f;
                float r1f = (float)oR / 255.0f;
                float g1f = (float)oG / 255.0f;
                float b1f = (float)oB / 255.0f;
                float r2f = (float)((double)r1f < 0.5 ? 2.0 * (double)r0f * (double)r1f + (double)(r0f * r0f) * (1.0 - 2.0 * (double)r1f) : Math.sqrt(r0f) * (2.0 * (double)r1f - 1.0) + 2.0 * (double)r0f * (1.0 - (double)r1f));
                float g2f = (float)((double)g1f < 0.5 ? 2.0 * (double)g0f * (double)g1f + (double)(g0f * g0f) * (1.0 - 2.0 * (double)g1f) : Math.sqrt(g0f) * (2.0 * (double)g1f - 1.0) + 2.0 * (double)g0f * (1.0 - (double)g1f));
                float b2f = (float)((double)b1f < 0.5 ? 2.0 * (double)b0f * (double)b1f + (double)(b0f * b0f) * (1.0 - 2.0 * (double)b1f) : Math.sqrt(b0f) * (2.0 * (double)b1f - 1.0) + 2.0 * (double)b0f * (1.0 - (double)b1f));
                dR = (int)(r2f * 255.0f);
                dG = (int)(g2f * 255.0f);
                dB = (int)(b2f * 255.0f);
                break;
            }
            case LINEARDODGEADD: {
                dR = Math.min(255, sR + oR);
                dG = Math.min(255, sG + oG);
                dB = Math.min(255, sB + oB);
                break;
            }
            case LINEARBURN: {
                dR = sR + oR < 255 ? 0 : sR + oR - 255;
                dG = sG + oG < 255 ? 0 : sG + oG - 255;
                dB = sB + oB < 255 ? 0 : sB + oB - 255;
                break;
            }
            case VIVIDLIGHT: {
                dR = oR == 0 | oR == 255 ? oR : (oR < 128 ? Math.max(0, 255 - (255 - sR << 8) / (oR * 2 + 1)) : Math.min((sR << 8) / (256 - 2 * (oR - 128)), 255));
                dG = oG == 0 | oG == 255 ? oG : (oG < 128 ? Math.max(0, 255 - (255 - sG << 8) / (oG * 2 + 1)) : Math.min((sG << 8) / (256 - 2 * (oG - 128)), 255));
                if (oB == 0 | oB == 255) {
                    dB = oB;
                    break;
                }
                dB = oB < 128 ? Math.max(0, 255 - (255 - sB << 8) / (oB * 2 + 1)) : Math.min((sB << 8) / (256 - 2 * (oB - 128)), 255);
                break;
            }
            case HARDMIX: {
                dR = oR < 128 ? Math.max(0, 255 - (255 - sR << 8) / (oR * 2 + 1)) : Math.min((sR << 8) / (256 - 2 * (oR - 128)), 255);
                dR = dR < 128 ? 0 : 255;
                dG = oG < 128 ? Math.max(0, 255 - (255 - sG << 8) / (oG * 2 + 1)) : Math.min((sG << 8) / (256 - 2 * (oG - 128)), 255);
                dG = dG < 128 ? 0 : 255;
                dB = oB < 128 ? Math.max(0, 255 - (255 - sB << 8) / (oB * 2 + 1)) : Math.min((sB << 8) / (256 - 2 * (oB - 128)), 255);
                dB = dB < 128 ? 0 : 255;
                break;
            }
            case COLORBURN: {
                dR = Math.max(0, 255 - (255 - sR << 8) / (oR + 1));
                dG = Math.max(0, 255 - (255 - sG << 8) / (oG + 1));
                dB = Math.max(0, 255 - (255 - sB << 8) / (oB + 1));
                break;
            }
            case COLORDODGE: {
                dR = Math.min((sR << 8) / (256 - oR), 255);
                dG = Math.min((sG << 8) / (256 - oG), 255);
                dB = Math.min((sB << 8) / (256 - oB), 255);
                break;
            }
            case DARKENCOLOR: {
                if (BaseImageUtils.getBrightnessRGB(sR, sG, sB) >= BaseImageUtils.getBrightnessRGB(oR, oG, oB)) {
                    dR = oR;
                    dG = oG;
                    dB = oB;
                    break;
                }
                dR = sR;
                dG = sG;
                dB = sB;
                break;
            }
            case LIGHTERCOLOR: {
                if (BaseImageUtils.getBrightnessRGB(sR, sG, sB) < BaseImageUtils.getBrightnessRGB(oR, oG, oB)) {
                    dR = oR;
                    dG = oG;
                    dB = oB;
                    break;
                }
                dR = sR;
                dG = sG;
                dB = sB;
                break;
            }
            case LINEARLIGHT: {
                int n = oR < 128 ? (sR + oR * 2 < 255 ? 0 : sR + oR * 2 - 255) : (dR = Math.min(255, sR + 2 * (oR - 128)));
                int n2 = oG < 128 ? (sG + oG * 2 < 255 ? 0 : sG + oG * 2 - 255) : (dG = Math.min(255, sG + 2 * (oG - 128)));
                dB = oB < 128 ? (sB + oB * 2 < 255 ? 0 : sB + oB * 2 - 255) : Math.min(255, sB + 2 * (oB - 128));
                break;
            }
            case PINLIGHT: {
                int n = oR < 128 ? (oR * 2 > sR ? sR : oR * 2) : (dR = 2 * (oR - 128) > sR ? 2 * (oR - 128) : sR);
                int n3 = oG < 128 ? (oG * 2 > sG ? sG : oG * 2) : (dG = 2 * (oG - 128) > sG ? 2 * (oG - 128) : sG);
                dB = oB < 128 ? (oB * 2 > sB ? sB : oB * 2) : (2 * (oB - 128) > sB ? 2 * (oB - 128) : sB);
                break;
            }
            case SUBSTRACT: {
                dR = sR - oR;
                dR = dR < 0 ? 0 : dR;
                dG = sG - oG;
                dG = dG < 0 ? 0 : dG;
                dB = sB - oB;
                dB = dB < 0 ? 0 : dB;
                break;
            }
            case HUEHSL: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)sR / 255.0f, (float)sG / 255.0f, (float)sB / 255.0f);
                float[] hsl1 = BaseImageUtils.rgbToHsl((float)oR / 255.0f, (float)oG / 255.0f, (float)oB / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(hsl1[0], hsl0[1], hsl0[2]);
                dR = (int)(rgb[0] * 255.0f);
                dG = (int)(rgb[1] * 255.0f);
                dB = (int)(rgb[2] * 255.0f);
                break;
            }
            case LUMINOSITYHSL: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)sR / 255.0f, (float)sG / 255.0f, (float)sB / 255.0f);
                float[] hsl1 = BaseImageUtils.rgbToHsl((float)oR / 255.0f, (float)oG / 255.0f, (float)oB / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(hsl0[0], hsl0[1], hsl1[2]);
                dR = (int)(rgb[0] * 255.0f);
                dG = (int)(rgb[1] * 255.0f);
                dB = (int)(rgb[2] * 255.0f);
                break;
            }
            case SATURATIONHSL: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)sR / 255.0f, (float)sG / 255.0f, (float)sB / 255.0f);
                float[] hsl1 = BaseImageUtils.rgbToHsl((float)oR / 255.0f, (float)oG / 255.0f, (float)oB / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(hsl0[0], hsl1[1], hsl0[2]);
                dR = (int)(rgb[0] * 255.0f);
                dG = (int)(rgb[1] * 255.0f);
                dB = (int)(rgb[2] * 255.0f);
                break;
            }
            case COLORHSL: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)sR / 255.0f, (float)sG / 255.0f, (float)sB / 255.0f);
                float[] hsl1 = BaseImageUtils.rgbToHsl((float)oR / 255.0f, (float)oG / 255.0f, (float)oB / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(hsl1[0], hsl1[1], hsl0[2]);
                dR = (int)(rgb[0] * 255.0f);
                dG = (int)(rgb[1] * 255.0f);
                dB = (int)(rgb[2] * 255.0f);
                break;
            }
            case HUEHSB: {
                int br1 = (int)BaseImageUtils.getBrightnessRGB(sR, sG, sB);
                int[] shsl0 = BaseImageUtils.srgbToHSLInt(sR, sG, sB);
                int[] rgb = BaseImageUtils.hslToSRGBInt(shsl0[0], shsl0[1], br1);
                dR = rgb[0];
                dG = rgb[1];
                dB = rgb[2];
                break;
            }
            case LUMINOSITYHSB: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)sR / 255.0f, (float)sG / 255.0f, (float)sB / 255.0f);
                float s = (float)(Math.max(sR, Math.max(sG, sB)) - Math.min(sR, Math.min(sG, sB))) / 255.0f;
                int min = Math.min(sR, Math.min(sG, sB));
                int max = Math.max(sR, Math.max(sG, sB));
                float sat = max - min;
                float lumi0 = (float)sR * 0.3f + (float)sG * 0.59f + (float)sB * 0.11f;
                float luma0 = (float)sR * 0.2126f + (float)sG * 0.7152f + (float)sB * 0.0722f;
                float lum = (float)(max + min) / 2.0f;
                float lumRGB1 = BaseImageUtils.getBrightnessRGB(oR, oG, oB);
                float lumRGB1255 = lumRGB1 / 255.0f;
                if (lumRGB1255 >= lumi0) {
                    float Smax = 255.0f * (255.0f - lumRGB1) / (255.0f - lumi0);
                } else {
                    float Smax = lumRGB1 / lumi0 * 255.0f;
                }
                float bright0 = BaseImageUtils.getBrightnessRGB(sR, sG, sB);
                if (bright0 > 127.0f) {
                    // empty if block
                }
                float[] rgbt = BaseImageUtils.hslToRgb(hsl0[0], 1.0f, 0.5f);
                float r = BaseImageUtils.scaleValue(rgbt[0], 0.0f, 255.0f, lum - sat / 2.0f, lum + sat / 2.0f);
                float g = BaseImageUtils.scaleValue(rgbt[1], 0.0f, 255.0f, lum - sat / 2.0f, lum + sat / 2.0f);
                float b = BaseImageUtils.scaleValue(rgbt[2], 0.0f, 255.0f, lum - sat / 2.0f, lum + sat / 2.0f);
                dR = (int)r;
                dG = (int)g;
                dB = (int)b;
                float[] fArray = BaseImageUtils.hslToRgb(hsl0[0], sat / 255.0f, lum / 255.0f);
                break;
            }
            case SATURATIONHSB: {
                int rx = sR;
                int gx = sG;
                int bx = sB;
                sR = oR;
                sG = oG;
                sB = oB;
                oR = rx;
                oG = gx;
                oB = bx;
                int min1 = oR < oG ? oR : oG;
                min1 = min1 < oB ? min1 : oB;
                int max1 = oR > oG ? oR : oG;
                int n = max1 = max1 > oB ? max1 : oB;
                if (min1 == max1) {
                    dR = oG;
                    dG = oG;
                    dB = oG;
                    break;
                }
                int min0 = sR < sG ? sR : sG;
                min0 = min0 < sB ? min0 : sB;
                int max0 = sR > sG ? sR : sG;
                int y = oR * 77 + oG * 151 + oB * 28 + 128 >> 8;
                int scale = ((max0 = max0 > sB ? max0 : sB) - min0 << 16) / (max1 - min1);
                dR = y + ((oR - y) * scale + 32768 >> 16);
                if (((dR | (dG = y + ((oG - y) * scale + 32768 >> 16)) | (dB = y + ((oB - y) * scale + 32768 >> 16))) & 0x100) <= 0) break;
                int min2 = dR < dG ? dR : dG;
                min2 = min2 < dB ? min2 : dB;
                int max2 = dR > dG ? dR : dG;
                max2 = max2 > dB ? max2 : dB;
                int scalemin = min2 < 0 ? (y << 16) / (y - min2) : 65536;
                int scalemax = max2 > 255 ? (255 - y << 16) / (max2 - y) : 65536;
                scale = scalemin < scalemax ? scalemin : scalemax;
                dR = y + ((dR - y) * scale + 32768 >> 16);
                dG = y + ((dG - y) * scale + 32768 >> 16);
                dB = y + ((dB - y) * scale + 32768 >> 16);
                break;
            }
            case COLORHSB: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)sR / 255.0f, (float)sG / 255.0f, (float)sB / 255.0f);
                float[] hsl1 = BaseImageUtils.rgbToHsl((float)oR / 255.0f, (float)oG / 255.0f, (float)oB / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(hsl1[0], hsl1[1], hsl0[2]);
                dR = (int)(rgb[0] * 255.0f);
                dG = (int)(rgb[1] * 255.0f);
                dB = (int)(rgb[2] * 255.0f);
                break;
            }
            case GRAINEXTRACT: {
                dR = BaseImageUtils.clampFT255(sR - oR + 128);
                dG = BaseImageUtils.clampFT255(sG - oG + 128);
                dB = BaseImageUtils.clampFT255(sB - oB + 128);
                break;
            }
            case GRAINMERGE: {
                dR = BaseImageUtils.clampFT255(sR + oR - 128);
                dG = BaseImageUtils.clampFT255(sG + oG - 128);
                dB = BaseImageUtils.clampFT255(sB + oB - 128);
                break;
            }
            case DISSOLVE: {
                if (opacity < this.pattern[dissolvePos % 8192]) {
                    dR = sR;
                    dG = sG;
                    dB = sB;
                    break;
                }
                dR = oR;
                dG = oG;
                dB = oB;
            }
        }
        int dA = 0;
        if (this.alphaMode == AlphaMode.NORMAL) {
            ox = sA01 * (1.0f - oA01);
            os = oA01 + ox;
            float dA01 = 1.0f - (1.0f - sA01) * (1.0f - oA01);
            dA = BaseImageUtils.clampFT255(dA01 * 255.0f);
            if (dA == 0) {
                dR = sR;
                dG = sG;
                dB = sB;
            } else if (oA01 < 1.0f && this.mode != BlendMode.DISSOLVE) {
                dR = BaseImageUtils.clampFT255((float)dR * oA01 / os + (float)sR * ox / os);
                dG = BaseImageUtils.clampFT255((float)dG * oA01 / os + (float)sG * ox / os);
                dB = BaseImageUtils.clampFT255((float)dB * oA01 / os + (float)sB * ox / os);
            }
        } else if (this.alphaMode == AlphaMode.MIN) {
            ox = sA01 * (1.0f - oA01);
            os = oA01 + ox;
            int n = dA = sA < oA ? sA : oA;
            if (oA01 < 1.0f && this.mode != BlendMode.DISSOLVE) {
                dR = BaseImageUtils.clampFT255((float)dR * oA01 / os + (float)sR * ox / os);
                dG = BaseImageUtils.clampFT255((float)dG * oA01 / os + (float)sG * ox / os);
                dB = BaseImageUtils.clampFT255((float)dB * oA01 / os + (float)sB * ox / os);
            }
        } else if (this.alphaMode == AlphaMode.MAX) {
            ox = sA01 * (1.0f - oA01);
            os = oA01 + ox;
            int n = dA = sA > oA ? sA : oA;
            if (oA01 < 1.0f && this.mode != BlendMode.DISSOLVE) {
                dR = BaseImageUtils.clampFT255((float)dR * oA01 / os + (float)sR * ox / os);
                dG = BaseImageUtils.clampFT255((float)dG * oA01 / os + (float)sG * ox / os);
                dB = BaseImageUtils.clampFT255((float)dB * oA01 / os + (float)sB * ox / os);
            }
        } else if (this.alphaMode == AlphaMode.BASE) {
            ox = sA01 * (1.0f - oA01);
            os = oA01 + ox;
            dA = sA;
            if (oA01 < 1.0f && this.mode != BlendMode.DISSOLVE) {
                dR = BaseImageUtils.clampFT255((float)dR * oA01 / os + (float)sR * ox / os);
                dG = BaseImageUtils.clampFT255((float)dG * oA01 / os + (float)sG * ox / os);
                dB = BaseImageUtils.clampFT255((float)dB * oA01 / os + (float)sB * ox / os);
            }
        } else if (this.alphaMode == AlphaMode.OVERLAY) {
            ox = sA01 * (1.0f - oA01);
            os = oA01 + ox;
            dA = oA;
            if (oA01 < 1.0f && this.mode != BlendMode.DISSOLVE) {
                dR = BaseImageUtils.clampFT255((float)dR * oA01 / os + (float)sR * ox / os);
                dG = BaseImageUtils.clampFT255((float)dG * oA01 / os + (float)sG * ox / os);
                dB = BaseImageUtils.clampFT255((float)dB * oA01 / os + (float)sB * ox / os);
            }
        }
        return dA << 24 | dR << 16 | dG << 8 | dB;
    }
}

