/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class Colorize
extends ColorOperatorImpl {
    private final float lightness;
    private final float[] lum_red_lookup = new float[256];
    private final float[] lum_green_lookup = new float[256];
    private final float[] lum_blue_lookup = new float[256];
    private final float[] final_red_lookup = new float[256];
    private final float[] final_green_lookup = new float[256];
    private final float[] final_blue_lookup = new float[256];

    public Colorize(float hueShift, float saturation, float lightness) throws ImageManipulatorException {
        hueShift %= 360.0f;
        if (hueShift < 0.0f) {
            hueShift = 360.0f - hueShift;
        }
        if (saturation < 0.0f) {
            saturation = 0.0f;
        } else if (saturation > 100.0f) {
            saturation = 100.0f;
        }
        if (lightness < 0.0f) {
            lightness = 0.0f;
        } else if (lightness > 100.0f) {
            lightness = 100.0f;
        }
        this.lightness = lightness;
        for (int i = 0; i < 256; ++i) {
            this.lum_red_lookup[i] = (float)i * 0.2126f;
            this.lum_green_lookup[i] = (float)i * 0.7152f;
            this.lum_blue_lookup[i] = (float)i * 0.0722f;
        }
        float hslH = hueShift / 360.0f;
        float hslS = saturation / 100.0f;
        for (int i = 0; i < 256; ++i) {
            float hslL = (float)i / 255.0f;
            float[] rgb = BaseImageUtils.hslToRgb(hslH, hslS, hslL);
            this.final_red_lookup[i] = 255.0f * rgb[0];
            this.final_green_lookup[i] = 255.0f * rgb[1];
            this.final_blue_lookup[i] = 255.0f * rgb[2];
        }
    }

    @Override
    public int transform(int argb, int pos) {
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        int lum = (int)(this.lum_red_lookup[red] + this.lum_green_lookup[green] + this.lum_blue_lookup[blue]);
        if (this.lightness > 0.0f) {
            lum = (int)((double)lum * (double)(100.0f - this.lightness) / 100.0);
            lum = (int)((float)lum + (255.0f - (100.0f - this.lightness) * 255.0f / 100.0f));
        } else if (this.lightness < 0.0f) {
            lum = (int)((double)lum * (double)(this.lightness + 100.0f) / 100.0);
        }
        return alpha << 24 | (int)this.final_red_lookup[lum] << 16 | (int)this.final_green_lookup[lum] << 8 | (int)this.final_blue_lookup[lum];
    }
}

