/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public class Desaturate
extends ColorOperatorImpl {
    private final Mode mode;

    public Desaturate(Mode mode) {
        this.mode = mode;
    }

    public Desaturate(String mode) {
        try {
            this.mode = Mode.valueOf(mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ImageManipulatorException("Invalid Desaturate mode " + mode);
        }
    }

    @Override
    public int transform(int argb, int pos) {
        int result;
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        switch (this.mode) {
            case AVERAGE: {
                int average = (red + green + blue + 1) / 3;
                result = alpha << 24 | average << 16 | average << 8 | average;
                break;
            }
            case LIGHTNESS: {
                int lightness = (Math.max(Math.max(red, green), blue) + Math.min(Math.min(red, green), blue)) / 2;
                result = alpha << 24 | lightness << 16 | lightness << 8 | lightness;
                break;
            }
            case LUMINOSITY: {
                int luminosity = (int)BaseImageUtils.getBrightnessRGB(red, green, blue);
                result = alpha << 24 | luminosity << 16 | luminosity << 8 | luminosity;
                break;
            }
            case SATURATION: {
                float[] hsl0 = BaseImageUtils.rgbToHsl((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
                float[] rgb = BaseImageUtils.hslToRgb(hsl0[0], 0.0f, hsl0[2]);
                result = alpha << 24 | (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public static enum Mode {
        AVERAGE,
        LIGHTNESS,
        LUMINOSITY,
        SATURATION;

    }
}

