/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;

public class Fill
extends ColorOperatorImpl {
    private int fillColor;
    private boolean keepAlpha;

    public Fill(int fillColor, boolean keepAlpha) {
        this.fillColor = fillColor;
        this.keepAlpha = keepAlpha;
    }

    @Override
    public int transform(int argb, int pos) {
        if (!this.keepAlpha) {
            argb = this.fillColor;
        } else {
            int alpha = BaseImageUtils.clampFT255((argb >>> 24) + (this.fillColor >>> 24));
            argb = alpha << 24 | this.fillColor & 0xFFFFFF;
        }
        return argb;
    }
}

