/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class Gamma
extends ColorOperatorImpl {
    private final int[] lut = new int[256];
    private final PATTERN channel;

    public Gamma(float gamma, String channelPattern) throws ImageManipulatorException {
        try {
            this.channel = PATTERN.valueOf(channelPattern.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ImageManipulatorException("Invalid Pattern " + channelPattern);
        }
        if ((double)gamma < 0.1) {
            gamma = 0.1f;
        } else if ((double)gamma > 9.99) {
            gamma = 9.99f;
        }
        gamma = 1.0f / gamma;
        for (int i = 0; i < 256; ++i) {
            this.lut[i] = BaseImageUtils.clampFT255(255.0 * Math.pow((float)i / 255.0f, gamma));
        }
    }

    @Override
    public final int transform(int argb, int pos) {
        int newargb;
        int alpha = argb >>> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        switch (this.channel) {
            case RED: {
                newargb = alpha << 24 | this.lut[r] << 16 | g << 8 | b;
                break;
            }
            case GREEN: {
                newargb = alpha << 24 | r << 16 | this.lut[g] << 8 | b;
                break;
            }
            case BLUE: {
                newargb = alpha << 24 | r << 16 | g << 8 | this.lut[b];
                break;
            }
            default: {
                newargb = alpha << 24 | this.lut[r] << 16 | this.lut[g] << 8 | this.lut[b];
            }
        }
        return newargb;
    }

    private static enum PATTERN {
        RED,
        GREEN,
        BLUE,
        ALL;

    }
}

