/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.helper.Gradient;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;

public final class GradientMap
extends ColorOperatorImpl {
    private final Mode mode;
    private final int[] argbLut;

    public GradientMap(Gradient gradient, String mode) {
        int glen;
        this.mode = Mode.valueOf(mode.toUpperCase());
        this.argbLut = new int[256];
        int curpos = 0;
        int nextpos = 255;
        int curargb = 0;
        int nextargb = 0;
        int gpos = 0;
        int gradpos = 0;
        int[] gradpositions = gradient.getPositions();
        int gradlen = gradpositions.length;
        if (gradlen > 0) {
            curpos = gradpositions[0];
            curargb = gradient.getValue(curpos);
            if (gradlen > 1) {
                nextpos = gradpositions[1];
                nextargb = gradient.getValue(nextpos);
                ++gradpos;
            }
        }
        int shiftLen = glen = nextpos - curpos + 1;
        for (int p = 0; p < 256; ++p) {
            this.argbLut[p] = GradientMap.shiftARGB(curargb, nextargb, shiftLen, gpos);
            if (++gpos != glen || p >= 255) continue;
            curargb = nextargb;
            curpos = nextpos;
            nextpos = gradpositions[++gradpos];
            shiftLen = nextpos - curpos + 1;
            glen = nextpos - curpos + 1;
            nextargb = gradient.getValue(nextpos);
            gpos = 1;
        }
    }

    @Override
    public final int transform(int argb, int pos) {
        int gray;
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        switch (this.mode) {
            case AVERAGE: {
                gray = (red + green + blue + 1) / 3;
                break;
            }
            case LIGHTNESS: {
                gray = (Math.max(Math.max(red, green), blue) + Math.min(Math.min(red, green), blue)) / 2;
                break;
            }
            case LUMINOSITY: {
                gray = (int)BaseImageUtils.getBrightnessRGB(red, green, blue);
                break;
            }
            default: {
                gray = 0;
            }
        }
        int lutAlpha = 255 - (this.argbLut[gray] >>> 24 & 0xFF);
        int lutRGB = this.argbLut[gray] & 0xFFFFFF;
        int result = Math.min(alpha, lutAlpha) << 24 | lutRGB;
        return result;
    }

    private static final int shiftARGB(int argb1, int argb2, int len, int pos) {
        int a1 = argb1 >>> 24 & 0xFF;
        int r1 = argb1 >> 16 & 0xFF;
        int g1 = argb1 >> 8 & 0xFF;
        int b1 = argb1 & 0xFF;
        int a2 = argb2 >>> 24 & 0xFF;
        int r2 = argb2 >> 16 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int b2 = argb2 & 0xFF;
        int ad = a1 - a2;
        int rd = r1 - r2;
        int gd = g1 - g2;
        int bd = b1 - b2;
        float len2 = len - 1;
        float as = (float)ad / len2;
        float rs = (float)rd / len2;
        float gs = (float)gd / len2;
        float bs = (float)bd / len2;
        int a3 = (int)((float)a1 - as * (float)pos);
        int r3 = (int)((float)r1 - rs * (float)pos);
        int g3 = (int)((float)g1 - gs * (float)pos);
        int b3 = (int)((float)b1 - bs * (float)pos);
        return a3 << 24 | r3 << 16 | g3 << 8 | b3;
    }

    public static enum Mode {
        AVERAGE,
        LIGHTNESS,
        LUMINOSITY;

    }
}

