/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;
import java.util.ArrayList;

public final class HueSaturation
extends ColorOperatorImpl {
    private final float overlap;
    private final float[] hueContrib = new float[7];
    private final float[] lightnessContrib = new float[7];
    private final float[] saturationContrib = new float[7];
    private final int[][] hueTransfer = new int[6][256];
    private final int[][] lightnessTransfer = new int[6][256];
    private final int[][] saturationTransfer = new int[6][256];
    private static final int[] hueThresholds = new int[]{21, 64, 106, 149, 192, 234, 255};
    private final ArrayList<HUERANGES> activeRanges = new ArrayList();

    public HueSaturation(float hueShift, float saturationValue, float lightnessValue, String[] ranges, float overlap) throws ImageManipulatorException {
        this.overlap = overlap;
        for (String range : ranges) {
            try {
                HUERANGES huerange = HUERANGES.valueOf(range.toUpperCase());
                this.activeRanges.add(huerange);
            }
            catch (IllegalArgumentException e) {
                throw new ImageManipulatorException("Invalid Color Range " + range);
            }
        }
        this.init(hueShift, saturationValue, lightnessValue);
    }

    public HueSaturation(float hueShift, float saturationValue, float lightnessValue, String rangesStr, float overlap) throws ImageManipulatorException {
        String[] ranges;
        this.overlap = overlap;
        for (String range : ranges = rangesStr.toUpperCase().split("[,:;]")) {
            try {
                HUERANGES huerange = HUERANGES.valueOf(range);
                this.activeRanges.add(huerange);
            }
            catch (IllegalArgumentException e) {
                throw new ImageManipulatorException("Invalid Color Range " + range);
            }
        }
        this.init(hueShift, saturationValue, lightnessValue);
    }

    private void init(float hueShift, float saturationValue, float lightnessValue) {
        if (hueShift < -180.0f) {
            hueShift = -180.0f;
        } else if (hueShift > 180.0f) {
            hueShift = 180.0f;
        }
        if (saturationValue < -100.0f) {
            saturationValue = -100.0f;
        } else if (saturationValue > 100.0f) {
            saturationValue = 100.0f;
        }
        if (lightnessValue < -100.0f) {
            lightnessValue = -100.0f;
        } else if (lightnessValue > 100.0f) {
            lightnessValue = 100.0f;
        }
        for (HUERANGES huerange : HUERANGES.values()) {
            this.hueContrib[huerange.ordinal()] = 0.0f;
            this.lightnessContrib[huerange.ordinal()] = 0.0f;
            this.saturationContrib[huerange.ordinal()] = 0.0f;
        }
        for (HUERANGES huerange : this.activeRanges) {
            this.hueContrib[huerange.ordinal()] = hueShift;
            this.lightnessContrib[huerange.ordinal()] = lightnessValue;
            this.saturationContrib[huerange.ordinal()] = saturationValue;
        }
        for (int hue = 0; hue < 6; ++hue) {
            for (int i = 0; i < 256; ++i) {
                float value = (this.hueContrib[0] + this.hueContrib[hue + 1]) * 255.0f / 360.0f;
                this.hueTransfer[hue][i] = (float)i + value < 0.0f ? (int)(255.0f + ((float)i + value)) : ((float)i + value > 255.0f ? (int)((float)i + value - 255.0f) : (int)((float)i + value));
                value = (this.lightnessContrib[0] + this.lightnessContrib[hue + 1]) * 127.0f / 100.0f;
                value = BaseImageUtils.clampFT(value, -255, 255);
                this.lightnessTransfer[hue][i] = value < 0.0f ? (int)((float)i * (255.0f + value) / 255.0f) : (int)((float)i + (float)(255 - i) * value / 255.0f);
                value = (this.saturationContrib[0] + this.saturationContrib[hue + 1]) * 255.0f / 100.0f;
                value = BaseImageUtils.clampFT(value, -255, 255);
                this.saturationTransfer[hue][i] = BaseImageUtils.clampFT255((float)i * (255.0f + value) / 255.0f);
            }
        }
    }

    @Override
    public final int transform(int argb, int pos) {
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        int[] hsl = BaseImageUtils.srgbToHSLInt(red, green, blue);
        int h = hsl[0];
        int s = hsl[1];
        int l = hsl[2];
        int h6 = (h + 21) / 6;
        int hue = 0;
        float overlap_hue = this.overlap / 100.0f * 21.0f;
        int secondary_hue = 0;
        boolean use_secondary_hue = false;
        float primary_intensity = 0.0f;
        float secondary_intensity = 0.0f;
        for (int hue_counter = 0; hue_counter < 7; ++hue_counter) {
            if (!((float)h < (float)hueThresholds[hue_counter] + overlap_hue)) continue;
            int hue_threshold = hueThresholds[hue_counter];
            hue = hue_counter;
            if ((double)overlap_hue > 0.0 && (float)h6 > (float)hue_threshold - overlap_hue) {
                secondary_hue = hue_counter + 1;
                use_secondary_hue = true;
                secondary_intensity = ((float)(h - hue_threshold) + overlap_hue) / (2.0f * overlap_hue);
                primary_intensity = 1.0f - secondary_intensity;
                break;
            }
            use_secondary_hue = false;
            break;
        }
        if (hue >= 6) {
            hue = 0;
            use_secondary_hue = false;
        }
        if (secondary_hue >= 6) {
            secondary_hue = 0;
        }
        if (use_secondary_hue) {
            int diff = this.hueTransfer[hue][h] - this.hueTransfer[secondary_hue][h];
            h = diff < -127 || diff >= 128 ? (int)((float)this.hueTransfer[hue][h] * primary_intensity + (float)(this.hueTransfer[secondary_hue][h] + 255) * secondary_intensity) % 255 : (int)((float)this.hueTransfer[hue][h] * primary_intensity + (float)this.hueTransfer[secondary_hue][h] * secondary_intensity);
            s = (int)((float)this.saturationTransfer[hue][s] * primary_intensity + (float)this.saturationTransfer[secondary_hue][s] * secondary_intensity);
            l = (int)((float)this.lightnessTransfer[hue][l] * primary_intensity + (float)this.lightnessTransfer[secondary_hue][l] * secondary_intensity);
        } else {
            h = this.hueTransfer[hue][h];
            s = this.saturationTransfer[hue][s];
            l = this.lightnessTransfer[hue][l];
        }
        hsl = BaseImageUtils.hslToSRGBInt(h, s, l);
        return alpha << 24 | hsl[0] << 16 | hsl[1] << 8 | hsl[2];
    }

    public static enum HUERANGES {
        ALL,
        RED,
        YELLOW,
        GREEN,
        CYAN,
        BLUE,
        MAGENTA;

    }
}

