/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.ColorChannel;

public class Invert
extends ColorOperatorImpl {
    private static final int BRIGHTNESS_MODE = 0;
    private static final int CHANNEL_MODE = 1;
    private final int mode;
    private ColorChannel channel;

    public Invert(String invert) {
        if (invert.equalsIgnoreCase("brightness")) {
            this.mode = 0;
            this.channel = null;
        } else {
            this.mode = 1;
            try {
                this.channel = ColorChannel.valueOf(invert.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.channel = ColorChannel.ALL;
            }
        }
    }

    public Invert(ColorChannel channel) {
        this.mode = 1;
        this.channel = channel;
    }

    @Override
    public int transform(int argb, int pos) {
        if (this.mode == 0) {
            return Invert.invertBrightness(argb);
        }
        return this.invertChannel(argb);
    }

    private int invertChannel(int argb) {
        int a = this.channel == ColorChannel.ALPHA ? 255 - (argb >>> 24 & 0xFF) : argb >>> 24 & 0xFF;
        int r = this.channel == ColorChannel.ALL || this.channel == ColorChannel.RED ? 255 - (argb >> 16 & 0xFF) : argb >> 16 & 0xFF;
        int g = this.channel == ColorChannel.ALL || this.channel == ColorChannel.GREEN ? 255 - (argb >> 8 & 0xFF) : argb >> 8 & 0xFF;
        int b = this.channel == ColorChannel.ALL || this.channel == ColorChannel.BLUE ? 255 - (argb & 0xFF) : argb & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int invertBrightness(int argb) {
        int min;
        int value;
        int alpha = argb >>> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        if (r > g) {
            value = Math.max(r, b);
            min = Math.min(g, b);
        } else {
            value = Math.max(g, b);
            min = Math.min(r, b);
        }
        int delta = value - min;
        if (value == 0 || delta == 0) {
            r = 255 - value;
            g = 255 - value;
            b = 255 - value;
        } else {
            int value2 = value / 2;
            if (r == value) {
                r = 255 - r;
                b = (r * b + value2) / value;
                g = (r * g + value2) / value;
            } else if (g == value) {
                g = 255 - g;
                r = (g * r + value2) / value;
                b = (g * b + value2) / value;
            } else {
                b = 255 - b;
                g = (b * g + value2) / value;
                r = (b * r + value2) / value;
            }
        }
        return alpha << 24 | r << 16 | g << 8 | b;
    }
}

