/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class MatteTransparent
extends ColorOperatorImpl {
    private final int matte;
    private final boolean transparencyCut;
    private final int mr;
    private final int mg;
    private final int mb;

    public MatteTransparent(int matte, boolean transparencyCut) throws ImageManipulatorException {
        this.mr = matte >> 16 & 0xFF;
        this.mg = matte >> 8 & 0xFF;
        this.mb = matte & 0xFF;
        this.matte = 0xFF000000 | matte;
        this.transparencyCut = transparencyCut;
    }

    @Override
    public final int transform(int argb, int pos) {
        int ai = argb >>> 24 & 0xFF;
        if (ai == 0 && !this.transparencyCut) {
            return this.matte;
        }
        if (ai == 0 && this.transparencyCut) {
            return 0;
        }
        if (ai == 255) {
            return 0xFF000000 | argb;
        }
        float af = 1.0f - (float)ai / 255.0f;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        r = BaseImageUtils.clampFT255((float)r - (float)(r - this.mr) * af);
        g = BaseImageUtils.clampFT255((float)g - (float)(g - this.mg) * af);
        b = BaseImageUtils.clampFT255((float)b - (float)(b - this.mb) * af);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

