/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import java.util.Random;

public final class Noise
extends ColorOperatorImpl {
    private final Random rand = new Random(812371223L);
    private final float amount;
    private final boolean monochrome;
    private final float noise;
    private final float noise2;

    public Noise(int amount, int strength, boolean monochrome) {
        if (amount < 0) {
            amount = 0;
        } else if (amount > 100) {
            amount = 100;
        }
        if (strength < 0) {
            strength = 0;
        } else if (strength > 100) {
            strength = 100;
        }
        this.amount = (float)amount / 100.0f;
        this.monochrome = monochrome;
        this.noise = 256.0f * ((float)strength / 100.0f);
        this.noise2 = this.noise / 2.0f;
    }

    @Override
    public final int transform(int argb, int pos) {
        float randval = this.rand.nextFloat();
        if (randval < this.amount) {
            int b;
            int g;
            int r;
            int alpha = argb >>> 24 & 0xFF;
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb & 0xFF;
            if (this.monochrome) {
                int pixelNoise = (int)(-this.noise2 + randval * this.noise);
                r = BaseImageUtils.clampFT255(red + pixelNoise);
                g = BaseImageUtils.clampFT255(green + pixelNoise);
                b = BaseImageUtils.clampFT255(blue + pixelNoise);
            } else {
                r = BaseImageUtils.clampFT255((float)red - this.noise2 + this.rand.nextFloat() * this.noise);
                g = BaseImageUtils.clampFT255((float)green - this.noise2 + this.rand.nextFloat() * this.noise);
                b = BaseImageUtils.clampFT255((float)blue - this.noise2 + this.rand.nextFloat() * this.noise);
            }
            return alpha << 24 | r << 16 | g << 8 | b;
        }
        return argb;
    }
}

