/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.EffectThreadAbstract;
import com.neptunelabs.imagemanipulator.utils.EffectUtils;
import com.neptunelabs.imagereader.image.FSIImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ParallelColorOperation
extends EffectUtils {
    public ParallelColorOperation(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger, executorPool, priority);
    }

    public FSIImage transform(FSIImage input, ColorOperatorImpl operator, boolean keepInput) throws ProcessingException {
        ColorOperatorImpl[] operators = new ColorOperatorImpl[]{operator};
        return this.transform(input, operators, keepInput);
    }

    public FSIImage transform(FSIImage input, List<ColorOperatorImpl> operatorsList, boolean keepInput) throws ProcessingException {
        ColorOperatorImpl[] operators = new ColorOperatorImpl[operatorsList.size()];
        for (int c = 0; c < operatorsList.size(); ++c) {
            operators[c] = operatorsList.get(c);
        }
        return this.transform(input, operators, keepInput);
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public FSIImage transform(FSIImage input, ColorOperatorImpl[] operators, boolean keepInput) throws ProcessingException {
        FSIImage result = input.createCompatibleImage();
        int threads = this.calcThreads(input);
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU), threads);
        ArrayList futures = new ArrayList(threads);
        boolean success = true;
        int[][] yRanges = ParallelColorOperation.calcThreadImageRanges(input.getHeight(), threads);
        for (int t = 0; t < threads; ++t) {
            int[] yRange = yRanges[t];
            ColorOperationThread filterThread = new ColorOperationThread(this.priority, yRange[0], yRange[1]);
            filterThread.setOptions(operators);
            filterThread.setAlphaSelection(this.alphaSelection);
            filterThread.setImages(input, result);
            futures.add(completionService.submit(filterThread));
        }
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (InterruptedException c) {
            for (Future f : futures) {
                f.cancel(true);
            }
            if (!success) {
                ParallelColorOperation.disposeImages(result);
            }
        }
        catch (ExecutionException e) {
            throw new ProcessingException(e);
            {
                catch (Throwable throwable) {
                    for (Future f : futures) {
                        f.cancel(true);
                    }
                    if (!success) {
                        ParallelColorOperation.disposeImages(result);
                    }
                    throw throwable;
                }
            }
        }
        for (Future f : futures) {
            f.cancel(true);
        }
        if (!success) {
            ParallelColorOperation.disposeImages(result);
        }
        if (!keepInput) {
            input.dispose();
        }
        return result;
    }

    private final class ColorOperationThread
    extends EffectThreadAbstract {
        private ColorOperatorImpl[] operators;

        public ColorOperationThread(int priority, int fromY, int toY) {
            super(priority, fromY, toY);
        }

        public void setOptions(ColorOperatorImpl[] operators) {
            this.operators = operators;
        }

        @Override
        public void run() {
            int p;
            int[] pixels = new int[this.baseWidth];
            int asPos = p = this.fromY * this.baseWidth;
            this.baseImage.setPosition(p);
            for (int y = this.fromY; y <= this.toY; ++y) {
                p = y * this.baseWidth;
                this.baseImage.getSamples(pixels, 0, pixels.length);
                int x = 0;
                while (x < this.baseWidth) {
                    int sel;
                    int n = sel = ParallelColorOperation.this.alphaSelection == null ? 255 : ParallelColorOperation.this.alphaSelection[asPos] & 0xFF;
                    if (sel > 0) {
                        int baseARGB;
                        int argb = baseARGB = pixels[x];
                        for (ColorOperatorImpl co : this.operators) {
                            argb = co.transform(argb, 0);
                        }
                        if (sel < 255) {
                            argb = ColorOperationThread.blend(baseARGB, argb, sel);
                        }
                        pixels[x] = argb;
                    }
                    ++x;
                    ++asPos;
                }
                this.newImage.setSamples((long)p, pixels);
            }
        }
    }
}

