/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class Posterize
extends ColorOperatorImpl {
    private final int[] lut = new int[256];

    public Posterize(int level) throws ImageManipulatorException {
        if (level < 0) {
            level = 0;
        } else if (level > 255) {
            level = 255;
        }
        level = (level < 2 ? 2 : level) - 1;
        float interval = 255.0f / (float)level;
        float half_interval = interval / 2.0f;
        for (int i = 0; i < 256; ++i) {
            this.lut[i] = (int)((float)((int)(((float)i + half_interval) / interval)) * interval);
        }
    }

    @Override
    public final int transform(int argb, int pos) {
        int alpha = argb >>> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return alpha << 24 | this.lut[r] << 16 | this.lut[g] << 8 | this.lut[b];
    }
}

