/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public final class RGBMatrix
extends ColorOperatorImpl {
    private final float r1;
    private final float g1;
    private final float b1;
    private final float r2;
    private final float g2;
    private final float b2;
    private final float r3;
    private final float g3;
    private final float b3;

    public RGBMatrix(float[] matrix) throws ImageManipulatorException {
        if (matrix.length != 9) {
            throw new ImageManipulatorException("Invalid matrix length");
        }
        this.r1 = matrix[0];
        this.g1 = matrix[1];
        this.b1 = matrix[2];
        this.r2 = matrix[3];
        this.g2 = matrix[4];
        this.b2 = matrix[5];
        this.r3 = matrix[6];
        this.g3 = matrix[7];
        this.b3 = matrix[8];
    }

    @Override
    public final int transform(int argb, int pos) {
        int alpha = argb >>> 24 & 0xFF;
        int ro = argb >> 16 & 0xFF;
        int go = argb >> 8 & 0xFF;
        int bo = argb & 0xFF;
        int r = BaseImageUtils.clampFT255((float)ro * this.r1 + (float)go * this.g1 + (float)bo * this.b1);
        int g = BaseImageUtils.clampFT255((float)ro * this.r2 + (float)go * this.g2 + (float)bo * this.b2);
        int b = BaseImageUtils.clampFT255((float)ro * this.r3 + (float)go * this.g3 + (float)bo * this.b3);
        return alpha << 24 | r << 16 | g << 8 | b;
    }
}

