/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;

public class Saturation
extends ColorOperatorImpl {
    private Mode mode;
    private float strength;

    public Saturation(String parameters) {
        String[] parts = parameters.split(",");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid parameter count for saturation effect.");
        }
        String modeStr = parts[0];
        int strengthInt = 0;
        try {
            strengthInt = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid parameter value strength for saturation effect.");
        }
        this.strength = (float)(strengthInt += 100) / 100.0f;
        try {
            this.mode = Mode.valueOf(modeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ImageManipulatorException("Invalid Saturate mode " + modeStr);
        }
        if (strengthInt < 0) {
            this.strength = 0.0f;
        } else if (strengthInt > 200) {
            this.strength = 2.0f;
        }
    }

    @Override
    public int transform(int argb, int pos) {
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        int rgb = 0;
        if (this.mode == Mode.HSL) {
            float[] hsl0 = BaseImageUtils.rgbToHsl((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
            float[] frgb = BaseImageUtils.hslToRgb(hsl0[0], hsl0[1] * this.strength, hsl0[2]);
            rgb = BaseImageUtils.floatRgbToIntRgb(frgb);
        } else if (this.mode == Mode.YIQ) {
            float[] yiq = BaseImageUtils.rgbToYiq((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
            float[] frgb = BaseImageUtils.yiqToRgb(yiq[0], yiq[1] * this.strength, yiq[2] * this.strength);
            rgb = BaseImageUtils.floatRgbToIntRgb(frgb);
        }
        return alpha << 24 | rgb;
    }

    public static enum Mode {
        HSL,
        YIQ;

    }
}

