/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;

public class Temperature
extends ColorOperatorImpl {
    private float temperature;

    public Temperature(int temperatureInt) {
        if (temperatureInt < -100) {
            this.temperature = -100.0f;
        } else if (temperatureInt > 100) {
            this.temperature = 100.0f;
        }
        this.temperature = (float)temperatureInt / 1000.0f;
    }

    @Override
    public int transform(int argb, int pos) {
        int alpha = argb >>> 24 & 0xFF;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        float[] yiq = BaseImageUtils.rgbToYiq((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
        float[] frgb = BaseImageUtils.yiqToRgb(yiq[0], yiq[1] + this.temperature, yiq[2] - this.temperature);
        int rgb = BaseImageUtils.floatRgbToIntRgb(frgb);
        return alpha << 24 | rgb;
    }
}

