/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;

public final class Threshold
extends ColorOperatorImpl {
    private final int levelLow;
    private final int levelHigh;
    private final int color1;
    private final int color2;

    public Threshold(int levelLow, int levelHigh, int color1, int color2) {
        this.levelLow = levelLow;
        this.levelHigh = levelHigh;
        this.color1 = color1;
        this.color2 = color2;
    }

    @Override
    public final int transform(int argb, int pos) {
        int alpha = argb >>> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        int value = Math.max(r, g);
        value = (value = Math.max(value, b)) >= this.levelLow && value <= this.levelHigh ? this.color1 : this.color2;
        return alpha << 24 | value;
    }
}

