/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;

public final class Transparency
extends ColorOperatorImpl {
    private final float transparency;

    public Transparency(int transparency) {
        if (transparency < 0) {
            transparency = 0;
        } else if (transparency > 100) {
            transparency = 100;
        }
        this.transparency = (float)transparency / 100.0f;
    }

    @Override
    public final int transform(int argb, int pos) {
        int currentalpha = argb >>> 24 & 0xFF;
        int alpha = (int)((float)currentalpha - (float)currentalpha * this.transparency);
        alpha = alpha >= 0 ? (alpha <= 255 ? alpha : 255) : 0;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return alpha << 24 | r << 16 | g << 8 | b;
    }
}

