/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.color;

import com.neptunelabs.imagemanipulator.color.ColorOperatorImpl;
import com.neptunelabs.imagemanipulator.color.RGBLumSafeMatrix;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;

public class WhiteBalance
extends ColorOperatorImpl {
    private final RGBLumSafeMatrix rgbMatrixOp;
    private static double[][] XYZ_to_RGB = new double[][]{{3.24071, -0.969258, 0.0556352}, {-1.53726, 1.87599, -0.203996}, {-0.498571, 0.0415557, 1.05707}};

    public WhiteBalance(int rgbTemperature) {
        float[] rgbTemperatureFloat = BaseImageUtils.rgbToFloat1(rgbTemperature);
        double temperature = WhiteBalance.rgb2Temperature(rgbTemperatureFloat);
        float[] mRGB = WhiteBalance.temperature2RGB(temperature);
        float[] matrix = new float[9];
        matrix[0] = mRGB[2];
        matrix[4] = mRGB[1];
        matrix[8] = mRGB[0];
        this.rgbMatrixOp = new RGBLumSafeMatrix(matrix);
    }

    @Override
    public int transform(int argb, int pos) {
        return this.rgbMatrixOp.transform(argb, pos);
    }

    public static double rgb2Temperature(float[] rgb) {
        double tMin = 2000.0;
        double tMax = 23000.0;
        double temp = (tMax + tMin) / 2.0;
        while (tMax - tMin > 0.1) {
            float[] testRGB = WhiteBalance.temperature2RGB(temp);
            if (testRGB[2] / testRGB[0] > rgb[2] / rgb[0]) {
                tMax = temp;
            } else {
                tMin = temp;
            }
            temp = (tMax + tMin) / 2.0;
        }
        return temp;
    }

    public static float[] temperature2RGB(double temperature) {
        int c;
        float[] rgb = new float[3];
        double xD = temperature <= 4000.0 ? 2.7475E8 / (temperature * temperature * temperature) - 985980.0 / (temperature * temperature) + 1174.44 / temperature + 0.145986 : (temperature <= 7000.0 ? -4.607E9 / (temperature * temperature * temperature) + 2967800.0 / (temperature * temperature) + 99.11 / temperature + 0.244063 : -2.0064E9 / (temperature * temperature * temperature) + 1901800.0 / (temperature * temperature) + 247.48 / temperature + 0.23704);
        double yD = -3.0 * xD * xD + 2.87 * xD - 0.275;
        xD = -1.8596E9 / (temperature * temperature * temperature) + 1376860.0 / (temperature * temperature) + 360.496 / temperature + 0.232632;
        yD = -2.6046 * xD * xD + 2.6106 * xD - 0.239156;
        double X = xD / yD;
        double Y = 1.0;
        double Z = (1.0 - xD - yD) / yD;
        double max = 0.0;
        for (c = 0; c < 3; ++c) {
            rgb[c] = (float)(X * XYZ_to_RGB[0][c] + Y * XYZ_to_RGB[1][c] + Z * XYZ_to_RGB[2][c]);
            if (!((double)rgb[c] > max)) continue;
            max = rgb[c];
        }
        for (c = 0; c < 3; ++c) {
            rgb[c] = (float)((double)rgb[c] / max);
        }
        return rgb;
    }
}

