/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.combine;

import com.neptunelabs.imagemanipulator.utils.ImageManipulatorException;
import com.neptunelabs.imagereader.image.FSIImage;
import java.nio.BufferUnderflowException;

public final class Join {
    private Join() {
    }

    public static FSIImage transform(FSIImage image1, FSIImage image2, JoinPosition joinPosition) throws ImageManipulatorException {
        return Join.transform(image1, image2, joinPosition, false);
    }

    public static FSIImage transform(FSIImage image1, FSIImage image2, JoinPosition joinPosition, boolean keepInput) throws ImageManipulatorException {
        int newWidth;
        int newHeight;
        if (image1 == null || image2 == null) {
            throw new ImageManipulatorException("Join Image parameter is null");
        }
        if (!image1.isImageCompatible(image2)) {
            throw new ImageManipulatorException("Cannot Join incompatible images.");
        }
        if (joinPosition == JoinPosition.RIGHT && image1.getHeight() != image2.getHeight()) {
            throw new ImageManipulatorException("Cannot Right Join images with different height.");
        }
        if (joinPosition == JoinPosition.BOTTOM && image1.getWidth() != image2.getWidth()) {
            throw new ImageManipulatorException("Cannot Bottom Join images with different width.");
        }
        if (joinPosition == JoinPosition.RIGHT) {
            newHeight = image1.getHeight();
            newWidth = image1.getWidth() + image2.getWidth();
        } else {
            newHeight = image1.getHeight() + image2.getHeight();
            newWidth = image1.getWidth();
        }
        FSIImage result = image1.createCompatibleImage(newWidth, newHeight);
        if (joinPosition == JoinPosition.RIGHT) {
            image1.setPosition(0L);
            image2.setPosition(0L);
            result.setPosition(0L);
            int image1index = 0;
            try {
                for (int i = 0; i < image1.getHeight(); ++i) {
                    int j;
                    for (j = 0; j < image1.getWidth(); ++j) {
                        image1index = (int)image1.getPosition();
                        result.setSample(image1.getSample());
                    }
                    for (j = 0; j < image2.getWidth(); ++j) {
                        result.setSample(image2.getSample());
                    }
                }
            }
            catch (BufferUnderflowException e) {
                ImageManipulatorException ne = new ImageManipulatorException("BufferUnderflow at " + image1index);
                ne.initCause(e);
                throw ne;
            }
        } else {
            int i;
            image1.setPosition(0L);
            image2.setPosition(0L);
            result.setPosition(0L);
            for (i = 0; i < image1.getWidth() * image1.getHeight(); ++i) {
                result.setSample(image1.getSample());
            }
            for (i = 0; i < image2.getWidth() * image2.getHeight(); ++i) {
                result.setSample(image2.getSample());
            }
        }
        if (!keepInput) {
            image1.dispose();
            image2.dispose();
        }
        return result;
    }

    public static enum JoinPosition {
        RIGHT,
        BOTTOM;

    }
}

