/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.combine;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class Mandelbrot {
    private final FSILogger logger;
    private final ExecutorPool executorPool;
    private final SwapPool swapPool;
    private final ByteOrder byteOrder;
    private static final double pminRef = -2.25;
    private static final double pmaxRef = 0.75;
    private static final double qminRef = 1.5;
    private static final double qmaxRef = -1.5;
    private final int iterLimit = 100;
    double pmin;
    double pmax;
    double qmin;
    double qmax;
    private static final int MAX_CONTROL_COLORS = 5;
    private static final int MAX_COLORS = 512;
    final int[][] colors = new int[512][];

    public Mandelbrot(FSILogger logger, ExecutorPool executorPool, SwapPool swapPool, ByteOrder byteOrder) {
        this.logger = logger;
        this.executorPool = executorPool;
        this.swapPool = swapPool;
        this.byteOrder = byteOrder;
        int[][] controlColors = new int[][]{{238, 112, 74}, {255, 255, 255}, {88, 168, 255}, {73, 73, 73}, {24, 104, 189}};
        this.computeColors(controlColors);
    }

    public void setColors(int c1, int c2, int c3, int c4, int c5) {
        int[][] controlColors = new int[][]{{c1 >> 16 & 0xFF, c1 >> 8 & 0xFF, c1 & 0xFF}, {c2 >> 16 & 0xFF, c2 >> 8 & 0xFF, c2 & 0xFF}, {c3 >> 16 & 0xFF, c3 >> 8 & 0xFF, c3 & 0xFF}, {c4 >> 16 & 0xFF, c4 >> 8 & 0xFF, c4 & 0xFF}, {c5 >> 16 & 0xFF, c5 >> 8 & 0xFF, c5 & 0xFF}};
        this.computeColors(controlColors);
    }

    public void setRange(double left, double top, double width, double height) {
        this.pmin = 3.0 * left + -2.25;
        this.pmax = 3.0 * (left + width) + -2.25;
        this.qmax = 3.0 * (1.0 - top) - 1.5;
        this.qmin = 3.0 * (1.0 - (top + height)) - 1.5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSIImage render(int priority, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair) throws ProcessingException {
        FSIImageLimited image = new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, (int)widthPair.getItem1(), heightPair.getItem1(), null, FSIImageMode.ARGB);
        int threads = this.executorPool.getAvailableThreads(ExecutorPool.Type.RENDERER_CPU);
        PriorityExecutorCompletionService completionService = new PriorityExecutorCompletionService(this.executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU));
        ArrayList futures = new ArrayList();
        int th = image.getHeight() < threads ? image.getHeight() : threads;
        int yRange = (int)Math.floor(image.getHeight() / th);
        int yStart = 0;
        int yStop = 0;
        for (int t = 0; t < th; ++t) {
            yStop = t + 1 < th ? (yStop += yRange) : image.getHeight();
            MandelbrotThread mandelbrotThread = new MandelbrotThread(priority, yStart, yStop);
            mandelbrotThread.setImage(image);
            if (this.executorPool.isShutdown()) break;
            futures.add(completionService.submit(mandelbrotThread));
            yStart += yRange;
        }
        try {
            for (int c = 0; c < completionService.count(); ++c) {
                completionService.take().get();
            }
        }
        catch (ExecutionException e) {
            ((FSIImage)image).dispose();
            throw new ProcessingException(e);
        }
        catch (InterruptedException interruptedException) {}
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        return image;
    }

    private void computeColors(int[][] controlColors) {
        int i;
        this.colors[0] = new int[]{0, 0, 0};
        for (i = 0; i < 4; ++i) {
            int rstep = (controlColors[i + 1][0] - controlColors[i][0]) / 63;
            int bstep = (controlColors[i + 1][1] - controlColors[i][1]) / 63;
            int gstep = (controlColors[i + 1][2] - controlColors[i][2]) / 63;
            for (int k = 0; k < 64; ++k) {
                int r = controlColors[i][0] + rstep * k;
                int g = controlColors[i][1] + bstep * k;
                int b = controlColors[i][2] + gstep * k;
                this.colors[k + i * 64 + 1] = new int[]{r, g, b};
            }
        }
        for (i = 257; i < 512; ++i) {
            this.colors[i] = this.colors[i - 256];
        }
    }

    final class MandelbrotThread
    implements Runnable,
    PriorityExecutor.Important {
        private final int priority;
        private final int yStart;
        private final int yStop;
        private FSIImage image;
        private int width;

        public MandelbrotThread(int priority, int yStart, int yStop) {
            this.priority = priority;
            this.yStart = yStart;
            this.yStop = yStop;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        public void setImage(FSIImage image) {
            this.image = image;
            this.width = image.getWidth();
        }

        @Override
        public void run() {
            int kmax = 256;
            double xstep = (Mandelbrot.this.pmax - Mandelbrot.this.pmin) / (double)this.image.getWidth();
            double ystep = (Mandelbrot.this.qmax - Mandelbrot.this.qmin) / (double)this.image.getHeight();
            double x = 0.0;
            double y = 0.0;
            double r = 1.0;
            for (int sy = this.yStart; sy < this.yStop; ++sy) {
                double q = Mandelbrot.this.qmax - ystep * (double)sy;
                for (int sx = 0; sx < this.width; ++sx) {
                    double p = Mandelbrot.this.pmin + xstep * (double)sx;
                    int k = 0;
                    double y0 = 0.0;
                    double x0 = 0.0;
                    do {
                        x = x0 * x0 - y0 * y0 + p;
                        y = 2.0 * x0 * y0 + q;
                        x0 = x;
                        y0 = y;
                    } while ((r = x * x + y * y) <= 100.0 && ++k < 256);
                    if (k >= 256) {
                        k = 0;
                    }
                    int rgb = 0xFF000000 | Mandelbrot.this.colors[k][0] << 16 | Mandelbrot.this.colors[k][1] << 8 | Mandelbrot.this.colors[k][2];
                    this.image.setSample(sx, sy, rgb);
                }
            }
        }
    }
}

