/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.combine;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.nio.ByteOrder;
import java.util.Random;

public class TestPattern {
    private final FSILogger logger;
    private final ExecutorPool executorPool;
    private final SwapPool swapPool;
    private final ByteOrder byteOrder;
    private Modes mode = Modes.CIRCLES;
    private int distance = 2;
    private double left = 0.0;
    private double top = 0.0;
    private double width = 1.0;
    private double height = 1.0;
    private int color = this.getColor(255, 255, 255);
    private int backgroundColor = this.getColor(64, 64, 64);
    private int multiColor1 = this.getColor(0, 0, 0);
    private int multiColor2 = this.getColor(255, 255, 255);
    private boolean isSetMultiColor = false;

    public TestPattern(FSILogger logger, ExecutorPool executorPool, SwapPool swapPool, ByteOrder byteOrder) {
        this.logger = logger;
        this.executorPool = executorPool;
        this.swapPool = swapPool;
        this.byteOrder = byteOrder;
    }

    public void setMode(Modes smode) {
        this.mode = smode;
    }

    public void setDistance(int d) {
        if (d > 0) {
            this.distance = d;
        }
    }

    public void setRange(double left, double top, double width, double height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public void setColor(int c) {
        this.color = 0xFF000000 | c;
        this.multiColor1 = 0xFF000000 | c;
    }

    public void setBackgroundColor(int c) {
        this.backgroundColor = 0xFF000000 | c;
        this.multiColor2 = 0xFF000000 | c;
    }

    public void setMultiColor(int c1, int c2) {
        this.multiColor1 = 0xFF000000 | c1;
        this.multiColor2 = 0xFF000000 | c2;
        this.isSetMultiColor = true;
    }

    public FSIImage render(int priority, Pair<Integer, Boolean> widthPair, Pair<Integer, Boolean> heightPair) {
        int imageWidth = widthPair.getItem1();
        int imageHeight = heightPair.getItem1();
        FSIImageLimited image = new FSIImageLimited(this.logger, this.swapPool, this.byteOrder, imageWidth, imageHeight, null, FSIImageMode.ARGB);
        int pix = image.getHeight() * image.getWidth();
        for (int i = 0; i < pix; ++i) {
            ((FSIImage)image).setSample(this.backgroundColor);
        }
        int originalWidth = (int)Math.round((double)imageWidth / this.width);
        int originalHeight = (int)Math.round((double)imageHeight / this.height);
        int startX = (int)Math.round((double)originalWidth * this.left);
        int startY = (int)Math.round((double)originalHeight * this.top);
        int stopX = startX + (int)Math.round((double)originalWidth * this.width) - 1;
        int stopY = startY + (int)Math.round((double)originalHeight * this.height) - 1;
        if (this.mode == Modes.CIRCLES) {
            this.drawCircles(image, startX, startY, stopX, stopY, originalWidth, originalHeight, this.color);
        } else if (this.mode == Modes.DOTS) {
            this.drawDots(image, startX, startY, stopX, stopY, originalWidth, originalHeight);
        } else if (this.mode == Modes.GRID) {
            this.drawGrid(image, startX, startY, stopX, stopY, originalWidth, originalHeight, true, true);
        } else if (this.mode == Modes.HLINES) {
            this.drawGrid(image, startX, startY, stopX, stopY, originalWidth, originalHeight, true, false);
        } else if (this.mode == Modes.VLINES) {
            this.drawGrid(image, startX, startY, stopX, stopY, originalWidth, originalHeight, false, true);
        } else if (this.mode == Modes.FUBK) {
            this.drawFuBK(image, startX, startY, stopX, stopY, originalWidth, originalHeight);
        } else if (this.mode == Modes.COLORS) {
            this.drawColors(image, startX, startY, stopX, stopY, originalWidth, originalHeight);
        } else if (this.mode == Modes.GAUSS) {
            this.drawGauss(image);
        } else if (this.mode == Modes.FSI) {
            this.drawFSI(image, startX, startY, stopX, stopY, originalWidth, originalHeight);
        }
        return image;
    }

    private void drawCircles(FSIImage image, int startX, int startY, int stopX, int stopY, int oWidth, int oHeight, int dColor) {
        int midX = oWidth / 2 - startX;
        int midY = oHeight / 2 - startY;
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int maxRadius = (int)Math.floor(Math.sqrt(Math.pow(midX, 2.0) + Math.pow(midY, 2.0))) + 2;
        if (midX >= 0 && midX < imageWidth && midY >= 0 && midY < imageHeight) {
            image.setSample(midX, midY, this.color);
        }
        for (int radius = this.distance; radius < maxRadius; radius += this.distance) {
            this.drawCircle(image, radius, midX, midY, dColor);
        }
    }

    private void drawCircle(FSIImage image, double radius, int midX, int midY, int dColor) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        for (double x = -radius; x <= radius; x += 1.0) {
            double y = Math.sqrt(radius * radius - x * x);
            int px = (int)Math.round(x) + midX;
            if (px < 0 || px >= imageWidth) continue;
            int py = (int)Math.round(y) + midY;
            int pyn = (int)(-Math.round(y)) + midY;
            if (py >= 0 && py < imageHeight) {
                image.setSample(px, py, dColor);
            }
            if (pyn < 0 || pyn >= imageHeight) continue;
            image.setSample(px, pyn, dColor);
        }
        for (double y = -radius; y <= radius; y += 1.0) {
            double x = Math.sqrt(radius * radius - y * y);
            int py = (int)Math.round(y) + midY;
            if (py < 0 || py >= imageHeight) continue;
            int px = (int)Math.round(x) + midX;
            int pxn = (int)(-Math.round(x)) + midX;
            if (px >= 0 && px < imageWidth) {
                image.setSample(px, py, dColor);
            }
            if (pxn < 0 || pxn >= imageWidth) continue;
            image.setSample(pxn, py, dColor);
        }
    }

    private void drawDots(FSIImage image, int startX, int startY, int stopX, int stopY, int oWidth, int oHeight) {
        int sy;
        int iWidth = image.getWidth();
        int iHeight = image.getHeight();
        int sx = startX % this.distance;
        for (int y = sy = startY % this.distance; y < iHeight; y += this.distance) {
            for (int x = sx; x < iWidth; x += this.distance) {
                image.setSample(x, y, this.color);
            }
        }
    }

    private void drawGrid(FSIImage image, int startX, int startY, int stopX, int stopY, int oWidth, int oHeight, boolean hLines, boolean vLines) {
        int iWidth = image.getWidth();
        int iHeight = image.getHeight();
        int sx = startX % this.distance;
        int sy = startY % this.distance;
        if (hLines) {
            for (int y = sy; y < iHeight; y += this.distance) {
                for (int x = 0; x < iWidth; ++x) {
                    image.setSample(x, y, this.color);
                }
            }
        }
        if (vLines) {
            for (int x = sx; x < iWidth; x += this.distance) {
                for (int y = 0; y < iHeight; ++y) {
                    image.setSample(x, y, this.color);
                }
            }
        }
    }

    private void drawGauss(FSIImage image) {
        Random rand = new Random(80085L);
        int iWidth = image.getWidth();
        int iHeight = image.getHeight();
        for (int y = 0; y < iHeight; y += this.distance) {
            for (int x = 0; x < iWidth; x += this.distance) {
                boolean draw = rand.nextBoolean();
                if (!draw) continue;
                if (this.distance == 1) {
                    image.setSampleSafe(x, y, this.color);
                    continue;
                }
                for (int y2 = 0; y2 < this.distance; ++y2) {
                    for (int x2 = 0; x2 < this.distance; ++x2) {
                        image.setSampleSafe(x + x2, y + y2, this.color);
                    }
                }
            }
        }
    }

    private void drawColors(FSIImage image, int startX, int startY, int stopX, int stopY, int oWidth, int oHeight) {
        int iWidth = image.getWidth();
        int iHeight = image.getHeight();
        int sx = startX % this.distance;
        int sy = startY % this.distance;
        float numXRects = (float)oWidth / (float)this.distance;
        float numYRects = (float)oHeight / (float)this.distance;
        float steps = numXRects * numYRects;
        int r1 = this.multiColor1 >> 16 & 0xFF;
        int r2 = this.multiColor2 >> 16 & 0xFF;
        int g1 = this.multiColor1 >> 8 & 0xFF;
        int g2 = this.multiColor2 >> 8 & 0xFF;
        int b1 = this.multiColor1 & 0xFF;
        int b2 = this.multiColor2 & 0xFF;
        float rs = (float)(r1 - r2) / steps;
        float gs = (float)(g1 - g2) / steps;
        float bs = (float)(b1 - b2) / steps;
        int step = 0;
        for (float fy = 0.0f; fy < numYRects; fy += 1.0f) {
            for (float fx = 0.0f; fx < numXRects; fx += 1.0f) {
                int b;
                int g;
                int x1 = (int)Math.floor(fx * (float)this.distance);
                int x2 = (int)Math.floor(fx * (float)this.distance + (float)this.distance);
                int y1 = (int)Math.floor(fy * (float)this.distance);
                int y2 = (int)Math.floor(fy * (float)this.distance + (float)this.distance);
                int r = Math.round((float)r2 + rs * (float)step);
                if (r < 0) {
                    r = 0;
                }
                if (r > 255) {
                    r = 255;
                }
                if ((g = Math.round((float)g2 + gs * (float)step)) < 0) {
                    g = 0;
                }
                if (g > 255) {
                    g = 255;
                }
                if ((b = Math.round((float)b2 + bs * (float)step)) < 0) {
                    b = 0;
                }
                if (b > 255) {
                    b = 255;
                }
                int c = this.getColor(r, g, b);
                this.fillArea(image, x1, y1, x2, y2, c);
                ++step;
            }
        }
    }

    private void drawFSI(FSIImage image, int startX, int startY, int stopX, int stopY, int oWidth, int oHeight) {
        int[][] fsi = new int[][]{{1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0}, {1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0}, {1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        int iWidth = image.getWidth();
        int iHeight = image.getHeight();
        for (int y = 0; y < iHeight; ++y) {
            int r = (y + startY) % 6;
            for (int x = 0; x < iWidth; x += 13) {
                for (int f = 0; f < 13; ++f) {
                    int c = (startX + f) % 13;
                    int s = fsi[r][c];
                    if (s != 1) continue;
                    image.setSampleSafe(x + f, y, this.color);
                }
            }
        }
    }

    private void drawFuBK(FSIImage image, int startX, int startY, int stopX, int stopY, int oWidth, int oHeight) {
        int y;
        int y2;
        int x;
        float fx;
        int x2;
        int y3;
        float fy;
        int iWidth = image.getWidth();
        int iHeight = image.getHeight();
        int midX = iWidth / 2;
        int midY = iHeight / 2;
        float grid = (float)iHeight / 15.0f;
        float grid2 = grid / 2.0f;
        int colorWhite = this.getColor(255, 255, 255);
        int colorBlack = this.getColor(0, 0, 0);
        for (fy = (float)midY; fy >= 0.0f; fy -= grid) {
            y3 = Math.round(fy);
            for (x2 = 0; x2 < iWidth; ++x2) {
                image.setSample(x2, y3, colorWhite);
            }
        }
        for (fy = (float)midY; fy < (float)iHeight; fy += grid) {
            y3 = Math.round(fy);
            for (x2 = 0; x2 < iWidth; ++x2) {
                image.setSample(x2, y3, colorWhite);
            }
        }
        for (fx = (float)midX; fx >= 0.0f; fx -= grid) {
            x = Math.round(fx);
            for (y2 = 0; y2 < iHeight; ++y2) {
                image.setSample(x, y2, colorWhite);
            }
        }
        for (fx = (float)midX; fx < (float)iWidth; fx += grid) {
            x = Math.round(fx);
            for (y2 = 0; y2 < iHeight; ++y2) {
                image.setSample(x, y2, colorWhite);
            }
        }
        int[][] colors = new int[][]{new int[8], new int[8], new int[8]};
        colors[0][0] = this.getColor(255, 255, 255);
        colors[0][1] = this.getColor(255, 255, 0);
        colors[0][2] = this.getColor(0, 255, 255);
        colors[0][3] = this.getColor(0, 255, 0);
        colors[0][4] = this.getColor(255, 0, 255);
        colors[0][5] = this.getColor(255, 0, 0);
        colors[0][6] = this.getColor(0, 0, 255);
        colors[0][7] = this.getColor(0, 0, 0);
        colors[1][0] = this.getColor(191, 191, 191);
        colors[1][1] = this.getColor(191, 191, 0);
        colors[1][2] = this.getColor(0, 191, 191);
        colors[1][3] = this.getColor(0, 191, 0);
        colors[1][4] = this.getColor(191, 0, 191);
        colors[1][5] = this.getColor(191, 0, 0);
        colors[1][6] = this.getColor(0, 0, 191);
        colors[1][7] = this.getColor(64, 64, 64);
        colors[2][0] = this.getColor(128, 128, 128);
        colors[2][1] = this.getColor(128, 128, 0);
        colors[2][2] = this.getColor(0, 128, 128);
        colors[2][3] = this.getColor(0, 128, 0);
        colors[2][4] = this.getColor(128, 0, 128);
        colors[2][5] = this.getColor(128, 0, 0);
        colors[2][6] = this.getColor(0, 0, 128);
        colors[2][7] = this.getColor(128, 128, 128);
        int gY = -5;
        int c = 0;
        while (gY <= -3) {
            int cs = 0;
            int[] g1 = this.getGridPosition(-6.0f, gY, grid, midX, midY);
            int[] g2 = this.getGridPosition(-4.0f, gY, grid, midX, midY);
            int h1 = (int)Math.floor((float)g2[0] - grid2);
            int h2 = h1 + 1;
            this.fillArea(image, g1[0], g1[1], h1, g1[3] + 1, colors[c][cs++]);
            g1 = this.getGridPosition(-4.0f, gY, grid, midX, midY);
            this.fillArea(image, h2, g1[1], g1[2] + 1, g1[3] + 1, colors[c][cs++]);
            g1 = this.getGridPosition(-3.0f, gY, grid, midX, midY);
            g2 = this.getGridPosition(-1.0f, gY, grid, midX, midY);
            h1 = (int)Math.floor((float)g2[0] - grid2);
            h2 = h1 + 1;
            this.fillArea(image, g1[0], g1[1], h1, g1[3] + 1, colors[c][cs++]);
            g1 = this.getGridPosition(-1.0f, gY, grid, midX, midY);
            this.fillArea(image, h2, g1[1], g1[2] + 1, g1[3] + 1, colors[c][cs++]);
            g1 = this.getGridPosition(0.0f, gY, grid, midX, midY);
            g2 = this.getGridPosition(2.0f, gY, grid, midX, midY);
            h1 = (int)Math.floor((float)g2[0] - grid2);
            h2 = h1 + 1;
            this.fillArea(image, g1[0], g1[1], h1, g1[3] + 1, colors[c][cs++]);
            g1 = this.getGridPosition(2.0f, gY, grid, midX, midY);
            this.fillArea(image, h2, g1[1], g1[2] + 1, g1[3] + 1, colors[c][cs++]);
            g1 = this.getGridPosition(3.0f, gY, grid, midX, midY);
            g2 = this.getGridPosition(5.0f, gY, grid, midX, midY);
            h1 = (int)Math.floor((float)g2[0] - grid2);
            h2 = h1 + 1;
            this.fillArea(image, g1[0], g1[1], h1, g1[3] + 1, colors[c][cs++]);
            g1 = this.getGridPosition(5.0f, gY, grid, midX, midY);
            this.fillArea(image, h2, g1[1], g1[2], g1[3] + 1, colors[c][cs++]);
            ++gY;
            ++c;
        }
        int gX = -6;
        c = 0;
        while (gX < 6) {
            int[] g1 = this.getGridPosition(gX, -2.0f, grid, midX, midY);
            int[] g2 = this.getGridPosition(gX, -1.0f, grid, midX, midY);
            int c1 = Math.round((float)c * 21.25f);
            this.fillArea(image, g1[0], g1[1], g2[2] + 1, g2[3], this.getColor(c1, c1, c1));
            ++gX;
            ++c;
        }
        int[] g1 = this.getGridPosition(-6.0f, 0.0f, grid, midX, midY);
        int[] g2 = this.getGridPosition(-5.0f, 0.0f, grid, midX, midY);
        this.fillArea(image, g1[0], g1[1], g2[2] + 1, g2[3], this.getColor(255, 255, 255));
        g1 = this.getGridPosition(-4.0f, 0.0f, grid, midX, midY);
        g2 = this.getGridPosition(-1.0f, 0.0f, grid, midX, midY);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(0, 0, 0));
        g1 = this.getGridPosition(0.0f, 0.0f, grid, midX, midY);
        g2 = this.getGridPosition(3.0f, 0.0f, grid, midX, midY);
        this.fillArea(image, g1[0], g1[1], g2[2] + 1, g2[3], this.getColor(0, 0, 0));
        g1 = this.getGridPosition(4.0f, 0.0f, grid, midX, midY);
        g2 = this.getGridPosition(5.0f, 0.0f, grid, midX, midY);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(255, 255, 255));
        g1 = this.getGridPosition(-6.0f, 1.0f, grid, midX, midY);
        g2 = this.getGridPosition(-1.0f, 1.0f, grid, midX, midY);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(168, 168, 168));
        g1 = this.getGridPosition(0.0f, 1.0f, grid, midX, midY);
        g2 = this.getGridPosition(5.0f, 1.0f, grid, midX, midY);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(168, 168, 168));
        g1 = this.getGridPosition(2.0f, 1.0f, grid, midX, midY);
        g1[0] = (int)((double)g1[0] + (double)grid * 0.25);
        g2 = this.getGridPosition(5.0f, 1.0f, grid, midX, midY);
        g2[2] = (int)((double)g2[2] - (double)grid * 0.25);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(224, 152, 0));
        g1 = this.getGridPosition(-6.0f, 1.0f, grid, midX, midY);
        g2 = this.getGridPosition(-6.0f, 1.0f, grid, midX, midY);
        g2[2] = (int)((double)g2[2] + (double)grid * 0.25);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], colorWhite);
        g1 = this.getGridPosition(-4.0f, 1.0f, grid, midX, midY);
        g1[0] = (int)((double)g1[0] - (double)grid * 0.25);
        g2 = this.getGridPosition(-4.0f, 1.0f, grid, midX, midY);
        g2[2] = (int)((double)g2[2] + (double)grid * 0.25);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(0, 0, 0));
        this.vLines(image, g1[0], g1[1], g2[2], g2[3], 4, colorWhite);
        g1 = this.getGridPosition(-2.0f, 1.0f, grid, midX, midY);
        g2 = this.getGridPosition(-1.0f, 1.0f, grid, midX, midY);
        g2[2] = (int)((double)g2[2] - (double)grid * 0.25);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(0, 0, 0));
        this.vLines(image, g1[0], g1[1], g2[2], g2[3], 3, colorWhite);
        g1 = this.getGridPosition(0.0f, 1.0f, grid, midX, midY);
        g1[0] = (int)((double)g1[0] + (double)grid * 0.25);
        g2 = this.getGridPosition(1.0f, 1.0f, grid, midX, midY);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(0, 0, 0));
        this.vLines(image, g1[0], g1[1], g2[2], g2[3], 2, colorWhite);
        g1 = this.getGridPosition(-6.0f, 2.0f, grid, midX, midY);
        g2 = this.getGridPosition(5.0f, 2.0f, grid, midX, midY);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(255, 255, 255));
        g1 = this.getGridPosition(0.0f, 2.0f, grid, midX, midY);
        int t1 = g1[0] = (int)((double)g1[0] - (double)grid * 0.15);
        int t2 = g1[0] = (int)((double)g1[0] + (double)grid * 0.3);
        int h = g1[3] - g1[1] + 2;
        int w = t2 - t1;
        float d = (float)w / (float)h;
        float ms = w;
        for (y = 0; y < h; ++y) {
            int wi = (int)Math.ceil(ms);
            int y22 = y + g1[1] - 1;
            for (int x3 = t2; x3 > t2 - wi; --x3) {
                image.setSample(x3, y22, colorBlack);
            }
            ms -= d;
        }
        g1 = this.getGridPosition(-6.0f, 3.0f, grid, midX, midY);
        g2 = this.getGridPosition(1.0f, 3.0f, grid, midX, midY);
        this.gradientArea(image, g1[0], g1[1], g2[2], g2[3], true);
        g1 = this.getGridPosition(-6.0f, 4.0f, grid, midX, midY);
        g2 = this.getGridPosition(1.0f, 4.0f, grid, midX, midY);
        this.gradientArea(image, g1[0], g1[1], g2[2], g2[3], false);
        g1 = this.getGridPosition(2.0f, 3.0f, grid, midX, midY);
        g2 = this.getGridPosition(5.0f, 4.0f, grid, midX, midY);
        this.fillArea(image, g1[0], g1[1], g2[2], g2[3], this.getColor(0, 0, 0));
        g2 = this.getGridPosition(3.0f, 4.0f, grid, midX, midY);
        for (y = g1[1]; y <= g2[3]; y += 2) {
            for (int x4 = g1[0]; x4 <= g2[2] + 1; ++x4) {
                image.setSampleSafe(x4, y, colorWhite);
            }
        }
        g1 = this.getGridPosition(4.0f, 3.0f, grid, midX, midY);
        g2 = this.getGridPosition(5.0f, 4.0f, grid, midX, midY);
        for (int x5 = g1[0]; x5 <= g2[2]; x5 += 2) {
            for (int y4 = g1[1]; y4 <= g2[3]; ++y4) {
                image.setSampleSafe(x5, y4, colorWhite);
            }
        }
        g1 = this.getGridPosition(0.0f, -7.0f, grid, midX, midY);
        int radius = (int)Math.round((double)midY - ((double)g1[1] + (double)grid * 0.1));
        this.drawCircle(image, radius, midX, midY, colorWhite);
    }

    private void fillArea(FSIImage image, int startX, int startY, int stopX, int stopY, int cColor) {
        for (int y = startY; y <= stopY; ++y) {
            for (int x = startX; x <= stopX; ++x) {
                image.setSampleSafe(x, y, cColor);
            }
        }
    }

    private void vLines(FSIImage image, int startX, int startY, int stopX, int stopY, int steps, int cColor) {
        int c = 0;
        for (int x = startX; x <= stopX; ++x) {
            if (c < steps && c >= 0) {
                for (int y = startY; y <= stopY; ++y) {
                    image.setSampleSafe(x, y, cColor);
                }
            } else if (c >= steps) {
                c = -steps;
            }
            ++c;
        }
    }

    private void gradientArea(FSIImage image, int startX, int startY, int stopX, int stopY, boolean red) {
        int c1;
        int m1;
        int h;
        int positions = stopX + 1 - startX;
        int[] cols = new int[positions];
        int half = positions / 2;
        int half2 = positions - half;
        float steps = 255.0f / (float)half;
        for (h = 0; h < half; ++h) {
            m1 = Math.round((float)h * steps);
            c1 = red ? this.getColor(255, 255 - m1, 255 - m1) : this.getColor(255 - m1, 255 - m1, 255);
            cols[h] = c1;
        }
        for (h = 0; h < half2; ++h) {
            m1 = 255 - Math.round((float)h * steps);
            c1 = red ? this.getColor(m1, 0, 0) : this.getColor(0, 0, m1);
            cols[h + half] = c1;
        }
        for (int y = startY; y <= stopY; ++y) {
            int x = startX;
            int c = 0;
            while (x <= stopX) {
                image.setSampleSafe(x, y, cols[c]);
                ++x;
                ++c;
            }
        }
    }

    private int getColor(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private int[] getGridPosition(float gridX, float gridY, float gridSize, int midX, int midY) {
        int t;
        int x1 = Math.round(gridX * gridSize) + 1 + midX;
        int x2 = Math.round((gridX + 1.0f) * gridSize) - 1 + midX;
        int y1 = Math.round(gridY * gridSize) + 1 + midY;
        int y2 = Math.round((gridY + 1.0f) * gridSize) - 1 + midY;
        if (x1 > x2) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y1 > y2) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        return new int[]{x1, y1, x2, y2};
    }

    public static enum Modes {
        CIRCLES,
        DOTS,
        GRID,
        HLINES,
        VLINES,
        FUBK,
        COLORS,
        GAUSS,
        FSI;

    }
}

