/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.dither;

import com.neptunelabs.imagemanipulator.dither.Ditherer;
import com.neptunelabs.imagemanipulator.palette.Palette;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagereader.image.FSIImage;

public final class FloydSteinberg
extends Ditherer {
    private static final int[] matrixFloydSteinberg = new int[]{0, 0, 0, 0, 0, 7, 3, 5, 1};
    private final boolean serpentine;
    private final int sum = 16;

    public FloydSteinberg(Palette palette, boolean serpentine) {
        super(palette);
        this.serpentine = serpentine;
    }

    @Override
    public Ditherer getNewInstance() {
        return new FloydSteinberg(this.palette, this.serpentine);
    }

    @Override
    public byte[] dither(FSIImage image) {
        this.useAlpha = this.palette.hasAlpha();
        this.transparentIndex = this.palette.getTransparentIndex();
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] output = new byte[width * height];
        int index = 0;
        for (int y = 0; y < height; ++y) {
            int direction;
            boolean reverse;
            boolean bl = reverse = this.serpentine && (y & 1) == 1;
            if (reverse) {
                index = y * width + width - 1;
                direction = -1;
            } else {
                index = y * width;
                direction = 1;
            }
            for (int x = 0; x < width; ++x) {
                int rgb1 = image.getSample(index);
                int rgb2Index = this.palette.findColorIndex(rgb1);
                output[index] = (byte)rgb2Index;
                int[] rgb2 = this.palette.getColor(rgb2Index);
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int er = r1 - rgb2[0];
                int eg = g1 - rgb2[1];
                int eb = b1 - rgb2[2];
                for (int i = -1; i <= 1; ++i) {
                    int iy = i + y;
                    if (0 > iy || iy >= height) continue;
                    for (int j = -1; j <= 1; ++j) {
                        int w;
                        int jx = j + x;
                        if (0 > jx || jx >= width || (w = reverse ? matrixFloydSteinberg[(i + 1) * 3 - j + 1] : matrixFloydSteinberg[(i + 1) * 3 + j + 1]) == 0) continue;
                        int k = reverse ? index - j : index + j;
                        rgb1 = image.getSample(k);
                        int a1 = rgb1 >> 24 & 0xFF;
                        r1 = rgb1 >> 16 & 0xFF;
                        g1 = rgb1 >> 8 & 0xFF;
                        b1 = rgb1 & 0xFF;
                        image.setSample(k, a1 << 24 | BaseImageUtils.clampFT255(r1 += er * w / 16) << 16 | BaseImageUtils.clampFT255(g1 += eg * w / 16) << 8 | BaseImageUtils.clampFT255(b1 += eb * w / 16));
                    }
                }
                index += direction;
            }
        }
        return output;
    }
}

