/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class EncoderDump {
    public static void printNode(Node node, int level) {
        Node child;
        EncoderDump.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node attrib = map.item(i);
                System.out.print(" " + attrib.getNodeName() + "=\"" + attrib.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) != null) {
            System.out.println(">");
            while (child != null) {
                EncoderDump.printNode(child, level + 1);
                child = child.getNextSibling();
            }
            EncoderDump.indent(level);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    private static void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuilder out = new StringBuilder(in.length * 2);
        while (i < in.length) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            out.append(' ');
            if (++i % 16 != 0) continue;
            out.append('\n');
        }
        String rslt = new String(out);
        return rslt;
    }
}

