/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.dither.Ditherer;
import com.neptunelabs.imagemanipulator.dither.FloydSteinberg;
import com.neptunelabs.imagemanipulator.dither.NoDither;
import com.neptunelabs.imagemanipulator.palette.Palette;
import com.neptunelabs.imagemanipulator.palette.PaletteEuclideanSquareRGB;
import com.neptunelabs.imagemanipulator.quantizer.ColorOctree;
import com.neptunelabs.imagemanipulator.quantizer.NeuQuant;
import com.neptunelabs.imagemanipulator.quantizer.Quantizer;
import com.neptunelabs.imagemanipulator.quantizer.Websafe;
import com.neptunelabs.imagereader.image.FSIImage;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class ImageEncoderUtils {
    protected final FSILogger logger;
    protected FSIImage image;
    protected ImageWriter writer;
    protected ImageOutputStream imageoutput;
    protected OutputStream output;
    protected boolean changed = false;
    protected IIOMetadata metadata = null;
    protected int dpi = 0;
    protected String software = null;
    protected String copyright = null;
    protected byte[] iccData = null;
    protected byte[] customChunk = null;
    protected byte[] customChunkContent = null;
    protected byte[] duckyTag = null;

    protected ImageEncoderUtils(FSILogger logger) {
        this.logger = logger;
    }

    public void setImage(FSIImage image) {
        this.image = image;
    }

    public void setImageOutputStream(ImageOutputStream output) {
        this.imageoutput = output;
        this.writer.setOutput(output);
    }

    public void setOutputStream(OutputStream output) {
        this.output = output;
    }

    public void setDPI(int dpi) {
        this.dpi = dpi;
        this.changed = true;
    }

    public void setSoftware(String comment) {
        this.software = comment;
        this.changed = true;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
        this.changed = true;
    }

    public void setCustomPNGChunk(byte[] customChunk, byte[] customChunkContent) {
        this.customChunk = customChunk;
        this.customChunkContent = customChunkContent;
        this.changed = true;
    }

    public void setICCProfile(ICC_Profile iccData) {
        this.setICCProfile(iccData.getData());
    }

    public void setICCProfile(byte[] iccData) {
        this.iccData = iccData;
        this.changed = true;
    }

    protected boolean isPackedByteImage(RenderedImage im) {
        SampleModel imageSampleModel = im.getSampleModel();
        if (imageSampleModel instanceof SinglePixelPackedSampleModel) {
            for (int i = 0; i < imageSampleModel.getNumBands(); ++i) {
                if (imageSampleModel.getSampleSize(i) <= 8) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected static Quantizer getQuantizer(QuantizerMode quantizerMode, int imageSize, int quantizerSampleFactor, int maxColors, boolean useAlpha) throws IOException {
        Quantizer quantizer;
        if (quantizerMode == QuantizerMode.OCTREE) {
            int sampleDepth = quantizerSampleFactor <= 0 || quantizerSampleFactor > imageSize ? 1 : quantizerSampleFactor;
            quantizer = new ColorOctree(maxColors, useAlpha, sampleDepth);
        } else if (quantizerMode == QuantizerMode.NEUQUANT) {
            int sampleDepth = quantizerSampleFactor <= 0 || quantizerSampleFactor > imageSize ? 10 : quantizerSampleFactor;
            quantizer = new NeuQuant(maxColors, useAlpha, sampleDepth);
        } else if (quantizerMode == QuantizerMode.WEBSAFE) {
            quantizer = new Websafe(maxColors, useAlpha);
        } else {
            throw new IOException("Unrecognized Quantizer");
        }
        return quantizer;
    }

    protected static Ditherer getDitherer(DithererMode dithererMode, Palette palette, boolean serpentine) throws IOException {
        Ditherer ditherer;
        if (dithererMode == DithererMode.NODITHER) {
            ditherer = new NoDither(palette);
        } else if (dithererMode == DithererMode.FLOYDSTEINBERG) {
            ditherer = new FloydSteinberg(palette, serpentine);
        } else {
            throw new IOException("Unrecognized Ditherer");
        }
        return ditherer;
    }

    protected static Palette getPalette(PaletteMode paletteMode) throws IOException {
        if (paletteMode != PaletteMode.EUCLIDEANSQUARERGB) {
            throw new IOException("Unrecognized Palette");
        }
        Palette palette = PaletteEuclideanSquareRGB.getInstance();
        return palette;
    }

    public static enum PaletteMode {
        EUCLIDEANSQUARERGB;

    }

    public static enum QuantizerMode {
        OCTREE,
        NEUQUANT,
        WEBSAFE;

    }

    public static enum DithererMode {
        FLOYDSTEINBERG,
        NODITHER;

    }
}

