/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.gif;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.imagemanipulator.dither.Ditherer;
import com.neptunelabs.imagemanipulator.encoder.gif.GIFFrame;
import com.neptunelabs.imagemanipulator.encoder.gif.LZWEncoder;
import com.neptunelabs.imagemanipulator.palette.Palette;
import com.neptunelabs.imagemanipulator.quantizer.Quantizer;
import com.neptunelabs.imagereader.image.FSIImage;
import java.io.IOException;
import java.util.concurrent.Callable;

class FrameBuilder
implements Callable<GIFFrame>,
PriorityExecutor.Important {
    private final int order;
    private final int priority;
    private FSIImage image;
    private Quantizer quantizer;
    private Ditherer ditherer;
    private Palette globalPalette;
    private int matteColor;

    FrameBuilder(int order, int priority) {
        this.order = order;
        this.priority = priority;
    }

    void setParameters(FSIImage image, Quantizer quantizer, Ditherer ditherer, Palette palette, int matteColor) {
        this.image = image;
        this.quantizer = quantizer;
        this.ditherer = ditherer;
        this.globalPalette = palette;
        this.matteColor = matteColor;
    }

    @Override
    public GIFFrame call() {
        Palette palette;
        GIFFrame frame = new GIFFrame();
        frame.order = this.order;
        frame.success = true;
        if (this.quantizer != null) {
            this.quantizer.addImageData(this.image);
            palette = this.globalPalette.clone();
            palette.setPalette(this.quantizer.getPalette(), this.quantizer.hasAlpha(), this.matteColor);
            frame.palette = palette.getPalette();
        } else {
            palette = this.globalPalette.clone();
        }
        if (palette.hasAlpha()) {
            frame.transIndex = palette.getTransparentIndex();
        }
        this.ditherer.setPalette(palette);
        int colorDepth = 8;
        byte[] indexedPixels = this.ditherer.dither(this.image);
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast((int)this.image.getByteSize());){
            LZWEncoder encoder = new LZWEncoder(this.image.getWidth(), this.image.getHeight(), indexedPixels, colorDepth);
            encoder.encode(baos);
            frame.lzfData = baos.toByteArray();
        }
        catch (IOException e) {
            frame.success = false;
        }
        return frame;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

