/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.gif;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutorCompletionService;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.dither.Ditherer;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.imagemanipulator.encoder.gif.FrameBuilder;
import com.neptunelabs.imagemanipulator.encoder.gif.GIFFrame;
import com.neptunelabs.imagemanipulator.palette.Palette;
import com.neptunelabs.imagemanipulator.quantizer.Quantizer;
import com.neptunelabs.imagereader.image.FSIImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class GIFBuilder
extends ImageEncoderUtils {
    private final boolean multiImage;
    private final int priority;
    private final PriorityExecutorCompletionService<GIFFrame> exsv;
    private final List<Future<GIFFrame>> futures = new ArrayList<Future<GIFFrame>>();
    private int width;
    private int height;
    private int frameCount = 0;
    private int repeat = 0;
    private int delay = 15;
    private boolean started = false;
    private OutputStream out;
    private int palSize = 7;
    private int dispose = -1;
    private GIFFrame firstFrame = null;
    private boolean sizeSet = false;
    private ImageEncoderUtils.DithererMode dithererMode = null;
    private ImageEncoderUtils.QuantizerMode quantizerMode = null;
    private ImageEncoderUtils.PaletteMode paletteMode = null;
    private boolean useAlpha;
    private int quantizerSampleFactor;
    private int maxColors;
    private int matteColor;
    private boolean useLocalColorTables;
    private boolean dithererSerpentine;
    private Palette globalPalette = null;
    private String comment = null;

    GIFBuilder(boolean multiImage, ExecutorPool executorPool, FSILogger logger, int priority) {
        super(logger);
        this.multiImage = multiImage;
        this.priority = priority;
        this.exsv = new PriorityExecutorCompletionService(executorPool.getExecutorService(ExecutorPool.Type.RENDERER_CPU));
    }

    public void setDelay(int ms) {
        this.delay = Math.round((float)ms / 10.0f);
    }

    public void setDispose(int code) {
        if (code >= 0) {
            this.dispose = code;
        }
    }

    public void setRepeat(int iter) {
        if (iter >= 0) {
            this.repeat = iter;
        }
    }

    public void setMatteColor(int matteColor) {
        this.matteColor = matteColor;
    }

    public void setDithererMode(ImageEncoderUtils.DithererMode value, boolean serpentine) {
        this.dithererMode = value;
        this.dithererSerpentine = serpentine;
    }

    public void setQuantizerMode(ImageEncoderUtils.QuantizerMode mode, int quantizerSampleFactor, int maxColors, boolean useAlpha) {
        this.quantizerMode = mode;
        this.quantizerSampleFactor = quantizerSampleFactor;
        this.maxColors = maxColors;
        this.useAlpha = useAlpha;
    }

    public void setPaletteMode(ImageEncoderUtils.PaletteMode value, boolean state) {
        this.paletteMode = value;
        this.useLocalColorTables = state;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean addFrame(FSIImage im) {
        if (im == null || !this.started) {
            return false;
        }
        boolean ok = true;
        try {
            if (!this.sizeSet) {
                this.width = im.getWidth();
                this.height = im.getHeight();
                this.sizeSet = true;
            }
            if (this.firstFrame == null) {
                Quantizer quantizer = GIFBuilder.getQuantizer(this.quantizerMode, (int)im.getIntSize(), this.quantizerSampleFactor, this.maxColors, this.useAlpha);
                this.globalPalette = GIFBuilder.getPalette(this.paletteMode);
                Ditherer ditherer = GIFBuilder.getDitherer(this.dithererMode, this.globalPalette, this.dithererSerpentine);
                FrameBuilder fb = new FrameBuilder(this.frameCount++, this.priority);
                fb.setParameters(im, quantizer, ditherer, this.globalPalette, this.matteColor);
                this.firstFrame = fb.call();
                this.globalPalette.setPalette(this.firstFrame.palette, quantizer.hasAlpha(), this.matteColor);
            } else if (im.getWidth() == this.width && im.getHeight() == this.height) {
                Palette palette;
                Quantizer quantizer;
                if (this.useLocalColorTables) {
                    quantizer = GIFBuilder.getQuantizer(this.quantizerMode, (int)im.getIntSize(), this.quantizerSampleFactor, this.maxColors, this.useAlpha);
                    palette = GIFBuilder.getPalette(this.paletteMode);
                } else {
                    palette = this.globalPalette;
                    quantizer = null;
                }
                Ditherer ditherer = GIFBuilder.getDitherer(this.dithererMode, this.globalPalette, this.dithererSerpentine);
                FrameBuilder fb = new FrameBuilder(this.frameCount++, this.priority);
                fb.setParameters(im, quantizer, ditherer, palette, this.matteColor);
                this.futures.add(this.exsv.submit(fb));
            } else {
                ok = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ok = false;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finish() throws IOException {
        if (!this.started || this.firstFrame == null) {
            return false;
        }
        boolean ok = true;
        this.started = false;
        this.writeLSD(this.palSize);
        this.writePalette(this.firstFrame.palette);
        if (this.repeat >= 0 && this.multiImage) {
            this.writeNetscapeExt();
        }
        if (this.comment != null) {
            this.writeComment();
        }
        this.writeGraphicCtrlExt(this.firstFrame.transIndex);
        this.writeImageDesc(false, this.palSize);
        this.out.write(this.firstFrame.lzfData);
        if (this.multiImage) {
            try {
                int frameFutureCount = this.exsv.count();
                GIFFrame[] frames = new GIFFrame[frameFutureCount];
                for (int c = 0; c < frameFutureCount; ++c) {
                    GIFFrame frame;
                    frames[frame.order - 1] = frame = this.exsv.take().get();
                }
                for (GIFFrame frame : frames) {
                    this.writeGraphicCtrlExt(frame.transIndex);
                    if (frame.palette != null) {
                        this.writeImageDesc(true, this.palSize);
                        this.writePalette(frame.palette);
                    } else {
                        this.writeImageDesc(false, this.palSize);
                    }
                    this.out.write(frame.lzfData);
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                for (Future<GIFFrame> f : this.futures) {
                    f.cancel(true);
                }
            }
            finally {
                for (Future<GIFFrame> f : this.futures) {
                    f.cancel(true);
                }
            }
        }
        this.out.write(59);
        this.out.flush();
        this.out.close();
        return ok;
    }

    public boolean setUpperOutputStream(OutputStream os) {
        if (os == null) {
            return false;
        }
        boolean ok = true;
        this.out = os;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException e) {
            ok = false;
        }
        this.started = ok;
        return this.started;
    }

    private void writeGraphicCtrlExt(int transIndex) throws IOException {
        int disp;
        int transp;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (transIndex == -1) {
            transp = 0;
            disp = 0;
        } else {
            transp = 1;
            disp = 2;
        }
        if (this.dispose >= 0) {
            disp = this.dispose & 7;
        }
        this.out.write(0 | (disp <<= 2) | 0 | transp);
        this.writeShort(this.delay);
        this.out.write(transIndex);
        this.out.write(0);
    }

    private void writeImageDesc(boolean localColorTable, int paletteBitSize) throws IOException {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (localColorTable) {
            this.out.write(0x80 | this.palSize);
        } else {
            this.out.write(0);
        }
    }

    private void writeLSD(int palSize) throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | palSize);
        this.out.write(0);
        this.out.write(0);
    }

    private void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    private void writeComment() throws IOException {
        this.out.write(33);
        this.out.write(254);
        int remainder = this.comment.length() % 255;
        int blocks = this.comment.length() / 255;
        int n = blocks + (remainder > 0 ? 1 : 0);
        int index = 0;
        for (int i = 0; i < n; ++i) {
            int sizeCE = i < blocks ? 255 : remainder;
            this.out.write(sizeCE);
            this.writeString(this.comment.substring(index, index + sizeCE));
            index += sizeCE;
        }
        this.out.write(0);
    }

    private void writePalette(byte[] colorTab) throws IOException {
        this.out.write(colorTab, 0, colorTab.length);
        int n = 768 - colorTab.length;
        for (int i = 0; i < n; ++i) {
            this.out.write(0);
        }
    }

    private void writeShort(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    private void writeString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this.out.write((byte)s.charAt(i));
        }
    }
}

