/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.gif;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoder;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.imagemanipulator.encoder.gif.GIFBuilder;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.io.IOException;
import java.util.ArrayList;

public final class GIFEncoder
extends ImageEncoderUtils
implements ImageEncoder {
    private final ExecutorPool executorPool;
    private final int priority;
    private int animationLoopCount = 0;
    private boolean animationFramePalette = false;
    private int animationDelay = 150;
    private int quantizerSampleFactor = 10;
    private int maxColors = 256;
    private int matteColor = 0xFFFFFF;
    private ImageEncoderUtils.DithererMode dithererMode;
    private ImageEncoderUtils.QuantizerMode quantizerMode;
    private ImageEncoderUtils.PaletteMode paletteMode;
    private boolean serpentine = true;
    private final ArrayList<FSIImage> images = new ArrayList();

    public GIFEncoder(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger);
        this.executorPool = executorPool;
        this.priority = priority;
    }

    public void setMaxColors(int value) {
        this.maxColors = value < 2 || value > 256 ? 256 : value;
    }

    public void setMatteColor(int color) {
        this.matteColor = color;
    }

    public void setSerpentine(boolean state) {
        this.serpentine = state;
    }

    public void setDitherer(ImageEncoderUtils.DithererMode dithererMode) {
        this.dithererMode = dithererMode;
    }

    public void setQuantizer(ImageEncoderUtils.QuantizerMode quantizerMode) {
        this.quantizerMode = quantizerMode;
    }

    public void setQuantizerSampleDepth(int value) {
        this.quantizerSampleFactor = value;
    }

    public void setPalette(ImageEncoderUtils.PaletteMode paletteMode) {
        this.paletteMode = paletteMode;
    }

    public void setAnimationLoop(int state) {
        this.animationLoopCount = state;
    }

    public void setAnimationDelay(int ms) {
        this.animationDelay = ms;
    }

    public void setAnimationFramePalette(boolean state) {
        this.animationFramePalette = state;
    }

    public void addImage(FSIImage imageValue) {
        this.images.add(imageValue);
    }

    @Override
    public void encode() throws IOException {
        String annotation;
        int imageCount;
        boolean useAlpha = false;
        if (this.images.size() > 0) {
            imageCount = this.images.size();
            for (FSIImage simage : this.images) {
                if (!simage.hasAlpha()) continue;
                useAlpha = true;
                break;
            }
        } else {
            imageCount = 1;
            useAlpha = this.image.hasAlpha();
        }
        GIFBuilder gifBuilder = new GIFBuilder(imageCount > 1, this.executorPool, this.logger, this.priority);
        gifBuilder.setMatteColor(this.matteColor);
        gifBuilder.setDithererMode(this.dithererMode, this.serpentine);
        gifBuilder.setPaletteMode(this.paletteMode, this.animationFramePalette);
        gifBuilder.setQuantizerMode(this.quantizerMode, this.quantizerSampleFactor, this.maxColors, useAlpha);
        gifBuilder.setUpperOutputStream(this.output);
        gifBuilder.setDelay(this.animationDelay);
        gifBuilder.setRepeat(this.animationLoopCount);
        StringBuilder sb = new StringBuilder();
        if (this.copyright != null) {
            sb.append(this.copyright);
        }
        if (this.software != null) {
            if (this.copyright != null) {
                sb.append(" ");
            }
            sb.append(this.software);
        }
        if ((annotation = sb.toString()) != null && annotation.length() > 0) {
            gifBuilder.setComment(annotation);
        }
        if (this.image != null) {
            if (this.image.hasAlpha() && this.image.getMode() == FSIImageMode.ARGB) {
                ParallelColorOperation colorOperation = new ParallelColorOperation(this.logger, this.executorPool, this.priority);
                try {
                    this.image = colorOperation.transform(this.image, new MatteTransparent(this.matteColor, true), false);
                }
                catch (ProcessingException e) {
                    throw new IOException(e);
                }
            }
            gifBuilder.addFrame(this.image);
        } else if (this.images.size() > 0) {
            for (FSIImage aimage : this.images) {
                if (aimage.hasAlpha() && aimage.getMode() == FSIImageMode.ARGB) {
                    ParallelColorOperation colorOperation = new ParallelColorOperation(this.logger, this.executorPool, this.priority);
                    try {
                        aimage = colorOperation.transform(aimage, new MatteTransparent(this.matteColor, true), false);
                    }
                    catch (ProcessingException e) {
                        throw new IOException(e);
                    }
                }
                gifBuilder.addFrame(aimage);
            }
        }
        gifBuilder.finish();
        this.output.close();
    }

    @Override
    public String getName() {
        return "GIFEncoder";
    }

    @Override
    public void dispose() {
        if (this.writer != null) {
            this.writer.dispose();
        }
    }
}

