/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.jpeg;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoder;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.imagereader.converter.FSIImageConverter;
import com.neptunelabs.imagereader.image.FSIImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;

public final class JPEGEncoder
extends ImageEncoderUtils
implements ImageEncoder {
    private JPEGImageWriteParam iwparam;
    private IIOImage iioimage;

    public JPEGEncoder(FSILogger logger, JPEGPreparation jpegPrep) {
        super(logger);
        Iterator<ImageWriter> iwit = ImageIO.getImageWritersByFormatName("jpg");
        if (iwit.hasNext()) {
            this.writer = iwit.next();
        }
        this.iwparam = jpegPrep.getImageWriteParam();
        this.metadata = jpegPrep.getMetadata();
    }

    @Override
    public void encode() throws IOException {
        if (this.writer != null && this.iioimage != null) {
            this.writer.write(this.metadata, this.iioimage, this.iwparam);
        } else {
            this.logger.log(3600, "Encoder initiated");
        }
    }

    @Override
    public void setImage(FSIImage image) {
        this.image = image;
        BufferedImage bi = FSIImageConverter.convertToBufferedImage(image, false, 0xFFFFFF);
        this.iioimage = new IIOImage(bi, null, this.metadata);
    }

    public void setBufferedImage(BufferedImage bi) {
        this.iioimage = new IIOImage(bi, null, this.metadata);
    }

    @Override
    public void setSoftware(String comment) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCopyright(String copyright) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return "JPEGEncoder";
    }

    @Override
    public void dispose() {
        if (this.writer != null) {
            this.writer.dispose();
            this.writer = null;
            this.iwparam = null;
            this.metadata = null;
        }
    }
}

