/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.jpeg;

import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JPEGPreparation {
    private final float quality;
    private final boolean optimizeHuffmann;
    private final JPEGImageWriteParam jpegParam;
    private final IIOMetadata metadata;
    private final String software;
    private final String copyright;
    private final int dpi;
    private final byte[] iccData;
    private final boolean setDucky;
    private static final String nativeImageMetadataFormatName = "javax_imageio_jpeg_image_1.0";
    private static final int APP12 = 236;
    private final int[] hScaling;
    private final int[] vScaling;
    private final ChromaSubsampling chromaSubsampling;

    public JPEGPreparation(float quality, boolean optimizeHuffmann, ChromaSubsampling chromaSubsampling, String software, String copyright, int dpi, byte[] iccData, boolean ducky) throws UnsupportedEncodingException {
        this.quality = quality;
        this.software = software;
        this.copyright = copyright;
        this.dpi = dpi;
        this.iccData = iccData;
        this.optimizeHuffmann = optimizeHuffmann;
        this.setDucky = ducky;
        this.jpegParam = new JPEGImageWriteParam(Locale.getDefault());
        this.jpegParam.setCompressionMode(2);
        this.jpegParam.setCompressionQuality(quality);
        this.jpegParam.setProgressiveMode(0);
        this.jpegParam.setOptimizeHuffmanTables(optimizeHuffmann);
        ImageWriter writer = ImageIO.getImageWritersBySuffix("jpeg").next();
        BufferedImage bufferedImage = new BufferedImage(1, 1, 5);
        ImageTypeSpecifier imageType = new ImageTypeSpecifier(bufferedImage.getColorModel(), bufferedImage.getSampleModel());
        bufferedImage.flush();
        this.metadata = writer.getDefaultImageMetadata(imageType, this.jpegParam);
        if (chromaSubsampling == ChromaSubsampling.CS444) {
            this.hScaling = new int[]{1, 1, 1};
            this.vScaling = new int[]{1, 1, 1};
        } else if (chromaSubsampling == ChromaSubsampling.CS422) {
            this.hScaling = new int[]{2, 1, 1};
            this.vScaling = new int[]{2, 2, 2};
        } else {
            this.hScaling = new int[]{2, 1, 1};
            this.vScaling = new int[]{2, 1, 1};
        }
        this.chromaSubsampling = chromaSubsampling;
        this.transferSettings();
        if (!optimizeHuffmann) {
            JPEGQTable[] jpegQTables = new JPEGQTable[]{JPEGQTable.K1Luminance.getScaledInstance(quality, true), JPEGQTable.K2Chrominance.getScaledInstance(quality, true)};
            JPEGHuffmanTable[] acTables = JPEGPreparation.getDefaultHuffmanTables(false);
            JPEGHuffmanTable[] dcTables = JPEGPreparation.getDefaultHuffmanTables(true);
            this.jpegParam.setEncodeTables(jpegQTables, dcTables, acTables);
        }
    }

    public float getQuality() {
        return this.quality;
    }

    public boolean getOptimized() {
        return this.optimizeHuffmann;
    }

    public int[] getChromaHScaling() {
        return this.hScaling;
    }

    public int[] getChromaVScaling() {
        return this.vScaling;
    }

    public ChromaSubsampling getChromaSubsampling() {
        return this.chromaSubsampling;
    }

    public byte[] getICC() {
        return this.iccData;
    }

    public JPEGImageWriteParam getImageWriteParam() {
        return this.jpegParam;
    }

    public JPEGImageWriteParam getJPEGParam() {
        return this.jpegParam;
    }

    public IIOMetadata getMetadata() {
        return this.metadata;
    }

    private static JPEGHuffmanTable[] getDefaultHuffmanTables(boolean wantDC) {
        JPEGHuffmanTable[] tables = new JPEGHuffmanTable[2];
        if (wantDC) {
            tables[0] = JPEGHuffmanTable.StdDCLuminance;
            tables[1] = JPEGHuffmanTable.StdDCChrominance;
        } else {
            tables[0] = JPEGHuffmanTable.StdACLuminance;
            tables[1] = JPEGHuffmanTable.StdACChrominance;
        }
        return tables;
    }

    private void transferSettings() throws UnsupportedEncodingException {
        if (this.metadata != null) {
            Node node = this.metadata.getAsTree(nativeImageMetadataFormatName);
            NodeList nl = node.getChildNodes();
            block2: for (int j = 0; j < nl.getLength(); ++j) {
                NodeList childNodes;
                Node n = nl.item(j);
                if (n.getNodeName().equals("JPEGvariety")) {
                    childNodes = n.getChildNodes();
                    for (int k = 0; k < childNodes.getLength(); ++k) {
                        if (!childNodes.item(k).getNodeName().equals("app0JFIF")) continue;
                        if (this.iccData != null) {
                            IIOMetadataNode iccNode = new IIOMetadataNode("app2ICC");
                            iccNode.setNodeValue(JPEGPreparation.convertObjectToString(this.iccData));
                            childNodes.item(k).appendChild(iccNode);
                            continue block2;
                        }
                        if (this.dpi <= 0) continue block2;
                        Element app0 = (Element)childNodes.item(k);
                        app0.setAttribute("Xdensity", Integer.toString(this.dpi));
                        app0.setAttribute("Ydensity", Integer.toString(this.dpi));
                        app0.setAttribute("resUnits", "1");
                        continue block2;
                    }
                    continue;
                }
                if (!n.getNodeName().equals("markerSequence")) continue;
                childNodes = n.getChildNodes();
                boolean comSpecFound = false;
                for (int k = 0; k < childNodes.getLength(); ++k) {
                    if (!childNodes.item(k).getNodeName().equals("sof")) continue;
                    Node sofNode = childNodes.item(k);
                    NodeList sofChilds = sofNode.getChildNodes();
                    for (int sk = 0; sk < sofChilds.getLength(); ++sk) {
                        Node vsfNode;
                        Node hsfNode;
                        Node comNode = sofChilds.item(sk);
                        if (!comNode.getNodeName().equals("componentSpec")) continue;
                        comSpecFound = true;
                        NamedNodeMap cmap = comNode.getAttributes();
                        Node cidNode = cmap.getNamedItem("componentId");
                        int cid = Integer.parseInt(cidNode.getNodeValue());
                        if (cid == 1) {
                            hsfNode = cmap.getNamedItem("HsamplingFactor");
                            vsfNode = cmap.getNamedItem("VsamplingFactor");
                            hsfNode.setNodeValue(Integer.toString(this.hScaling[0]));
                            vsfNode.setNodeValue(Integer.toString(this.vScaling[0]));
                            continue;
                        }
                        if (cid == 2) {
                            hsfNode = cmap.getNamedItem("HsamplingFactor");
                            vsfNode = cmap.getNamedItem("VsamplingFactor");
                            hsfNode.setNodeValue(Integer.toString(this.hScaling[1]));
                            vsfNode.setNodeValue(Integer.toString(this.vScaling[1]));
                            continue;
                        }
                        if (cid != 3) continue;
                        hsfNode = cmap.getNamedItem("HsamplingFactor");
                        vsfNode = cmap.getNamedItem("VsamplingFactor");
                        hsfNode.setNodeValue(Integer.toString(this.hScaling[2]));
                        vsfNode.setNodeValue(Integer.toString(this.vScaling[2]));
                    }
                    if (comSpecFound) break;
                }
                if (this.software != null) {
                    IIOMetadataNode commentNode = new IIOMetadataNode("com");
                    commentNode.setAttribute("comment", this.software);
                    n.appendChild(commentNode);
                }
                if (!this.setDucky) continue;
                IIOMetadataNode app12node = new IIOMetadataNode("unknown");
                app12node.setAttribute("MarkerTag", "236");
                app12node.setUserObject(this.buildJPEGDuckyTag());
                n.appendChild(app12node);
            }
            try {
                this.metadata.setFromTree(nativeImageMetadataFormatName, node);
            }
            catch (IIOInvalidTreeException e) {
                throw new UnsupportedEncodingException(e.getLocalizedMessage());
            }
        }
    }

    private static String convertObjectToString(Object obj) {
        if (obj == null) {
            return "";
        }
        String s = "";
        if (obj instanceof byte[]) {
            byte[] bArray;
            for (byte element : bArray = (byte[])obj) {
                s = s + element + " ";
            }
            return s;
        }
        if (obj instanceof int[]) {
            int[] iArray;
            for (int element : iArray = (int[])obj) {
                s = s + element + " ";
            }
            return s;
        }
        if (obj instanceof short[]) {
            short[] sArray;
            for (short element : sArray = (short[])obj) {
                s = s + element + " ";
            }
            return s;
        }
        return obj.toString();
    }

    private byte[] buildJPEGDuckyTag() throws UnsupportedEncodingException {
        int pos = 0;
        int len = 0;
        byte[] ducky = new String("Ducky").getBytes();
        len += ducky.length;
        len += 8;
        len = this.software != null ? (len += 4 + this.software.length()) : ++len;
        len = this.copyright != null ? (len += 4 + this.copyright.length()) : ++len;
        byte[] tag = new byte[len];
        System.arraycopy(ducky, 0, tag, 0, ducky.length);
        pos += ducky.length;
        tag[pos++] = 0;
        tag[pos++] = 1;
        tag[pos++] = 0;
        tag[pos++] = 4;
        tag[pos++] = 0;
        tag[pos++] = 0;
        tag[pos++] = 0;
        tag[pos++] = (byte)((int)(this.quality * 100.0f) & 0xFF);
        if (this.software != null) {
            byte[] softwareBytes = this.software.getBytes("ISO-8859-1");
            tag[pos++] = 0;
            tag[pos++] = 2;
            tag[pos++] = (byte)(softwareBytes.length >> 8 & 0xFF);
            tag[pos++] = (byte)(softwareBytes.length & 0xFF);
            System.arraycopy(softwareBytes, 0, tag, pos, softwareBytes.length);
            pos += softwareBytes.length;
        } else {
            tag[pos++] = 0;
        }
        if (this.copyright != null) {
            byte[] copyrightBytes = this.copyright.getBytes("ISO-8859-1");
            tag[pos++] = 0;
            tag[pos++] = 3;
            tag[pos++] = (byte)(copyrightBytes.length >> 8 & 0xFF);
            tag[pos++] = (byte)(copyrightBytes.length & 0xFF);
            System.arraycopy(copyrightBytes, 0, tag, pos, copyrightBytes.length);
            pos += copyrightBytes.length;
        } else {
            tag[pos++] = 0;
        }
        return tag;
    }

    public static enum ChromaSubsampling {
        CS444,
        CS422,
        CS420;

    }
}

