/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.png;

import com.neptunelabs.imagereader.image.FSIImage;

public final class BuildScanline {
    private final FSIImage image;
    private final int width;
    private final int len;
    private final int samples;
    private final int scanLen;
    private final byte[] scanLine;
    private final int mode;
    private int y;

    public BuildScanline(FSIImage image, int width, int bytesPerPixel) {
        this.image = image;
        this.width = width;
        this.samples = bytesPerPixel;
        this.len = width * bytesPerPixel;
        this.scanLen = width * bytesPerPixel;
        this.scanLine = new byte[this.scanLen];
        this.mode = bytesPerPixel == 1 ? 1 : (bytesPerPixel == 4 ? 3 : 2);
    }

    public void setY(int y) {
        this.y = y;
    }

    public byte[] getLine() {
        return this.scanLine;
    }

    public byte[] call() {
        int x;
        int scanPos = 0;
        for (x = 0; x < this.width; ++x) {
            int argb = this.image.getSample(x, this.y);
            if (this.mode != 1) {
                this.scanLine[scanPos++] = (byte)(argb >> 16 & 0xFF);
                this.scanLine[scanPos++] = (byte)(argb >> 8 & 0xFF);
            }
            this.scanLine[scanPos++] = (byte)(argb & 0xFF);
            if (this.mode != 3) continue;
            this.scanLine[scanPos++] = (byte)(argb >>> 24 & 0xFF);
        }
        for (x = this.len - 1; x >= this.samples; --x) {
            int n = x;
            this.scanLine[n] = (byte)(this.scanLine[n] - this.scanLine[x - this.samples]);
        }
        return this.scanLine;
    }
}

