/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.png;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.color.MatteTransparent;
import com.neptunelabs.imagemanipulator.color.ParallelColorOperation;
import com.neptunelabs.imagemanipulator.dither.Ditherer;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoder;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.imagemanipulator.palette.Palette;
import com.neptunelabs.imagemanipulator.quantizer.Quantizer;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public final class PNGEncoder
extends ImageEncoderUtils
implements ImageEncoder {
    private final ExecutorPool executorPool;
    private final int priority;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    private final byte[] IHDR = new byte[]{73, 72, 68, 82};
    private final byte[] IDAT = new byte[]{73, 68, 65, 84};
    private final byte[] IEND = new byte[]{73, 69, 78, 68};
    private final byte[] ICCP = new byte[]{105, 67, 67, 80};
    private final byte[] TEXT = new byte[]{116, 69, 88, 116};
    private final byte[] PHYS = new byte[]{112, 72, 89, 115};
    private final byte[] PLTE = new byte[]{80, 76, 84, 69};
    private final byte[] TRNS = new byte[]{116, 82, 78, 83};
    private final byte[] SRGB = new byte[]{115, 82, 71, 66};
    private final byte[] GAMA = new byte[]{103, 65, 77, 65};
    private final CRC32 crc = new CRC32();
    private int width;
    private int height;
    private boolean encodeAlpha = false;
    private int filter = 1;
    private int bytesPerPixel;
    private int compressionLevel = 4;
    private boolean grayScale = false;
    private int quantizerSampleFactor = 10;
    private int maxColors = -1;
    private int matteColor = 0xFFFFFF;
    private ImageEncoderUtils.DithererMode dithererMode;
    private ImageEncoderUtils.QuantizerMode quantizerMode;
    private ImageEncoderUtils.PaletteMode paletteMode;
    private boolean serpentine = true;

    public PNGEncoder(FSILogger logger, ExecutorPool executorPool, int priority) {
        super(logger);
        this.executorPool = executorPool;
        this.priority = priority;
    }

    @Override
    public String getName() {
        return "PNGEncoder";
    }

    public void setMaxColors(int value) {
        this.maxColors = value;
    }

    public void setMatteColor(int color) {
        this.matteColor = color;
    }

    public void setSerpentine(boolean state) {
        this.serpentine = state;
    }

    public void setDitherer(ImageEncoderUtils.DithererMode dithererMode) {
        this.dithererMode = dithererMode;
    }

    public void setQuantizer(ImageEncoderUtils.QuantizerMode quantizerMode) {
        this.quantizerMode = quantizerMode;
    }

    public void setQuantizerSampleDepth(int value) {
        this.quantizerSampleFactor = value;
    }

    public void setPalette(ImageEncoderUtils.PaletteMode paletteMode) {
        this.paletteMode = paletteMode;
    }

    @Override
    public void encode() throws IOException {
        if (this.image != null) {
            byte[] indexedData;
            byte[] pngIdBytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            if (!this.image.hasAlpha()) {
                this.encodeAlpha = false;
            }
            this.bytesPerPixel = this.maxColors > 0 ? 1 : (this.grayScale ? (this.encodeAlpha ? 2 : 1) : (this.encodeAlpha ? 4 : 3));
            PNGEncoder.writeBytes(this.output, pngIdBytes);
            this.writeHeader();
            this.writeSRGBChunk();
            this.writeGAMAChunk();
            if (this.maxColors > 0) {
                if (this.image.hasAlpha() && this.image.getMode() == FSIImageMode.ARGB) {
                    ParallelColorOperation colorOperation = new ParallelColorOperation(this.logger, this.executorPool, this.priority);
                    try {
                        this.image = colorOperation.transform(this.image, new MatteTransparent(this.matteColor, true), false);
                    }
                    catch (ProcessingException e) {
                        throw new IOException(e);
                    }
                }
                Quantizer quantizer = PNGEncoder.getQuantizer(this.quantizerMode, (int)this.image.getIntSize(), this.quantizerSampleFactor, this.maxColors, this.image.hasAlpha());
                quantizer.addImageData(this.image);
                byte[] quantizerPalette = quantizer.getPalette();
                Palette palette = PNGEncoder.getPalette(this.paletteMode);
                palette.setPalette(quantizerPalette, quantizer.hasAlpha(), this.matteColor);
                Ditherer ditherer = PNGEncoder.getDitherer(this.dithererMode, palette, this.serpentine);
                indexedData = ditherer.dither(this.image);
                byte[] paletteBytes = palette.getPalette();
                this.writePLTEChunk(paletteBytes);
                if (this.image.hasAlpha()) {
                    this.writeTRNSChunk(paletteBytes, palette.getTransparentIndex());
                }
            } else {
                indexedData = null;
                if (this.iccData != null) {
                    this.writeICC();
                }
            }
            if (this.copyright != null) {
                this.writeText("Copyright", this.copyright);
            }
            if (this.software != null) {
                this.writeText("Software", this.software);
            }
            if (this.dpi > 0) {
                this.writePHYSChunk(this.dpi);
            }
            if (this.customChunk != null && this.customChunkContent != null) {
                this.writeDirtyChunk(this.customChunk, this.customChunkContent);
            }
            if (indexedData == null) {
                this.writeIDATChunk();
            } else {
                this.writeIDATChunk(indexedData);
            }
            this.writeEnd();
            this.output.close();
        }
    }

    public void setEncodeAlpha(boolean state) {
        this.encodeAlpha = state;
    }

    public void setEncodeGray(boolean state) {
        this.grayScale = state;
    }

    public void setFilter(int filterNumber) {
        this.filter = filterNumber;
    }

    public void setCompressionLevel(int level) {
        if (level >= 0 && level <= 9) {
            this.compressionLevel = level;
        }
    }

    @Override
    public void dispose() {
        if (this.writer != null) {
            this.writer.dispose();
        }
    }

    private static void writeBytes(OutputStream os, byte[] dat) throws IOException {
        os.write(dat);
    }

    private static void writeInt4(OutputStream os, int n) throws IOException {
        byte[] temp = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        os.write(temp);
    }

    private static void writeByte(OutputStream os, int b) throws IOException {
        os.write((byte)b);
    }

    private void writeHeader() throws IOException {
        PNGEncoder.writeInt4(this.output, 13);
        ByteArrayWalker baw = ByteArrayWalker.allocate(17, ByteOrder.BIG_ENDIAN);
        baw.put(this.IHDR);
        baw.putInt(this.width);
        baw.putInt(this.height);
        baw.putByte(8);
        if (this.maxColors <= 0) {
            if (this.grayScale) {
                baw.putByte(this.encodeAlpha ? 4 : 0);
            } else {
                baw.putByte(this.encodeAlpha ? 6 : 2);
            }
        } else {
            baw.putByte(3);
        }
        baw.putByte(0);
        baw.putByte(0);
        baw.putByte(0);
        byte[] header = baw.array();
        this.crc.reset();
        this.crc.update(header);
        PNGEncoder.writeBytes(this.output, header);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private static final void filterSub(byte[] data, int len, int samples) {
        for (int x = len - 1; x >= samples; --x) {
            int n = x;
            data[n] = (byte)(data[n] - data[x - samples]);
        }
    }

    private void writeICC() throws IOException {
        this.crc.reset();
        this.crc.update(this.ICCP);
        this.crc.update(this.iccData);
        PNGEncoder.writeInt4(this.output, this.iccData.length);
        PNGEncoder.writeBytes(this.output, this.ICCP);
        PNGEncoder.writeBytes(this.output, this.iccData);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writeText(String marker, String text) throws IOException {
        byte[] markerBytes = marker.getBytes("ISO-8859-1");
        byte[] textBytes = text.getBytes("ISO-8859-1");
        ByteArrayWalker baw = ByteArrayWalker.allocate(markerBytes.length + 1 + textBytes.length, ByteOrder.BIG_ENDIAN);
        baw.put(markerBytes);
        baw.putByte(0);
        baw.put(textBytes);
        byte[] rawText = baw.array();
        this.crc.reset();
        this.crc.update(this.TEXT);
        this.crc.update(rawText);
        PNGEncoder.writeInt4(this.output, rawText.length);
        PNGEncoder.writeBytes(this.output, this.TEXT);
        PNGEncoder.writeBytes(this.output, rawText);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writeDirtyChunk(byte[] chunk, byte[] content) throws IOException {
        this.crc.reset();
        this.crc.update(chunk);
        this.crc.update(content);
        PNGEncoder.writeInt4(this.output, content.length);
        PNGEncoder.writeBytes(this.output, chunk);
        PNGEncoder.writeBytes(this.output, content);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writePHYSChunk(int dpiValue) throws IOException {
        int dpiMeter = (int)Math.round((double)dpiValue / 0.0254);
        ByteArrayWalker baw = ByteArrayWalker.allocate(13, ByteOrder.BIG_ENDIAN);
        baw.put(this.PHYS);
        baw.putInt(dpiMeter);
        baw.putInt(dpiMeter);
        baw.putByte(1);
        byte[] rawChunk = baw.array();
        this.crc.reset();
        this.crc.update(rawChunk);
        PNGEncoder.writeInt4(this.output, 9);
        PNGEncoder.writeBytes(this.output, rawChunk);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writeSRGBChunk() throws IOException {
        ByteArrayWalker baw = ByteArrayWalker.allocate(5, ByteOrder.BIG_ENDIAN);
        baw.put(this.SRGB);
        baw.putByte(0);
        byte[] rawChunk = baw.array();
        this.crc.reset();
        this.crc.update(rawChunk);
        PNGEncoder.writeInt4(this.output, 1);
        PNGEncoder.writeBytes(this.output, rawChunk);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writeGAMAChunk() throws IOException {
        ByteArrayWalker baw = ByteArrayWalker.allocate(8, ByteOrder.BIG_ENDIAN);
        int gamma = 45455;
        baw.put(this.GAMA);
        baw.putInt(45455);
        byte[] rawChunk = baw.array();
        this.crc.reset();
        this.crc.update(rawChunk);
        PNGEncoder.writeInt4(this.output, 4);
        PNGEncoder.writeBytes(this.output, rawChunk);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writePLTEChunk(byte[] palette) throws IOException {
        ByteArrayWalker baw = ByteArrayWalker.allocate(4 + palette.length, ByteOrder.BIG_ENDIAN);
        baw.put(this.PLTE);
        baw.put(palette);
        byte[] rawChunk = baw.array();
        this.crc.reset();
        this.crc.update(rawChunk);
        PNGEncoder.writeInt4(this.output, palette.length);
        PNGEncoder.writeBytes(this.output, rawChunk);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writeTRNSChunk(byte[] palette, int alphaIndex) throws IOException {
        int palLen = palette.length / 3;
        byte[] transPalette = new byte[palLen];
        for (int i = 0; i < palLen; ++i) {
            transPalette[i] = i == alphaIndex ? 0 : -1;
        }
        ByteArrayWalker baw = ByteArrayWalker.allocate(4 + transPalette.length, ByteOrder.BIG_ENDIAN);
        baw.put(this.TRNS);
        baw.put(transPalette);
        byte[] rawChunk = baw.array();
        this.crc.reset();
        this.crc.update(rawChunk);
        PNGEncoder.writeInt4(this.output, transPalette.length);
        PNGEncoder.writeBytes(this.output, rawChunk);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writeIDATChunk() throws IOException {
        Deflater scrunch = new Deflater(this.compressionLevel);
        ByteArrayOutputStreamFast outBytes = new ByteArrayOutputStreamFast((int)this.image.getByteSize());
        DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, scrunch, 8192);
        int scanLen = this.width * this.bytesPerPixel;
        byte[] scanLine = new byte[scanLen];
        this.image.setPosition(0L);
        int[] lines = new int[this.width * this.height];
        this.image.getSamples(lines, 0, lines.length);
        for (int y = 0; y < this.height; ++y) {
            int argb;
            int x;
            int scanPos = 0;
            compBytes.write(this.filter);
            if (this.grayScale) {
                for (x = 0; x < this.width; ++x) {
                    argb = lines[y * this.width + x];
                    scanLine[scanPos++] = (byte)(argb & 0xFF);
                    if (!this.encodeAlpha) continue;
                    scanLine[scanPos++] = (byte)(argb >>> 24 & 0xFF);
                }
            } else {
                for (x = 0; x < this.width; ++x) {
                    argb = lines[y * this.width + x];
                    scanLine[scanPos++] = (byte)(argb >> 16 & 0xFF);
                    scanLine[scanPos++] = (byte)(argb >> 8 & 0xFF);
                    scanLine[scanPos++] = (byte)(argb & 0xFF);
                    if (!this.encodeAlpha) continue;
                    scanLine[scanPos++] = (byte)(argb >>> 24 & 0xFF);
                }
            }
            if (this.filter == 1) {
                PNGEncoder.filterSub(scanLine, scanLen, this.bytesPerPixel);
            }
            compBytes.write(scanLine);
        }
        compBytes.close();
        scrunch.finish();
        byte[] compressedLines = outBytes.toByteArray();
        int nCompressed = compressedLines.length;
        this.crc.reset();
        this.crc.update(this.IDAT);
        this.crc.update(compressedLines);
        PNGEncoder.writeInt4(this.output, nCompressed);
        PNGEncoder.writeBytes(this.output, this.IDAT);
        PNGEncoder.writeBytes(this.output, compressedLines);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writeIDATChunk(byte[] indexedData) throws IOException {
        Deflater scrunch = new Deflater(this.compressionLevel);
        ByteArrayOutputStreamFast outBytes = new ByteArrayOutputStreamFast(1024);
        DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, scrunch, 8192);
        int scanLen = this.width * this.bytesPerPixel;
        byte[] scanLine = new byte[scanLen];
        for (int y = 0; y < this.height; ++y) {
            int scanPos = 0;
            compBytes.write(this.filter);
            for (int x = 0; x < this.width; ++x) {
                scanLine[scanPos++] = indexedData[y * this.width + x];
            }
            if (this.filter == 1) {
                PNGEncoder.filterSub(scanLine, scanLen, this.bytesPerPixel);
            }
            compBytes.write(scanLine);
        }
        compBytes.close();
        scrunch.finish();
        byte[] compressedLines = outBytes.toByteArray();
        int nCompressed = compressedLines.length;
        this.crc.reset();
        this.crc.update(this.IDAT);
        this.crc.update(compressedLines);
        PNGEncoder.writeInt4(this.output, nCompressed);
        PNGEncoder.writeBytes(this.output, this.IDAT);
        PNGEncoder.writeBytes(this.output, compressedLines);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }

    private void writeEnd() throws IOException {
        PNGEncoder.writeInt4(this.output, 0);
        PNGEncoder.writeBytes(this.output, this.IEND);
        this.crc.reset();
        this.crc.update(this.IEND);
        PNGEncoder.writeInt4(this.output, (int)this.crc.getValue());
    }
}

