/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.swf;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;

public final class BitBuffer {
    private int buffer = 0;
    private int bitoff = 0;
    private final ByteArrayOutputStreamFast data = new ByteArrayOutputStreamFast(1000);

    public byte[] getData() {
        return this.data.toByteArray();
    }

    public void putbits(int nbits, int val) {
        while (nbits > 0) {
            if (this.bitoff == 0) {
                this.buffer = 0;
            }
            int shift = 8 - this.bitoff - nbits;
            int mask = (1 << nbits) - 1;
            this.buffer = shift >= 0 ? (this.buffer |= (val & mask) << shift) : (this.buffer |= (val & mask) >>> -shift);
            if (this.bitoff + nbits < 8) {
                this.bitoff += nbits;
                nbits = 0;
                continue;
            }
            nbits -= 8 - this.bitoff;
            this.bitoff = 0;
            this.data.write(this.buffer);
        }
    }

    public void flushbits() {
        if (this.bitoff != 0) {
            this.data.write(this.buffer);
        }
        this.bitoff = 0;
    }

    public int nsbits(int ... args) {
        int maxv = 0;
        for (int v : args) {
            if (v < 0) {
                v = -v;
            }
            if (v <= maxv) continue;
            maxv = v;
        }
        int n = 0;
        while (1 << n <= maxv) {
            ++n;
        }
        return n + 1;
    }

    public void putbyte(int val) {
        this.flushbits();
        this.data.write(val);
    }

    public void lineto(int dx, int dy) {
        int nbits = this.nsbits(dx, dy);
        this.putbits(1, 1);
        this.putbits(1, 1);
        this.putbits(4, nbits - 2);
        if (dx != 0 && dy != 0) {
            this.putbits(1, 1);
            this.putbits(nbits, dx);
            this.putbits(nbits, dy);
        } else {
            this.putbits(1, 0);
            if (dy != 0) {
                this.putbits(1, 1);
                this.putbits(nbits, dy);
            } else {
                this.putbits(1, 0);
                this.putbits(nbits, dx);
            }
        }
    }

    public void sizerect(int xl, int yl, int xr, int yr) {
        int nbits = this.nsbits(xl, yl, xr, yr);
        this.putbits(5, nbits);
        this.putbits(nbits, xl);
        this.putbits(nbits, xr);
        this.putbits(nbits, yl);
        this.putbits(nbits, yr);
    }

    public void addchar(int val) {
        this.flushbits();
        this.putbyte(val);
        this.putbyte(val >> 8);
    }
}

