/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.swf;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoder;
import com.neptunelabs.imagemanipulator.encoder.ImageEncoderUtils;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGEncoder;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.imagemanipulator.encoder.swf.BitBuffer;
import com.neptunelabs.imagemanipulator.encoder.swf.ByteArrayInputStreamBE;
import com.neptunelabs.imagemanipulator.encoder.swf.ByteArrayOutputStreamME;
import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.ASNode;
import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.ASParser;
import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.ParseException;
import com.neptunelabs.imagereader.converter.FSIImageConverter;
import com.neptunelabs.imagereader.image.FSIImage;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public final class SWFEncoder
extends ImageEncoderUtils
implements ImageEncoder {
    private int version = 6;
    private final JPEGPreparation jpegPrep;
    private final byte[] backgroundColor = new byte[]{-1, -1, -1};
    private boolean protect = true;
    private final int fps = 36;
    private final int frames = 1;
    private int compressionLevel = 9;
    private boolean encodeAlpha = false;
    private int width;
    private int height;
    private BufferedImage bufferedImage = null;

    public SWFEncoder(FSILogger logger, JPEGPreparation jpegPrep) {
        super(logger);
        this.jpegPrep = jpegPrep;
    }

    @Override
    public void encode() throws IOException {
        if (this.compressionLevel > 0 && this.version <= 5) {
            this.version = 6;
        }
        ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(this.bufferedImage.getWidth() * this.bufferedImage.getHeight() * 4);
        MemoryCacheImageOutputStream mos = new MemoryCacheImageOutputStream(baos);
        JPEGEncoder jpeg = new JPEGEncoder(this.logger, this.jpegPrep);
        jpeg.setImageOutputStream(mos);
        jpeg.setBufferedImage(this.bufferedImage);
        jpeg.encode();
        mos.close();
        baos.close();
        byte[] rawJPEG = baos.toByteArray();
        byte[] imageExtract = this.extractRawJPEG(rawJPEG);
        byte[] header = this.buildHeader();
        byte[] body = this.buildUncompressedSWF(imageExtract);
        int bodylen = body.length;
        if (this.compressionLevel > 0) {
            Deflater scrunch = new Deflater(this.compressionLevel);
            ByteArrayOutputStreamFast outBytes = new ByteArrayOutputStreamFast(body.length);
            DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)outBytes, scrunch, 8192);
            compBytes.write(body);
            compBytes.close();
            outBytes.close();
            scrunch.finish();
            body = outBytes.toByteArray();
        }
        int swflength = header.length + bodylen + 4;
        this.output.write(header);
        this.output.write(swflength);
        this.output.write(swflength >> 8);
        this.output.write(swflength >> 16);
        this.output.write(swflength >> 24);
        this.output.write(body);
        this.output.close();
    }

    @Override
    public void setImage(FSIImage image) {
        this.image = image;
        this.bufferedImage = FSIImageConverter.convertToBufferedImage(image, false, 0);
        this.width = image.getWidth();
        this.height = image.getHeight();
    }

    public void setCompressionLevel(int level) {
        if (level >= 0 && level <= 9) {
            this.compressionLevel = level;
        }
    }

    public void setBackgroundColor(int rgb) {
        this.backgroundColor[0] = (byte)(rgb >> 16 & 0xFF);
        this.backgroundColor[1] = (byte)(rgb >> 8 & 0xFF);
        this.backgroundColor[2] = (byte)(rgb & 0xFF);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setEncodeAlpha(boolean encodeAlpha) {
        this.encodeAlpha = encodeAlpha;
    }

    @Override
    public String getName() {
        return "SWFEncoder";
    }

    private byte[] buildHeader() throws IOException {
        if (this.compressionLevel > 0) {
            return new byte[]{67, 87, 83, (byte)this.version};
        }
        return new byte[]{70, 87, 83, (byte)this.version};
    }

    private byte[] buildUncompressedSWF(byte[] swfImage) throws IOException {
        ByteArrayOutputStreamME baos = new ByteArrayOutputStreamME();
        BitBuffer bb = new BitBuffer();
        bb.sizerect(0, 0, this.width * 20, this.height * 20);
        bb.flushbits();
        baos.write(bb.getData());
        baos.writeShortLE(9216);
        baos.writeShortLE(1);
        SWFEncoder.addTag(baos, 9, this.backgroundColor);
        if (this.protect) {
            SWFEncoder.addTag(baos, 24, null);
        }
        ASParser parser = new ASParser();
        try {
            ASNode root = parser.parse("var t = _parent._url;System.security.allowDomain(t);System.security.allowInsecureDomain(t);");
            byte[] ascode = root.encode(6);
            SWFEncoder.addTag(baos, 12, ascode);
        }
        catch (ParseException e) {
            baos.close();
            throw new IOException(e.getLocalizedMessage());
        }
        if (this.encodeAlpha && this.image.hasAlpha()) {
            SWFEncoder.addTag(baos, 35, swfImage);
        } else {
            SWFEncoder.addTag(baos, 21, swfImage);
        }
        SWFEncoder.addTag(baos, 32, SWFEncoder.bitmapShape(2, 1, this.width * 20, this.height * 20));
        SWFEncoder.addTag(baos, 26, SWFEncoder.placeObj2(2, 1, 0, 0));
        SWFEncoder.addTag(baos, 1, null);
        SWFEncoder.addTag(baos, 0, null);
        baos.close();
        return baos.toByteArray();
    }

    private static void addTag(ByteArrayOutputStreamME baos, int tag, byte[] data) throws IOException {
        tag <<= 6;
        int l = data != null ? data.length : 0;
        if (l >= 63) {
            baos.writeShortLE(tag + 63);
            baos.writeIntLE(l);
        } else {
            baos.writeShortLE(tag + l);
        }
        if (data != null) {
            baos.write(data);
        }
    }

    private static byte[] bitmapShape(int id, int bitmapid, int w, int h) {
        BitBuffer data = new BitBuffer();
        data.addchar(id);
        data.sizerect(0, 0, w, h);
        data.putbyte(1);
        data.putbyte(65);
        data.addchar(bitmapid);
        int scale = 0x140000;
        int nbits = data.nsbits(0x140000);
        data.putbits(1, 1);
        data.putbits(5, nbits);
        data.putbits(nbits, 0x140000);
        data.putbits(nbits, 0x140000);
        data.putbits(1, 0);
        data.putbits(5, 2);
        data.putbits(2, -1);
        data.putbits(2, -1);
        data.flushbits();
        data.putbyte(0);
        data.putbits(4, 1);
        data.putbits(4, 0);
        data.putbits(1, 0);
        data.putbits(1, 0);
        data.putbits(1, 0);
        data.putbits(1, 1);
        data.putbits(1, 0);
        data.putbits(1, 1);
        data.putbits(5, 1);
        data.putbits(1, 0);
        data.putbits(1, 0);
        data.putbits(1, 1);
        data.lineto(w, 0);
        data.lineto(0, h);
        data.lineto(-w, 0);
        data.lineto(0, -h);
        data.putbits(6, 0);
        data.flushbits();
        return data.getData();
    }

    private static byte[] placeObj2(int id, int depth, int x, int y) {
        BitBuffer data = new BitBuffer();
        data.putbits(1, 0);
        data.putbits(1, 0);
        data.putbits(1, 0);
        data.putbits(1, 0);
        data.putbits(1, 0);
        data.putbits(1, 1);
        data.putbits(1, 1);
        data.putbits(1, 0);
        data.addchar(depth);
        data.addchar(id);
        data.putbits(1, 0);
        data.putbits(1, 0);
        int nbits = data.nsbits(x, y);
        data.putbits(5, nbits);
        data.putbits(nbits, x);
        data.putbits(nbits, y);
        data.flushbits();
        return data.getData();
    }

    private byte[] extractRawJPEG(byte[] jpeg) throws IOException {
        ByteArrayOutputStreamME baosOut = new ByteArrayOutputStreamME();
        ByteArrayOutputStreamME baosJpeg = new ByteArrayOutputStreamME();
        ByteArrayInputStreamBE bais = new ByteArrayInputStreamBE(jpeg);
        if (bais.read() == 255 && bais.read() == 216) {
            baosOut.writeShortLE(1);
            baosJpeg.write(255);
            baosJpeg.write(216);
            block5: while (bais.read() == 255) {
                int codec = bais.read();
                switch (codec) {
                    case 218: {
                        int b;
                        int length = bais.readShort();
                        baosJpeg.write(255);
                        baosJpeg.write(codec);
                        baosJpeg.writeShortBE(length);
                        while ((b = bais.read()) != -1) {
                            baosJpeg.write(b);
                        }
                        continue block5;
                    }
                    case 196: 
                    case 219: 
                    case 221: {
                        int length = bais.readShort();
                        baosJpeg.write(255);
                        baosJpeg.write(codec);
                        baosJpeg.writeShortBE(length);
                        for (int l = 0; l < length - 2; ++l) {
                            baosJpeg.write(bais.read());
                        }
                        continue block5;
                    }
                    case 192: 
                    case 193: {
                        int l;
                        int length = bais.readShort();
                        int prec = bais.read();
                        int heightVal = bais.readShort();
                        int widthVal = bais.readShort();
                        baosJpeg.write(255);
                        baosJpeg.write(codec);
                        baosJpeg.writeShortBE(length);
                        baosJpeg.write(prec);
                        baosJpeg.writeShortBE(heightVal);
                        baosJpeg.writeShortBE(widthVal);
                        for (l = 0; l < length - 7; ++l) {
                            baosJpeg.write(bais.read());
                        }
                        continue block5;
                    }
                    default: {
                        int l;
                        int length = bais.readShort();
                        for (l = 0; l < length - 2; ++l) {
                            bais.read();
                        }
                        continue block5;
                    }
                }
            }
        }
        bais.close();
        baosJpeg.close();
        byte[] jpegExtract = baosJpeg.toByteArray();
        byte[] alphaExtract = null;
        if (this.encodeAlpha && this.image.hasAlpha()) {
            Deflater scrunch = new Deflater(8);
            ByteArrayOutputStreamFast alphaBytes = new ByteArrayOutputStreamFast((int)this.image.getByteSize());
            DeflaterOutputStream compBytes = new DeflaterOutputStream((OutputStream)alphaBytes, scrunch);
            BufferedOutputStream bos = new BufferedOutputStream(compBytes);
            long alphaLen = this.image.getIntSize();
            this.image.setPosition(0L);
            int i = 0;
            while ((long)i < alphaLen) {
                bos.write(this.image.getSample() >> 24);
                ++i;
            }
            bos.close();
            compBytes.close();
            scrunch.finish();
            alphaBytes.close();
            alphaExtract = alphaBytes.toByteArray();
            baosOut.writeIntLE(jpegExtract.length);
        }
        baosOut.write(jpegExtract);
        if (alphaExtract != null) {
            baosOut.write(alphaExtract);
        }
        baosOut.close();
        return baosOut.toByteArray();
    }

    @Override
    public void dispose() {
        if (this.writer != null) {
            this.writer.dispose();
        }
    }
}

