/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.swf.asencoder;

import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.ParseException;
import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.Token;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public final class ASNode {
    public static final int Array = 1;
    public static final int Button = 2;
    public static final int MovieClip = 3;
    public static final int StatementList = 4;
    public static final int List = 5;
    public static final int NoOp = 6;
    public static final int If = 7;
    public static final int For = 8;
    public static final int ForIn = 9;
    public static final int While = 10;
    public static final int Do = 11;
    public static final int With = 12;
    public static final int OnClipEvent = 13;
    public static final int On = 14;
    public static final int Break = 15;
    public static final int Return = 16;
    public static final int Continue = 17;
    public static final int Value = 18;
    public static final int BooleanLiteral = 20;
    public static final int IntegerLiteral = 21;
    public static final int DoubleLiteral = 22;
    public static final int StringLiteral = 23;
    public static final int NullLiteral = 24;
    public static final int Identifier = 30;
    public static final int Attribute = 31;
    public static final int Method = 32;
    public static final int Function = 33;
    public static final int NewObject = 34;
    public static final int Subscript = 35;
    public static final int DefineFunction = 36;
    public static final int DefineArray = 37;
    public static final int DefineObject = 38;
    public static final int DefineMethod = 39;
    public static final int DefineAttribute = 40;
    public static final int DefineVariable = 41;
    public static final int Add = 42;
    public static final int Sub = 43;
    public static final int Mul = 44;
    public static final int Div = 45;
    public static final int Mod = 46;
    public static final int LSL = 47;
    public static final int ASR = 48;
    public static final int LSR = 49;
    public static final int BitAnd = 50;
    public static final int BitOr = 51;
    public static final int BitXOr = 52;
    public static final int LogicalAnd = 53;
    public static final int LogicalOr = 54;
    public static final int Equal = 55;
    public static final int NotEqual = 56;
    public static final int GreaterThan = 57;
    public static final int LessThan = 58;
    public static final int GreaterThanEqual = 59;
    public static final int LessThanEqual = 60;
    public static final int Select = 61;
    public static final int Not = 62;
    public static final int BitNot = 63;
    public static final int Plus = 64;
    public static final int Minus = 65;
    public static final int PreInc = 66;
    public static final int PreDec = 67;
    public static final int PostInc = 68;
    public static final int PostDec = 69;
    public static final int Assign = 70;
    public static final int AssignAdd = 71;
    public static final int AssignSub = 72;
    public static final int AssignMul = 73;
    public static final int AssignDiv = 74;
    public static final int AssignMod = 75;
    public static final int AssignLSL = 76;
    public static final int AssignASR = 77;
    public static final int AssignLSR = 78;
    public static final int AssignBitAnd = 79;
    public static final int AssignBitOr = 80;
    public static final int AssignBitXOr = 81;
    public static final int InstanceOf = 82;
    public static final int Delete = 83;
    public static final int StrictEqual = 84;
    public static final int StrictNotEqual = 85;
    public static final int StringAdd = 86;
    public static final int StringEqual = 87;
    public static final int StringNotEqual = 88;
    public static final int StringLessThanEqual = 89;
    public static final int StringGreaterThan = 90;
    public static final int StringGreaterThanEqual = 91;
    public static final int Exception = 92;
    public static final int Try = 93;
    public static final int Catch = 94;
    public static final int Finally = 95;
    public static final int Switch = 96;
    public static final int Throw = 97;
    public static final int Label = 98;
    public static final int InitClip = 99;
    public static final int EndInitClip = 100;
    public static final int And = 101;
    public static final int Or = 102;
    private static String[] nodeNames = new String[]{"", "Frame", "Button", "MovieClip", "Statements", "List", "NoOp", "if", "for", "for..in", "while", "do..while", "With", "OnClipEvent", "On", "Break", "Return", "Continue", "Value", "", "Boolean", "Integer", "Double", "String", "Null", "", "", "", "", "", "Identifier", "Attribute", "Method", "Function", "NewObject", "Subscript", "Define Function", "Define Array", "Define Object", "Define Method", "Define Attribute", "Define Variable", "+", "-", "*", "/", "%", "<<", ">>", ">>>", "&", "|", "^", "&&", "||", "==", "!=", ">", "<", ">=", "<=", "?", "!", "~", "+x", "-x", "++x", "--x", "x++", "x--", "=", "+=", "-=", "*=", "/=", "%=", "<<=", ">>=", ">>>=", "&=", "|=", "^=", "intanceof", "delete", "===", "!==", "add", "eq", "ne", "le", "gt", "ge", "exception", "try", "catch", "finally", "switch", "throw", "label", "#initclip", "#endinitclip", "and", "or"};
    static HashMap buttonEvents = new HashMap();
    static HashMap clipEvents = new HashMap();
    private static HashMap constants = new HashMap();
    private static HashMap propertyNames = new HashMap();
    private static HashMap earlyPropertyNames = new HashMap();
    private static HashMap functions = new HashMap();
    private static HashMap valueFunctions = new HashMap();
    private static HashMap classes = new HashMap();
    private int type = 0;
    private int iValue = 0;
    private double dValue = Double.NaN;
    private String sValue = null;
    private boolean bValue = false;
    private boolean discardValue = false;
    private int insertIndex = 0;
    private ASNode parent = null;
    private ASNode[] children = null;
    private int number = 0;

    public ASNode(int nodeType) {
        this.type = nodeType;
    }

    public ASNode(int nodeType, int value) {
        this.type = nodeType;
        this.iValue = value;
    }

    public ASNode(int nodeType, double value) {
        this.type = nodeType;
        this.dValue = value;
    }

    public ASNode(int nodeType, String value) {
        this.type = nodeType;
        this.sValue = value;
    }

    public ASNode(int nodeType, ASNode node) {
        this.type = nodeType;
        this.add(node);
    }

    public ASNode(int nodeType, ASNode node1, ASNode node2) {
        this.type = nodeType;
        this.add(node1);
        this.add(node2);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean getBoolValue() {
        return this.bValue;
    }

    public void setBoolValue(boolean value) {
        this.bValue = value;
        this.iValue = 0;
        this.dValue = Double.NaN;
        this.sValue = null;
    }

    public int getIntValue() {
        return this.iValue;
    }

    public void setIntValue(int value) {
        this.bValue = false;
        this.iValue = value;
        this.dValue = Double.NaN;
        this.sValue = null;
    }

    public double getDoubleValue() {
        return this.dValue;
    }

    public void setDoubleValue(double value) {
        this.bValue = false;
        this.iValue = 0;
        this.dValue = value;
        this.sValue = null;
    }

    public String getStringValue() {
        return this.sValue;
    }

    public void setNumber(int value) {
        this.number = value;
    }

    public int getNumber() {
        return this.number;
    }

    public void setStringValue(String value) {
        this.bValue = false;
        this.iValue = 0;
        this.dValue = Double.NaN;
        this.sValue = value;
    }

    public ASNode get(int index) {
        if (this.children == null || index < 0 || index >= this.children.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.children[index];
    }

    public void set(int i, ASNode aNode) {
        if (aNode != null && this.children != null) {
            if (i < 0 || i >= this.children.length) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
            aNode.parent = this;
            this.children[i] = aNode;
        }
    }

    public void add(ASNode aNode) {
        if (aNode != null) {
            aNode.parent = this;
            if (this.children == null) {
                this.children = new ASNode[1];
            } else {
                ASNode[] c = new ASNode[this.children.length + 1];
                System.arraycopy(this.children, 0, c, 0, this.children.length);
                this.children = c;
            }
            this.children[this.children.length - 1] = aNode;
        }
    }

    public void insert(int index, ASNode aNode) {
        int i;
        if (this.children == null || index < 0 || index >= this.children.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        aNode.parent = this;
        ASNode[] c = new ASNode[this.children.length + 1];
        for (i = 0; i < index; ++i) {
            c[i] = this.children[i];
        }
        c[index] = aNode;
        for (i = index; i < this.children.length; ++i) {
            c[i + 1] = this.children[i];
        }
        this.children = c;
    }

    public void remove(int index) {
        if (this.children == null || index < 0 || index >= this.children.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.children[index].parent = null;
        this.children[index] = null;
        ASNode[] c = new ASNode[this.children.length - 1];
        int j = 0;
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            c[j++] = this.children[i];
        }
        this.children = c;
    }

    public int indexOf(ASNode aNode) {
        int index = -1;
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].equals(aNode)) continue;
            index = i;
        }
        return index;
    }

    public ASNode getParent() {
        return this.parent;
    }

    public int count() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        String str = nodeNames[this.type];
        if (this.type == 20) {
            str = str + " = " + (this.bValue ? "true" : "false") + "; ";
        } else if (this.type == 21) {
            str = str + " = " + this.iValue + "; ";
        } else if (this.type == 22) {
            str = str + " = " + this.dValue + "; ";
        } else if (this.type == 23) {
            str = str + " = \"" + this.sValue + "\"; ";
        } else if (this.type == 24) {
            str = str + " = null; ";
        } else if (this.sValue != null) {
            str = str + " = " + this.sValue + "; ";
        }
        return str;
    }

    public void displayTree(String prefix) {
        int count = this.count();
        System.out.println(prefix + this.toString());
        for (int i = 0; i < count; ++i) {
            this.children[i].displayTree(prefix + "  ");
        }
    }

    private ArrayList translate(int version, String encoding) {
        ASInfo info = new ASInfo(version, encoding);
        ArrayList array = new ArrayList();
        this.reorder(info);
        this.findStrings(info);
        this.generate(info, array);
        return array;
    }

    public byte[] encode(int version) {
        int length = 0;
        if (version < 5) {
            throw new IllegalArgumentException();
        }
        ArrayList array = this.translate(version, "UTF-8");
        Iterator i = array.iterator();
        while (i.hasNext()) {
            length += ((Coding)i.next()).length(version, "UTF-8");
        }
        Coder coder = new Coder(new byte[length], "UTF-8");
        coder.version = version;
        Iterator i2 = array.iterator();
        while (i2.hasNext()) {
            ((Coding)i2.next()).encode(coder);
        }
        return coder.data;
    }

    private void reorder(ASInfo info) {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: {
                info.nodes.push(this);
                break;
            }
            case 30: {
                if (!constants.containsKey(this.sValue)) break;
                this.type = 30;
                Object value = constants.get(this.sValue);
                if (value == null || !(value instanceof String)) break;
                this.type = 23;
                this.sValue = value.toString();
                break;
            }
            case 18: {
                String name;
                if (this.children[0].type != 30 || this.children[1].type != 31 || !constants.containsKey(name = this.children[0].sValue + "." + this.children[1].sValue)) break;
                this.type = 30;
                this.sValue = name;
                this.remove(0);
                this.remove(0);
                break;
            }
            case 70: {
                if (this.parent == null || this.parent.type != 5 || this.parent.count() <= 0 || this.parent.children[0].count() <= 0 || this.parent.children[0].children[0].type != 41 || this.parent.indexOf(this) == 0) break;
                this.children[0].type = 41;
                break;
            }
            case 36: {
                ASNode node = (ASNode)info.nodes.peek();
                node.insert(node.insertIndex++, this);
                int index = this.parent.indexOf(this);
                if (index != -1) {
                    this.parent.remove(index);
                }
                info.nodes.push(this);
                break;
            }
            case 33: {
                ASNode c1;
                ASNode c0;
                if (this.sValue.equals("fscommand")) {
                    if (this.children[0].type != 23) break;
                    this.children[0].sValue = "FSCommand:" + this.children[0].sValue;
                    break;
                }
                if (this.sValue.equals("print")) {
                    c0 = this.children[0];
                    c1 = this.children[1];
                    this.children[1].sValue = this.children[1].sValue.equals("bmovie") ? "print:" : "print:#" + this.children[1].sValue;
                    this.children[0] = c1;
                    this.children[1] = c0;
                    break;
                }
                if (this.sValue.equals("printNum")) {
                    if (this.children[0].type == 21) {
                        this.children[0].type = 23;
                        this.children[0].setStringValue("_level" + this.children[0].iValue);
                    }
                    if (this.children[1].sValue.equals("bmovie")) {
                        this.children[1].sValue = "print:";
                        break;
                    }
                    this.children[1].sValue = "print:#" + this.children[1].sValue;
                    break;
                }
                if (this.sValue.equals("printAsBitmap")) {
                    c0 = this.children[0];
                    c1 = this.children[1];
                    this.children[1].sValue = this.children[1].sValue.equals("bmovie") ? "printasbitmap:" : "printasbitmap:#" + this.children[1].sValue;
                    this.children[0] = c1;
                    this.children[1] = c0;
                    break;
                }
                if (!this.sValue.equals("printAsBitmapNum")) break;
                if (this.children[0].type == 21) {
                    this.children[0].type = 23;
                    this.children[0].setStringValue("_level" + this.children[0].iValue);
                }
                this.children[1].sValue = this.children[1].sValue.equals("bmovie") ? "printasbitmap:" : "printasbitmap:#" + this.children[1].sValue;
            }
        }
        int count = this.count();
        for (int i = 0; i < count; ++i) {
            this.children[i].reorder(info);
        }
        switch (this.type) {
            case 1: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (this.count() != 2) break;
                if (this.children[0].getType() == 21 && this.children[1].getType() == 21) {
                    switch (this.type) {
                        case 42: {
                            this.type = 21;
                            this.iValue = this.children[0].iValue + this.children[1].iValue;
                            break;
                        }
                        case 43: {
                            this.type = 21;
                            this.iValue = this.children[0].iValue - this.children[1].iValue;
                            break;
                        }
                        case 44: {
                            this.type = 21;
                            this.iValue = this.children[0].iValue * this.children[1].iValue;
                            break;
                        }
                        case 45: {
                            if (this.children[0].iValue / this.children[1].iValue == 0) {
                                this.type = 22;
                                this.dValue = (double)this.children[0].iValue / (double)this.children[1].iValue;
                                break;
                            }
                            if (this.children[0].iValue % this.children[1].iValue != 0) {
                                this.type = 22;
                                this.dValue = (double)this.children[0].iValue / (double)this.children[1].iValue;
                                break;
                            }
                            this.type = 21;
                            this.iValue = this.children[0].iValue / this.children[1].iValue;
                            break;
                        }
                        case 46: {
                            this.type = 21;
                            this.iValue = this.children[0].iValue % this.children[1].iValue;
                        }
                    }
                    this.remove(0);
                    this.remove(0);
                    break;
                }
                if (this.children[0].getType() == 22 && this.children[1].getType() == 21) {
                    switch (this.type) {
                        case 42: {
                            this.dValue = this.children[0].dValue + (double)this.children[1].iValue;
                            break;
                        }
                        case 43: {
                            this.dValue = this.children[0].dValue - (double)this.children[1].iValue;
                            break;
                        }
                        case 44: {
                            this.dValue = this.children[0].dValue * (double)this.children[1].iValue;
                            break;
                        }
                        case 45: {
                            this.dValue = this.children[0].dValue / (double)this.children[1].iValue;
                            break;
                        }
                        case 46: {
                            this.dValue = this.children[0].dValue % (double)this.children[1].iValue;
                        }
                    }
                    this.type = 22;
                    this.remove(0);
                    this.remove(0);
                    break;
                }
                if (this.children[0].getType() == 21 && this.children[1].getType() == 22) {
                    switch (this.type) {
                        case 42: {
                            this.dValue = (double)this.children[0].iValue + this.children[1].dValue;
                            break;
                        }
                        case 43: {
                            this.dValue = (double)this.children[0].iValue - this.children[1].dValue;
                            break;
                        }
                        case 44: {
                            this.dValue = (double)this.children[0].iValue * this.children[1].dValue;
                            break;
                        }
                        case 45: {
                            this.dValue = (double)this.children[0].iValue / this.children[1].dValue;
                            break;
                        }
                        case 46: {
                            this.dValue = (double)this.children[0].iValue % this.children[1].dValue;
                        }
                    }
                    this.type = 22;
                    this.remove(0);
                    this.remove(0);
                    break;
                }
                if (this.children[0].getType() != 22 || this.children[1].getType() != 22) break;
                switch (this.type) {
                    case 42: {
                        this.dValue = this.children[0].dValue + this.children[1].dValue;
                        break;
                    }
                    case 43: {
                        this.dValue = this.children[0].dValue - this.children[1].dValue;
                        break;
                    }
                    case 44: {
                        this.dValue = this.children[0].dValue * this.children[1].dValue;
                        break;
                    }
                    case 45: {
                        this.dValue = this.children[0].dValue / this.children[1].dValue;
                        break;
                    }
                    case 46: {
                        this.dValue = this.children[0].dValue % this.children[1].dValue;
                    }
                }
                this.type = 22;
                this.remove(0);
                this.remove(0);
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                if (this.count() != 2 || this.children[0].getType() != 21 || this.children[1].getType() != 21) break;
                switch (this.type) {
                    case 48: {
                        this.iValue = this.children[0].iValue >> this.children[1].iValue;
                        break;
                    }
                    case 47: {
                        this.iValue = this.children[0].iValue << this.children[1].iValue;
                        break;
                    }
                    case 49: {
                        this.iValue = this.children[0].iValue >>> this.children[1].iValue;
                        break;
                    }
                    case 50: {
                        this.iValue = this.children[0].iValue & this.children[1].iValue;
                        break;
                    }
                    case 51: {
                        this.iValue = this.children[0].iValue | this.children[1].iValue;
                        break;
                    }
                    case 52: {
                        this.iValue = this.children[0].iValue ^ this.children[1].iValue;
                    }
                }
                this.type = 21;
                this.remove(0);
                this.remove(0);
                break;
            }
            case 53: 
            case 54: 
            case 101: 
            case 102: {
                if (this.count() != 2) break;
                if (this.children[0].getType() == 20 && this.children[1].getType() == 20) {
                    switch (this.type) {
                        case 53: 
                        case 101: {
                            this.type = 20;
                            this.bValue = this.children[0].bValue && this.children[1].bValue;
                            break;
                        }
                        case 54: 
                        case 102: {
                            this.type = 20;
                            this.bValue = this.children[0].bValue || this.children[1].bValue;
                        }
                    }
                    this.remove(0);
                    this.remove(0);
                    break;
                }
                if (this.children[0].getType() == 20 && this.children[1].getType() == 21) {
                    switch (this.type) {
                        case 53: 
                        case 101: {
                            this.type = 20;
                            this.bValue = this.children[0].bValue && this.children[1].iValue != 0;
                            break;
                        }
                        case 54: 
                        case 102: {
                            this.type = 21;
                            this.iValue = this.children[1].iValue;
                        }
                    }
                    this.remove(0);
                    this.remove(0);
                    break;
                }
                if (this.children[0].getType() == 21 && this.children[1].getType() == 20) {
                    switch (this.type) {
                        case 53: 
                        case 101: {
                            this.type = 20;
                            this.bValue = this.children[0].iValue != 0 && this.children[1].bValue;
                            break;
                        }
                        case 54: 
                        case 102: {
                            this.type = 21;
                            this.iValue = this.children[0].iValue != 0 || this.children[1].bValue ? 1 : 0;
                        }
                    }
                    this.remove(0);
                    this.remove(0);
                    break;
                }
                if (this.children[0].getType() != 21 || this.children[1].getType() != 21) break;
                boolean a = this.children[0].iValue != 0;
                boolean b = this.children[1].iValue != 0;
                switch (this.type) {
                    case 53: 
                    case 101: {
                        this.type = 21;
                        this.iValue = a ? this.children[1].iValue : 0;
                        break;
                    }
                    case 54: 
                    case 102: {
                        this.type = 21;
                        this.iValue = a || b ? 1 : 0;
                    }
                }
                this.remove(0);
                this.remove(0);
                break;
            }
            case 62: {
                if (this.count() != 1) break;
                if (this.children[0].getType() == 20) {
                    this.type = 20;
                    this.bValue = !this.children[0].bValue;
                    this.remove(0);
                    break;
                }
                if (this.children[0].getType() != 21) break;
                this.type = 20;
                this.bValue = this.children[0].iValue == 0;
                this.remove(0);
                break;
            }
            case 63: {
                if (this.count() != 1 || this.children[0].getType() != 21) break;
                this.type = 21;
                this.iValue = ~this.children[0].iValue;
                this.remove(0);
                break;
            }
        }
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 36: {
                info.nodes.pop();
                break;
            }
        }
    }

    private void findStrings(ASInfo info) {
        int count = this.count();
        if (this.type == 33) {
            info.context.push(this.sValue);
        } else {
            info.context.push(nodeNames[this.type]);
        }
        switch (this.type) {
            case 13: 
            case 14: {
                info.clearStrings();
                for (int i = 0; i < count; ++i) {
                    this.children[i].findStrings(info);
                }
                break;
            }
            case 23: {
                this.sValue = this.sValue.replaceAll("\\\\n", "\n");
                this.sValue = this.sValue.replaceAll("\\\\t", "\t");
                this.sValue = this.sValue.replaceAll("\\\\b", "\b");
                this.sValue = this.sValue.replaceAll("\\\\r", "\r");
                this.sValue = this.sValue.replaceAll("\\\\f", "\f");
                info.addString(this.sValue);
                break;
            }
            case 30: {
                if (constants.containsKey(this.sValue)) break;
                if (propertyNames.containsKey(this.sValue)) {
                    if (info.context.contains("getProperty") || info.context.contains("setProperty")) break;
                    if (info.context.contains("With")) {
                        info.addString(this.sValue);
                        break;
                    }
                    if (info.context.contains("Define Object")) {
                        info.addString(this.sValue);
                        break;
                    }
                    info.addString("");
                    break;
                }
                info.addString(this.sValue);
                break;
            }
            case 41: {
                info.addString(this.sValue);
                break;
            }
            case 31: 
            case 32: 
            case 34: {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].findStrings(info);
                }
                if (this.sValue.length() <= 0) break;
                info.addString(this.sValue);
                break;
            }
            case 33: {
                if (this.sValue != null && !functions.containsKey(this.sValue)) {
                    for (int i = 0; i < count; ++i) {
                        this.children[i].findStrings(info);
                    }
                    if (this.sValue.length() <= 0) break;
                    info.addString(this.sValue);
                    break;
                }
                if (this.sValue != null && this.sValue.equals("fscommand")) {
                    info.addString("FSCommand:");
                    for (int i = 0; i < count; ++i) {
                        this.children[i].findStrings(info);
                    }
                } else {
                    if (this.sValue != null && this.sValue.equals("getURL")) {
                        if (count > 0) {
                            this.children[0].findStrings(info);
                        }
                        if (count > 1) {
                            this.children[1].findStrings(info);
                        }
                        if (count != 1 || this.children[0].type == 23) break;
                        info.addString("");
                        break;
                    }
                    if (this.sValue != null && this.sValue.equals("gotoAndPlay")) {
                        if (count == 1) {
                            this.children[0].findStrings(info);
                            break;
                        }
                        if (count != 2) break;
                        this.children[1].findStrings(info);
                        break;
                    }
                    if (this.sValue != null && this.sValue.equals("gotoAndStop")) {
                        if (count == 1) {
                            this.children[0].findStrings(info);
                            break;
                        }
                        if (count != 2) break;
                        this.children[1].findStrings(info);
                        break;
                    }
                    if (this.sValue != null && this.sValue.equals("loadMovie")) {
                        if (count > 0) {
                            this.children[0].findStrings(info);
                        }
                        if (count > 1) {
                            this.children[1].findStrings(info);
                        }
                        if (count != 1) break;
                        info.addString("");
                        break;
                    }
                    if (this.sValue != null && this.sValue.equals("loadVariables")) {
                        if (count > 0) {
                            this.children[0].findStrings(info);
                        }
                        if (count > 1) {
                            this.children[1].findStrings(info);
                        }
                        if (count != 1) break;
                        info.addString("");
                        break;
                    }
                    if (this.sValue != null && this.sValue.equals("printNum")) {
                        this.children[1].findStrings(info);
                        if (this.children[0].type == 30) {
                            info.addString("_level");
                        }
                        this.children[0].findStrings(info);
                        break;
                    }
                    if (this.sValue != null && this.sValue.equals("printAsBitmapNum")) {
                        this.children[1].findStrings(info);
                        if (this.children[0].type == 30) {
                            info.addString("_level");
                        }
                        this.children[0].findStrings(info);
                        break;
                    }
                    for (int i = 0; i < count; ++i) {
                        this.children[i].findStrings(info);
                    }
                }
                break;
            }
            case 39: {
                this.children[count - 1].findStrings(info);
                break;
            }
            case 36: {
                if (this.sValue != null && this.sValue.equals("ifFrameLoaded")) {
                    if (this.children[0].count() == 0) {
                        this.children[0].findStrings(info);
                    } else if (this.children[0].count() == 2) {
                        this.children[0].children[1].findStrings(info);
                    }
                }
                this.children[count - 1].findStrings(info);
                break;
            }
            case 37: {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].findStrings(info);
                }
                break;
            }
            case 18: {
                if (count <= 0) break;
                if (this.children[0].sValue != null && classes.containsKey(this.children[0].sValue)) {
                    boolean containsClass = false;
                    Iterator i = info.strings.iterator();
                    while (i.hasNext()) {
                        if (!i.next().toString().equals(this.children[0].sValue)) continue;
                        containsClass = true;
                        break;
                    }
                    if (!containsClass) {
                        int index = info.strings.size();
                        for (int i2 = 0; i2 < count; ++i2) {
                            this.children[i2].findStrings(info);
                        }
                        info.strings.set(index, info.strings.get(index + 1));
                        info.strings.set(index + 1, this.children[0].sValue);
                        break;
                    }
                    for (int i3 = 0; i3 < count; ++i3) {
                        this.children[i3].findStrings(info);
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        this.children[i].findStrings(info);
                    }
                }
                break;
            }
            default: {
                for (int i = 0; i < count; ++i) {
                    this.children[i].findStrings(info);
                }
            }
        }
        info.context.pop();
    }

    private void generate(ASInfo info, ArrayList actions) {
        if (this.type == 33) {
            info.context.push(this.sValue);
        } else {
            info.context.push(nodeNames[this.type]);
        }
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: {
                this.generateScript(info, actions);
                break;
            }
            case 4: 
            case 5: {
                this.generateList(info, actions);
                break;
            }
            case 7: {
                this.generateIf(info, actions);
                break;
            }
            case 11: {
                this.generateDo(info, actions);
                break;
            }
            case 10: {
                this.generateWhile(info, actions);
                break;
            }
            case 8: {
                this.generateFor(info, actions);
                break;
            }
            case 9: {
                this.generateForIn(info, actions);
                break;
            }
            case 12: {
                this.generateWith(info, actions);
                break;
            }
            case 96: {
                this.generateSwitch(info, actions);
                break;
            }
            case 98: {
                this.generateLabel(info, actions);
                break;
            }
            case 92: {
                this.generateException(info, actions);
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                this.generateClauses(info, actions);
                break;
            }
            case 13: {
                this.generateOnClipEvent(info, actions);
                break;
            }
            case 14: {
                this.generateOn(info, actions);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                this.generateReturn(info, actions);
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                this.generateValue(info, actions);
                break;
            }
            case 33: {
                this.generateFunction(actions, info, this.sValue);
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.generateDefinition(info, actions);
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 83: 
            case 97: {
                this.generateUnary(info, actions);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 101: 
            case 102: {
                this.generateBinary(info, actions);
                break;
            }
            case 61: {
                this.generateSelect(info, actions);
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.generateAssignment(info, actions);
                break;
            }
        }
        info.context.pop();
    }

    private void generateScript(ASInfo info, ArrayList actions) {
        ArrayList<Table> array = new ArrayList<Table>();
        int count = this.count();
        switch (this.type) {
            case 1: {
                int i;
                if (this.type == 1 && info.useStrings) {
                    array.add(new Table(info.strings));
                }
                for (i = 0; i < count; ++i) {
                    this.children[i].discardValues();
                }
                for (i = 0; i < count; ++i) {
                    this.children[i].generate(info, array);
                }
                actions.add(new ASArray(1, array));
                break;
            }
            case 2: {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, array);
                }
                actions.add(new ASArray(2, array));
                break;
            }
            case 3: {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, array);
                }
                actions.add(new ASArray(3, array));
                break;
            }
        }
    }

    private void generateList(ASInfo info, ArrayList actions) {
        int count = this.count();
        for (int i = 0; i < count; ++i) {
            this.children[i].generate(info, actions);
        }
    }

    private void generateIf(ASInfo info, ArrayList actions) {
        int actionType;
        int count = this.count();
        boolean addJump = false;
        ArrayList trueActions = new ArrayList();
        int offsetToNext = 0;
        ArrayList falseActions = new ArrayList();
        int offsetToEnd = 0;
        if (count > 1) {
            this.children[1].discardValues();
            this.children[1].generate(info, trueActions);
            offsetToNext = this.actionLength(trueActions, info.version, info.encoding);
        }
        if (count == 3) {
            this.children[2].discardValues();
            this.children[2].generate(info, falseActions);
            offsetToEnd = this.actionLength(falseActions, info.version, info.encoding);
            boolean bl = addJump = offsetToEnd != 0;
        }
        if (trueActions.size() > 0 && ((actionType = ((Action)trueActions.get((int)(trueActions.size() - 1))).type) == 256 || actionType == 257)) {
            addJump = true;
            if (falseActions.size() == 0) {
                offsetToNext -= 5;
            }
        }
        if (addJump) {
            offsetToNext += 5;
        }
        this.children[0].generate(info, actions);
        this.addAction(actions, 18);
        actions.add(new ValueAction(157, offsetToNext));
        actions.addAll(trueActions);
        if (addJump && offsetToEnd > 0) {
            actions.add(new ValueAction(153, offsetToEnd));
        }
        actions.addAll(falseActions);
    }

    private void generateDo(ASInfo info, ArrayList actions) {
        int count = this.children != null ? this.children.length : 0;
        ArrayList<ValueAction> blockActions = new ArrayList<ValueAction>();
        int blockLength = 0;
        ArrayList<ValueAction> conditionActions = new ArrayList<ValueAction>();
        int conditionLength = 0;
        this.children[0].discardValues();
        this.children[0].generate(info, blockActions);
        this.children[1].generate(info, conditionActions);
        blockLength = this.actionLength(blockActions, info.version, info.encoding);
        conditionLength = this.actionLength(conditionActions, info.version, info.encoding);
        conditionActions.add(new ValueAction(157, -(blockLength + (conditionLength += 5))));
        int currentLength = 0;
        for (int i = 0; i < blockActions.size(); ++i) {
            Action currentAction = (Action)blockActions.get(i);
            currentLength += currentAction.length(info.version, info.encoding);
            if (currentAction.type == 256) {
                blockActions.set(i, new ValueAction(153, blockLength - currentLength + conditionLength));
            }
            if (currentAction.type != 257) continue;
            blockActions.set(i, new ValueAction(153, blockLength - currentLength));
        }
        actions.addAll(blockActions);
        actions.addAll(conditionActions);
    }

    private void generateWhile(ASInfo info, ArrayList actions) {
        int count = this.children != null ? this.children.length : 0;
        ArrayList<ValueAction> blockActions = new ArrayList<ValueAction>();
        int blockLength = 0;
        ArrayList<ValueAction> conditionActions = new ArrayList<ValueAction>();
        int conditionLength = 0;
        if (count == 2) {
            this.children[1].discardValues();
            this.children[1].generate(info, blockActions);
        }
        blockLength = this.actionLength(blockActions, info.version, info.encoding);
        this.children[0].generate(info, conditionActions);
        this.addAction(conditionActions, 18);
        conditionActions.add(new ValueAction(157, blockLength + 5));
        conditionLength = this.actionLength(conditionActions, info.version, info.encoding);
        blockActions.add(new ValueAction(153, -(conditionLength + blockLength + 5)));
        blockLength += 5;
        int currentLength = conditionLength;
        for (int i = 0; i < blockActions.size(); ++i) {
            Action currentAction = (Action)blockActions.get(i);
            currentLength += currentAction.length(info.version, info.encoding);
            if (currentAction.type == 256) {
                blockActions.set(i, new ValueAction(153, blockLength + conditionLength - currentLength));
            }
            if (currentAction.type != 257) continue;
            blockActions.set(i, new ValueAction(153, -currentLength));
        }
        actions.addAll(conditionActions);
        actions.addAll(blockActions);
    }

    private void generateFor(ASInfo info, ArrayList actions) {
        int count = this.children != null ? this.children.length : 0;
        ArrayList initializeActions = new ArrayList();
        ArrayList<Action> conditionActions = new ArrayList<Action>();
        ArrayList<ValueAction> iteratorActions = new ArrayList<ValueAction>();
        ArrayList<ValueAction> blockActions = new ArrayList<ValueAction>();
        int initializeLength = 0;
        int conditionLength = 0;
        int blockLength = 0;
        int iteratorLength = 0;
        if (this.children[0].type != 6) {
            this.children[0].generate(info, initializeActions);
            initializeLength = this.actionLength(initializeActions, info.version, info.encoding);
        }
        if (this.children[1].type != 6) {
            this.children[1].generate(info, conditionActions);
            conditionLength = this.actionLength(conditionActions, info.version, info.encoding);
        }
        if (this.children[2].type != 6) {
            this.children[2].discardValues();
            this.children[2].generate(info, iteratorActions);
            iteratorLength = this.actionLength(iteratorActions, info.version, info.encoding);
        }
        if (this.children[3].type != 6) {
            this.children[3].discardValues();
            this.children[3].generate(info, blockActions);
            blockLength = this.actionLength(blockActions, info.version, info.encoding);
        }
        if (conditionActions.size() > 0) {
            Action lastAction = (Action)conditionActions.get(conditionActions.size() - 1);
            if (lastAction.type == 150) {
                int lastIndex;
                ArrayList values = ((Push)lastAction).getValues();
                Object lastValue = values.get(lastIndex = values.size() - 1);
                if (lastValue instanceof Boolean) {
                    if (((Boolean)lastValue).booleanValue()) {
                        values.set(lastIndex, new Boolean(false));
                        conditionActions.add(new ValueAction(157, blockLength + iteratorLength + 5));
                        conditionLength += 5;
                    }
                } else if (lastValue instanceof Integer) {
                    if ((Integer)lastValue > 0) {
                        values.set(lastIndex, new Integer(0));
                        conditionActions.add(new ValueAction(157, blockLength + iteratorLength + 5));
                        conditionLength += 5;
                    }
                } else if (lastValue instanceof Double) {
                    if ((Double)lastValue > 0.0) {
                        values.set(lastIndex, new Double(0.0));
                        conditionActions.add(new ValueAction(157, blockLength + iteratorLength + 5));
                        conditionLength += 5;
                    }
                } else if (lastValue instanceof String && !((String)lastValue).equals("0")) {
                    values.set(lastIndex, "0");
                    conditionActions.add(new ValueAction(157, blockLength + iteratorLength + 5));
                    conditionLength += 5;
                }
            } else {
                conditionActions.add(new Action(18));
                conditionActions.add(new ValueAction(157, blockLength + iteratorLength + 5));
                conditionLength += 6;
            }
        }
        iteratorActions.add(new ValueAction(153, -(conditionLength + blockLength + (iteratorLength += 5))));
        int currentLength = conditionLength;
        for (int i = 0; i < blockActions.size(); ++i) {
            Action currentAction = (Action)blockActions.get(i);
            currentLength += currentAction.length(info.version, info.encoding);
            if (currentAction.type == 256) {
                blockActions.set(i, new ValueAction(153, blockLength + conditionLength - currentLength + iteratorLength));
            }
            if (currentAction.type != 257) continue;
            blockActions.set(i, new ValueAction(153, blockLength + conditionLength - currentLength));
        }
        actions.addAll(initializeActions);
        actions.addAll(conditionActions);
        actions.addAll(blockActions);
        actions.addAll(iteratorActions);
    }

    private void generateForIn(ASInfo info, ArrayList actions) {
        int count = this.count();
        ArrayList<ValueAction> conditionActions = new ArrayList<ValueAction>();
        ArrayList<Action> blockActions = new ArrayList<Action>();
        int conditionLength = 0;
        int blockLength = 0;
        switch (info.version) {
            case 5: {
                this.children[1].generate(info, actions);
                actions.remove(actions.size() - 1);
                actions.add(new Action(70));
                break;
            }
            case 6: 
            case 7: {
                this.children[1].generate(info, actions);
                actions.add(new Action(85));
            }
        }
        this.addReference(blockActions, info, this.children[0].sValue);
        this.addLiteral(blockActions, new RegisterIndex(0));
        blockActions.add(new Action(29));
        if (count == 3) {
            this.children[2].discardValues();
            this.children[2].generate(info, blockActions);
        }
        blockLength = this.actionLength(blockActions, info.version, info.encoding);
        conditionActions.add(new ValueAction(135, 0));
        this.addLiteral(conditionActions, new Null());
        this.addAction(conditionActions, 73);
        conditionActions.add(new ValueAction(157, blockLength + 5));
        conditionLength = this.actionLength(conditionActions, info.version, info.encoding);
        blockActions.add(new ValueAction(153, -(conditionLength + blockLength + 5)));
        blockLength += 5;
        int currentLength = conditionLength;
        for (int i = 0; i < blockActions.size(); ++i) {
            Action currentAction = (Action)blockActions.get(i);
            currentLength += currentAction.length(info.version, info.encoding);
            if (currentAction.type == 256) {
                blockActions.set(i, new ValueAction(153, blockLength - currentLength));
            }
            if (currentAction.type != 257) continue;
            blockActions.set(i, new ValueAction(153, -(conditionLength + currentLength)));
        }
        actions.addAll(conditionActions);
        actions.addAll(blockActions);
    }

    private void generateWith(ASInfo info, ArrayList actions) {
        int i;
        ArrayList array = new ArrayList();
        int count = this.count();
        int length = 0;
        for (i = 1; i < count; ++i) {
            this.children[i].discardValues();
        }
        for (i = 1; i < count; ++i) {
            this.children[i].generate(info, array);
        }
        length = this.actionLength(array, info.version, info.encoding);
        this.children[0].generate(info, actions);
        actions.add(new ValueAction(148, length));
        actions.addAll(array);
    }

    private void generateSwitch(ASInfo info, ArrayList actions) {
        int i;
        int i2;
        int i3;
        int count = this.count();
        int listCount = 0;
        int labelCount = 0;
        int defaultIndex = -1;
        int defaultTarget = -1;
        for (int i4 = 0; i4 < count; ++i4) {
            if (this.children[i4].type == 5) {
                ++listCount;
                continue;
            }
            if (this.children[i4].type != 98) continue;
            if (this.children[i4].children == null) {
                defaultIndex = labelCount;
                defaultTarget = listCount;
            }
            ++labelCount;
        }
        ArrayList[] labelArray = new ArrayList[labelCount];
        int[] labelLength = new int[labelCount];
        int[] labelTarget = new int[labelCount];
        ArrayList[] listArray = new ArrayList[listCount];
        int[] listLength = new int[listCount];
        int[] offsetToEnd = new int[listCount];
        int[] offsetFromStart = new int[listCount];
        for (i3 = 0; i3 < labelCount; ++i3) {
            labelArray[i3] = new ArrayList();
        }
        for (i3 = 0; i3 < listCount; ++i3) {
            listArray[i3] = new ArrayList();
            offsetToEnd[i3] = 0;
            offsetFromStart[i3] = 0;
        }
        int listIndex = 0;
        int labelIndex = 0;
        for (i2 = 0; i2 < count; ++i2) {
            if (this.children[i2].type == 98) {
                if (this.children[i2].children != null) {
                    if (labelIndex == 0) {
                        labelArray[labelIndex].add(new ValueAction(135, 0));
                    } else {
                        this.addLiteral(labelArray[labelIndex], new RegisterIndex(0));
                    }
                }
                this.children[i2].generate(info, labelArray[labelIndex]);
                labelLength[labelIndex] = this.actionLength(labelArray[labelIndex], info.version, info.encoding);
                labelTarget[labelIndex] = listIndex;
                ++labelIndex;
                continue;
            }
            if (this.children[i2].type != 5) continue;
            this.children[i2].generate(info, listArray[listIndex]);
            listLength[listIndex] = this.actionLength(listArray[listIndex], info.version, info.encoding);
            ++listIndex;
        }
        for (i2 = listCount - 2; i2 >= 0; --i2) {
            offsetToEnd[i2] = offsetToEnd[i2 + 1] + listLength[i2 + 1];
        }
        for (i2 = 1; i2 < listCount; ++i2) {
            offsetFromStart[i2] = offsetFromStart[i2 - 1] + listLength[i2 - 1];
        }
        for (i2 = 0; i2 < labelCount; ++i2) {
            int n = i2;
            labelLength[n] = labelLength[n] + (i2 == defaultIndex ? 0 : 6);
        }
        if (defaultIndex != -1) {
            labelLength[defaultIndex] = 5;
        }
        int index = 0;
        this.children[0].generate(info, actions);
        for (i = 1; i < count; ++i) {
            if (this.children[i].type != 98) continue;
            if (this.children[i].children != null) {
                int offset = 0;
                for (int j = index + 1; j < labelCount; ++j) {
                    offset += labelLength[j];
                }
                actions.addAll(labelArray[index]);
                actions.add(new Action(102));
                actions.add(new ValueAction(157, offsetFromStart[labelTarget[index]] + offset));
            } else {
                actions.add(new ValueAction(153, offsetFromStart[defaultTarget]));
            }
            ++index;
        }
        for (i = 0; i < listCount; ++i) {
            int actionType = ((Action)listArray[i].get((int)(listArray[i].size() - 1))).type;
            if (actionType == 256) {
                listArray[i].remove(listArray[i].size() - 1);
                listArray[i].add(new ValueAction(153, offsetToEnd[i]));
            }
            actions.addAll(listArray[i]);
        }
    }

    private void generateLabel(ASInfo info, ArrayList actions) {
        int count = this.count();
        for (int i = 0; i < count; ++i) {
            this.children[i].generate(info, actions);
        }
    }

    private void generateException(ASInfo info, ArrayList actions) {
        int i;
        int count = this.count();
        ArrayList[] actionArray = new ArrayList[count];
        for (i = 0; i < count; ++i) {
            this.children[i].discardValues();
        }
        for (i = 0; i < count; ++i) {
            actionArray[i] = new ArrayList();
            this.children[i].generate(info, actionArray[i]);
        }
        actions.add(new ExceptionHandler(101, null, actionArray[0], actionArray[1], actionArray[2]));
    }

    private void generateClauses(ASInfo info, ArrayList actions) {
        int i;
        int count = this.count();
        for (i = 0; i < count; ++i) {
            this.children[i].discardValues();
        }
        for (i = 0; i < count; ++i) {
            this.children[i].generate(info, actions);
        }
    }

    private void generateOnClipEvent(ASInfo info, ArrayList actions) {
        int i;
        ArrayList<Table> array = new ArrayList<Table>();
        int count = this.count();
        if (info.useStrings) {
            array.add(new Table(info.strings));
        }
        for (i = 0; i < count; ++i) {
            this.children[i].discardValues();
        }
        for (i = 0; i < count; ++i) {
            this.children[i].generate(info, array);
        }
        actions.add(new ASEvent(3, this.iValue, array));
    }

    private void generateOn(ASInfo info, ArrayList actions) {
        int i;
        ArrayList<Table> array = new ArrayList<Table>();
        int count = this.count();
        if (info.useStrings) {
            array.add(new Table(info.strings));
        }
        for (i = 0; i < count; ++i) {
            this.children[i].discardValues();
        }
        for (i = 0; i < count; ++i) {
            this.children[i].generate(info, array);
        }
        actions.add(new ASEvent(2, this.iValue, array));
    }

    private void generateReturn(ASInfo info, ArrayList actions) {
        int count = this.count();
        switch (this.type) {
            case 15: {
                actions.add(new ValueAction(256, 0));
                break;
            }
            case 17: {
                actions.add(new ValueAction(257, 0));
                break;
            }
            case 16: {
                if (count == 0) {
                    this.addLiteral(actions, new Void());
                } else {
                    for (int i = 0; i < count; ++i) {
                        this.children[i].generate(info, actions);
                    }
                }
                this.addAction(actions, 62);
                break;
            }
        }
    }

    private void generateValue(ASInfo info, ArrayList actions) {
        int count = this.count();
        switch (this.type) {
            case 18: {
                int i;
                for (i = count - 1; i >= 0; --i) {
                    if (this.children[i].type != 33 && this.children[i].type != 32) continue;
                    ASNode[] grandChildren = this.children[i].children;
                    if (grandChildren != null) {
                        int numGrandChildren = grandChildren.length;
                        for (int j = numGrandChildren - 1; j >= 0; --j) {
                            grandChildren[j].generate(info, actions);
                        }
                        this.addLiteral(actions, numGrandChildren);
                        continue;
                    }
                    this.addLiteral(actions, 0);
                }
                this.children[0].generate(info, actions);
                for (i = 1; i < count; ++i) {
                    if (this.children[i].type == 33) {
                        Action last = (Action)actions.get(actions.size() - 1);
                        if (last.type == 78) {
                            actions.remove(actions.size() - 1);
                            this.addAction(actions, 82);
                            continue;
                        }
                        this.addAction(actions, 61);
                        continue;
                    }
                    this.children[i].generate(info, actions);
                }
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 20: {
                this.addLiteral(actions, new Boolean(this.bValue));
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 21: {
                this.addLiteral(actions, this.iValue);
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 22: {
                int val = (int)this.dValue;
                if ((double)val == this.dValue) {
                    this.addLiteral(actions, new Integer(val));
                } else {
                    this.addLiteral(actions, new Double(this.dValue));
                }
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 23: {
                this.addReference(actions, info, this.sValue);
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 24: {
                this.addLiteral(actions, new Null());
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 30: {
                if (constants.containsKey(this.sValue)) {
                    if (this.sValue.equals("undefined")) {
                        this.addLiteral(actions, new Void());
                    } else {
                        this.addLiteral(actions, constants.get(this.sValue));
                    }
                } else if (propertyNames.containsKey(this.sValue)) {
                    if (info.context.contains("With")) {
                        this.addReference(actions, info, this.sValue);
                        this.addAction(actions, 28);
                    } else if (info.context.contains("Define Object")) {
                        this.addReference(actions, info, this.sValue);
                        this.addAction(actions, 28);
                    } else if (info.context.contains("setProperty")) {
                        int pVal = (Integer)propertyNames.get(this.sValue);
                        if (pVal >= 16 && pVal <= 21) {
                            this.addLiteral(actions, new Integer(pVal));
                        } else {
                            this.addLiteral(actions, new Property((Integer)earlyPropertyNames.get(this.sValue)));
                        }
                    } else {
                        int pVal = (Integer)propertyNames.get(this.sValue);
                        this.addReference(actions, info, "");
                        if (pVal >= 0 && pVal <= 21) {
                            this.addLiteral(actions, new Integer(pVal));
                        } else {
                            this.addLiteral(actions, new Property(pVal));
                        }
                        this.addAction(actions, 34);
                    }
                } else {
                    this.addReference(actions, info, this.sValue);
                    this.addAction(actions, 28);
                }
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 31: {
                this.addReference(actions, info, this.sValue);
                this.addAction(actions, 78);
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 32: {
                this.addReference(actions, info, this.sValue);
                this.addAction(actions, 82);
                break;
            }
            case 34: {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                this.addLiteral(actions, count);
                this.addReference(actions, info, this.sValue);
                this.addAction(actions, 64);
                break;
            }
            case 35: {
                this.children[0].generate(info, actions);
                this.addAction(actions, 78);
                break;
            }
        }
    }

    private void generateDefinition(ASInfo info, ArrayList actions) {
        int count = this.count();
        int last = count - 1;
        switch (this.type) {
            case 37: {
                for (int i = last; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                this.addLiteral(actions, count);
                this.addAction(actions, 66);
                break;
            }
            case 38: {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addLiteral(actions, count);
                this.addAction(actions, 67);
                break;
            }
            case 36: {
                if (this.sValue.equals("ifFrameLoaded")) {
                    ArrayList array = new ArrayList();
                    this.children[count - 1].discardValues();
                    this.children[count - 1].generate(info, array);
                    if (this.children[0].count() == 0) {
                        this.children[0].generate(info, actions);
                    } else if (this.children[0].count() == 2) {
                        this.children[0].children[1].generate(info, actions);
                    }
                    this.addLiteral(actions, 0);
                    this.addAction(actions, 71);
                    actions.add(new ValueAction(141, array.size()));
                    actions.addAll(array);
                    break;
                }
                if (this.sValue.equals("tellTarget")) {
                    actions.add(new ValueAction(139, this.children[0].sValue));
                    this.children[1].generate(info, actions);
                    actions.add(new ValueAction(139, ""));
                    break;
                }
                ArrayList<String> functionArguments = new ArrayList<String>();
                ArrayList functionActions = new ArrayList();
                if (this.count() == 2) {
                    if (this.children[0].type == 5) {
                        count = this.children[0].count();
                        for (int i = 0; i < count; ++i) {
                            functionArguments.add(this.children[0].children[i].sValue);
                        }
                    } else {
                        functionArguments.add(this.children[0].sValue);
                    }
                }
                this.children[last].discardValues();
                this.children[last].generate(info, functionActions);
                actions.add(new NewFunction(this.sValue, functionArguments, functionActions, info.version, info.encoding));
                break;
            }
            case 39: {
                ArrayList<String> methodArguments = new ArrayList<String>();
                ArrayList methodActions = new ArrayList();
                if (this.count() == 2) {
                    if (this.children[0].type == 5) {
                        count = this.children[0].count();
                        for (int i = 0; i < count; ++i) {
                            methodArguments.add(this.children[0].children[i].sValue);
                        }
                    } else {
                        methodArguments.add(this.children[0].sValue);
                    }
                }
                this.children[last].discardValues();
                this.children[last].generate(info, methodActions);
                actions.add(new NewFunction("", methodArguments, methodActions, info.version, info.encoding));
                break;
            }
            case 40: {
                this.children[0].generate(info, actions);
                actions.remove(actions.size() - 1);
                this.children[1].generate(info, actions);
                break;
            }
            case 41: {
                this.addReference(actions, info, this.sValue);
                this.addAction(actions, 60);
                break;
            }
        }
    }

    private void generateUnary(ASInfo info, ArrayList actions) {
        int count = this.count();
        Action lastAction = null;
        switch (this.type) {
            case 66: {
                this.children[0].generate(info, actions);
                actions.remove(actions.size() - 1);
                this.children[0].generate(info, actions);
                lastAction = (Action)actions.get(actions.size() - 1);
                this.addAction(actions, 80);
                if (!this.discardValue) {
                    actions.add(new ValueAction(135, 0));
                }
                if (lastAction.type == 78) {
                    this.addAction(actions, 79);
                } else {
                    this.addAction(actions, 29);
                }
                if (this.discardValue) break;
                this.addLiteral(actions, new RegisterIndex(0));
                break;
            }
            case 67: {
                this.children[0].generate(info, actions);
                actions.remove(actions.size() - 1);
                this.children[0].generate(info, actions);
                lastAction = (Action)actions.get(actions.size() - 1);
                this.addAction(actions, 81);
                if (!this.discardValue) {
                    actions.add(new ValueAction(135, 0));
                }
                if (lastAction.type == 78) {
                    this.addAction(actions, 79);
                } else {
                    this.addAction(actions, 29);
                }
                if (this.discardValue) break;
                this.addLiteral(actions, new RegisterIndex(0));
                break;
            }
            case 68: {
                if (!this.discardValue) {
                    this.children[0].generate(info, actions);
                }
                this.children[0].generate(info, actions);
                actions.remove(actions.size() - 1);
                this.children[0].generate(info, actions);
                lastAction = (Action)actions.get(actions.size() - 1);
                this.addAction(actions, 80);
                if (lastAction.type == 78) {
                    this.addAction(actions, 79);
                    break;
                }
                this.addAction(actions, 29);
                break;
            }
            case 69: {
                if (!this.discardValue) {
                    this.children[0].generate(info, actions);
                }
                this.children[0].generate(info, actions);
                actions.remove(actions.size() - 1);
                this.children[0].generate(info, actions);
                lastAction = (Action)actions.get(actions.size() - 1);
                this.addAction(actions, 81);
                if (lastAction.type == 78) {
                    this.addAction(actions, 79);
                    break;
                }
                this.addAction(actions, 29);
                break;
            }
            case 64: {
                if (this.children[0].type == 20) {
                    this.children[0].generate(info, actions);
                    this.addLiteral(actions, 0);
                    this.addAction(actions, 71);
                } else if (this.children[0].type == 21) {
                    this.addLiteral(actions, this.children[0].iValue);
                } else if (this.children[0].type == 23) {
                    this.children[0].generate(info, actions);
                    this.addLiteral(actions, 0);
                    this.addAction(actions, 71);
                } else if (this.children[0].type == 24) {
                    this.children[0].generate(info, actions);
                    this.addLiteral(actions, 0);
                    this.addAction(actions, 71);
                } else {
                    this.children[0].generate(info, actions);
                }
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 65: {
                if (this.children[0].type == 20) {
                    this.addLiteral(actions, 0);
                    this.children[0].generate(info, actions);
                    this.addAction(actions, 11);
                } else if (this.children[0].type == 21) {
                    this.addLiteral(actions, -this.children[0].iValue);
                } else if (this.children[0].type == 23) {
                    this.addLiteral(actions, 0);
                    this.children[0].generate(info, actions);
                    this.addAction(actions, 11);
                } else if (this.children[0].type == 24) {
                    this.addLiteral(actions, 0);
                    this.children[0].generate(info, actions);
                    this.addAction(actions, 11);
                } else {
                    this.addLiteral(actions, 0);
                    this.children[0].generate(info, actions);
                    this.addAction(actions, 11);
                }
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 63: {
                this.children[0].generate(info, actions);
                this.addLiteral(actions, new Double(Double.longBitsToDouble(4751297606873776128L)));
                this.addAction(actions, 98);
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 62: {
                this.children[0].generate(info, actions);
                this.addAction(actions, 18);
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 83: {
                this.children[0].generate(info, actions);
                actions.remove(actions.size() - 1);
                if (this.children[0].type == 18) {
                    this.addAction(actions, 58);
                } else {
                    this.addAction(actions, 59);
                }
                if (!this.discardValue) break;
                this.addAction(actions, 23);
                break;
            }
            case 97: {
                this.children[0].generate(info, actions);
                this.addAction(actions, 42);
                break;
            }
        }
    }

    private void generateBinary(ASInfo info, ArrayList actions) {
        ArrayList array = new ArrayList();
        int count = this.count();
        int offset = 0;
        switch (this.type) {
            case 60: 
            case 89: 
            case 90: {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                break;
            }
            case 53: 
            case 54: 
            case 57: 
            case 84: 
            case 85: {
                break;
            }
            default: {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
            }
        }
        switch (this.type) {
            case 86: {
                this.addAction(actions, 33);
                break;
            }
            case 89: 
            case 91: {
                this.addAction(actions, 41);
                this.addAction(actions, 18);
                break;
            }
            case 90: {
                this.addAction(actions, 41);
                break;
            }
            case 42: {
                this.addAction(actions, 71);
                break;
            }
            case 43: {
                this.addAction(actions, 11);
                break;
            }
            case 44: {
                this.addAction(actions, 12);
                break;
            }
            case 45: {
                this.addAction(actions, 13);
                break;
            }
            case 46: {
                this.addAction(actions, 63);
                break;
            }
            case 50: {
                this.addAction(actions, 96);
                break;
            }
            case 51: {
                this.addAction(actions, 97);
                break;
            }
            case 52: {
                this.addAction(actions, 98);
                break;
            }
            case 47: {
                this.addAction(actions, 99);
                break;
            }
            case 49: {
                this.addAction(actions, 101);
                break;
            }
            case 48: {
                this.addAction(actions, 100);
                break;
            }
            case 55: {
                this.addAction(actions, 73);
                break;
            }
            case 56: {
                this.addAction(actions, 73);
                this.addAction(actions, 18);
                break;
            }
            case 58: {
                this.addAction(actions, 72);
                break;
            }
            case 57: {
                switch (info.version) {
                    case 5: {
                        this.children[1].generate(info, actions);
                        this.children[0].generate(info, actions);
                        this.addAction(actions, 72);
                        if (this.parent.type == 7) break;
                        this.addAction(actions, 18);
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.children[0].generate(info, actions);
                        this.children[1].generate(info, actions);
                        this.addAction(actions, 103);
                    }
                }
                break;
            }
            case 60: {
                this.addAction(actions, 72);
                this.addAction(actions, 18);
                break;
            }
            case 59: {
                this.addAction(actions, 72);
                if (this.parent.type == 7) break;
                this.addAction(actions, 18);
                break;
            }
            case 101: {
                this.addAction(actions, 16);
                break;
            }
            case 102: {
                this.addAction(actions, 17);
                break;
            }
            case 53: {
                this.addAction(array, 23);
                this.children[1].generate(info, array);
                offset = this.actionLength(array, info.version, info.encoding);
                this.children[0].generate(info, actions);
                this.addAction(actions, 76);
                this.addAction(actions, 18);
                actions.add(new ValueAction(157, offset));
                actions.addAll(array);
                break;
            }
            case 54: {
                this.addAction(array, 23);
                this.children[1].generate(info, array);
                offset = this.actionLength(array, info.version, info.encoding);
                this.children[0].generate(info, actions);
                this.addAction(actions, 76);
                actions.add(new ValueAction(157, offset));
                actions.addAll(array);
                break;
            }
            case 82: {
                this.addAction(actions, 84);
                break;
            }
            case 84: {
                switch (info.version) {
                    case 5: {
                        this.children[0].generate(info, actions);
                        actions.add(new ValueAction(135, 1));
                        this.addAction(actions, 68);
                        this.children[1].generate(info, actions);
                        actions.add(new ValueAction(135, 2));
                        this.addAction(actions, 68);
                        this.addAction(actions, 73);
                        actions.add(new ValueAction(157, 10));
                        this.addLiteral(actions, new Boolean(true));
                        actions.add(new ValueAction(153, 8));
                        this.addLiteral(actions, new RegisterIndex(1));
                        this.addLiteral(actions, new RegisterIndex(2));
                        this.addAction(actions, 73);
                        break;
                    }
                    case 6: {
                        this.addAction(actions, 102);
                    }
                }
                break;
            }
            case 85: {
                switch (info.version) {
                    case 5: {
                        this.children[0].generate(info, actions);
                        actions.add(new ValueAction(135, 1));
                        this.addAction(actions, 68);
                        this.children[1].generate(info, actions);
                        actions.add(new ValueAction(135, 2));
                        this.addAction(actions, 68);
                        this.addAction(actions, 73);
                        actions.add(new ValueAction(157, 10));
                        this.addLiteral(actions, new Boolean(true));
                        actions.add(new ValueAction(153, 8));
                        this.addLiteral(actions, new RegisterIndex(1));
                        this.addLiteral(actions, new RegisterIndex(2));
                        this.addAction(actions, 73);
                        this.addAction(actions, 18);
                        break;
                    }
                    case 6: {
                        this.addAction(actions, 102);
                        this.addAction(actions, 18);
                    }
                }
                break;
            }
        }
        if (this.discardValue) {
            this.addAction(actions, 23);
        }
    }

    private void generateSelect(ASInfo info, ArrayList actions) {
        ArrayList trueActions = new ArrayList();
        int offsetToNext = 0;
        ArrayList falseActions = new ArrayList();
        int offsetToEnd = 0;
        this.children[2].generate(info, falseActions);
        offsetToNext = this.actionLength(falseActions, info.version, info.encoding);
        this.children[1].generate(info, trueActions);
        offsetToEnd = this.actionLength(trueActions, info.version, info.encoding);
        this.children[0].generate(info, actions);
        actions.add(new ValueAction(157, offsetToNext += 5));
        actions.addAll(falseActions);
        actions.add(new ValueAction(153, offsetToEnd));
        actions.addAll(trueActions);
        if (this.discardValue) {
            this.addAction(actions, 23);
        }
    }

    private void generateAssignment(ASInfo info, ArrayList actions) {
        this.children[0].generate(info, actions);
        Action lastAction = (Action)actions.get(actions.size() - 1);
        if (lastAction.type == 28) {
            actions.remove(actions.size() - 1);
        } else if (lastAction.type == 78) {
            actions.remove(actions.size() - 1);
        } else if (lastAction.type == 34) {
            actions.remove(actions.size() - 1);
        } else if (lastAction.type == 60) {
            actions.remove(actions.size() - 1);
        }
        if (this.type != 70) {
            this.children[0].generate(info, actions);
        }
        this.children[1].generate(info, actions);
        switch (this.type) {
            case 71: {
                this.addAction(actions, 71);
                break;
            }
            case 72: {
                this.addAction(actions, 11);
                break;
            }
            case 73: {
                this.addAction(actions, 12);
                break;
            }
            case 74: {
                this.addAction(actions, 13);
                break;
            }
            case 75: {
                this.addAction(actions, 63);
                break;
            }
            case 79: {
                this.addAction(actions, 96);
                break;
            }
            case 80: {
                this.addAction(actions, 97);
                break;
            }
            case 81: {
                this.addAction(actions, 98);
                break;
            }
            case 76: {
                this.addAction(actions, 99);
                break;
            }
            case 78: {
                this.addAction(actions, 101);
                break;
            }
            case 77: {
                this.addAction(actions, 100);
                break;
            }
        }
        if (this.type == 70 && this.parent != null && (this.parent.type == 5 || this.parent.type == 70) && this.children[0].type != 41) {
            actions.add(new ValueAction(135, 0));
        }
        if (lastAction.type == 34) {
            this.addAction(actions, 35);
        } else if (lastAction.type == 78) {
            this.addAction(actions, 79);
        } else if (lastAction.type == 28) {
            this.addAction(actions, 29);
        } else if (lastAction.type == 60) {
            this.addAction(actions, 60);
        }
        if (this.type == 70 && this.parent != null && (this.parent.type == 5 || this.parent.type == 70) && this.children[0].type != 41) {
            this.addLiteral(actions, new RegisterIndex(0));
            if (this.parent.type == 5) {
                this.addAction(actions, 23);
            }
        }
    }

    private void generateFunction(ArrayList actions, ASInfo info, Object value) {
        String name = value == null ? "" : (String)value;
        int count = this.count();
        if (functions.containsKey(name)) {
            if (this.sValue.equals("call")) {
                this.children[0].generate(info, actions);
                Action lastAction = (Action)actions.get(actions.size() - 1);
                if (lastAction.type == 28) {
                    actions.remove(actions.size() - 1);
                }
                this.addAction(actions, 158);
            } else if (this.sValue.equals("chr")) {
                this.children[0].generate(info, actions);
                this.addAction(actions, 51);
            } else if (this.sValue.equals("delete")) {
                this.children[0].generate(info, actions);
                Action lastAction = (Action)actions.get(actions.size() - 1);
                if (lastAction.type == 28) {
                    actions.remove(actions.size() - 1);
                }
                this.addAction(actions, 59);
            } else if (this.sValue.equals("duplicateMovieClip")) {
                this.children[0].generate(info, actions);
                this.children[1].generate(info, actions);
                if (this.children[2].type == 21 && this.children[2].sValue == null) {
                    int level = 16384;
                    this.addLiteral(actions, level += this.children[2].iValue);
                } else {
                    this.addLiteral(actions, 16384);
                    this.children[2].generate(info, actions);
                    this.addAction(actions, 71);
                }
                this.addAction(actions, 36);
            } else if (this.sValue.equals("eval")) {
                this.children[0].generate(info, actions);
                this.addAction(actions, 28);
            } else if (this.sValue.equals("fscommand")) {
                boolean isCommandString = this.children[0].type == 23 && this.children[0].sValue != null;
                boolean isArgumentString = false;
                if (count > 1) {
                    boolean bl = isArgumentString = this.children[1].type == 23 && this.children[1].sValue != null;
                }
                if (isCommandString && isArgumentString) {
                    String url = this.children[0].sValue;
                    String target = this.children[1].sValue;
                    actions.add(new ValueAction(131, url, target));
                } else {
                    if (isCommandString) {
                        this.addReference(actions, info, this.children[0].sValue);
                    } else {
                        this.addReference(actions, info, "FSCommand:");
                        this.children[0].generate(info, actions);
                        this.addAction(actions, 33);
                    }
                    if (count > 1) {
                        this.children[1].generate(info, actions);
                    }
                    actions.add(new ValueAction(154, 0));
                }
            } else if (this.sValue.equals("getProperty")) {
                String propertyName = this.children[1].sValue;
                int pVal = (Integer)propertyNames.get(propertyName);
                this.children[0].generate(info, actions);
                if (pVal >= 1 && pVal <= 21) {
                    this.addLiteral(actions, new Integer(pVal));
                } else if (pVal == 0) {
                    this.addLiteral(actions, new Double(pVal));
                } else {
                    this.addLiteral(actions, new Property(pVal));
                }
                this.addAction(actions, 34);
            } else if (this.sValue.equals("getTimer")) {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 52);
            } else if (this.sValue.equals("getURL")) {
                switch (count) {
                    case 1: {
                        if (this.children[0].type == 23 && this.children[0].sValue != null) {
                            actions.add(new ValueAction(131, this.children[0].sValue, ""));
                            break;
                        }
                        this.children[0].generate(info, actions);
                        this.addReference(actions, info, "");
                        actions.add(new ValueAction(154, 0));
                        break;
                    }
                    case 2: {
                        if (this.children[0].type == 23 && this.children[0].sValue != null && this.children[1].type == 23 && this.children[1].sValue != null) {
                            actions.add(new ValueAction(131, this.children[0].sValue, this.children[1].sValue));
                            break;
                        }
                        this.children[0].generate(info, actions);
                        this.children[1].generate(info, actions);
                        actions.add(new ValueAction(154, 0));
                        break;
                    }
                    case 3: {
                        this.children[0].generate(info, actions);
                        this.children[1].generate(info, actions);
                        if (this.children[2].sValue.toLowerCase().equals("get")) {
                            actions.add(new ValueAction(154, 1));
                            break;
                        }
                        if (this.children[2].sValue.toLowerCase().equals("post")) {
                            actions.add(new ValueAction(154, 2));
                            break;
                        }
                        actions.add(new ValueAction(154, 0));
                        break;
                    }
                }
            } else if (this.sValue.equals("getVersion")) {
                this.addLiteral(actions, "/:$version");
                this.addAction(actions, 28);
            } else if (this.sValue.equals("gotoAndPlay")) {
                int index = count - 1;
                if (info.context.firstElement().toString().equals("MovieClip")) {
                    if (this.children[index].sValue == null) {
                        int frameNumber = this.children[index].iValue - 1;
                        actions.add(new ValueAction(129, frameNumber));
                    } else {
                        actions.add(new ValueAction(140, this.children[index].sValue));
                    }
                    this.addAction(actions, 6);
                } else if (this.children[index].sValue == null) {
                    int frameNumber = this.children[index].iValue - 1;
                    actions.add(new ValueAction(129, frameNumber));
                    this.addAction(actions, 6);
                } else if (this.children[index].sValue.toLowerCase().startsWith("frame ")) {
                    String frame = this.children[index].sValue.substring(6);
                    int frameNumber = 0;
                    try {
                        frameNumber = Integer.valueOf(frame) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (frameNumber == 1) {
                        this.children[index].generate(info, actions);
                        actions.add(new ValueAction(159, 1));
                    } else {
                        actions.add(new ValueAction(129, frameNumber));
                        this.addAction(actions, 6);
                    }
                } else {
                    this.children[index].generate(info, actions);
                    actions.add(new ValueAction(159, 1));
                }
            } else if (this.sValue.equals("gotoAndStop")) {
                int index = count - 1;
                if (info.context.firstElement().toString().equals("MovieClip")) {
                    if (this.children[index].sValue == null) {
                        int frameNumber = this.children[index].iValue - 1;
                        actions.add(new ValueAction(129, frameNumber));
                    } else {
                        actions.add(new ValueAction(140, this.children[index].sValue));
                    }
                } else if (this.children[index].sValue == null) {
                    int frameNumber = this.children[index].iValue - 1;
                    actions.add(new ValueAction(129, frameNumber));
                } else if (this.children[index].sValue.toLowerCase().startsWith("frame ")) {
                    String frame = this.children[index].sValue.substring(6);
                    int frameNumber = 0;
                    try {
                        frameNumber = Integer.valueOf(frame) - 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (frameNumber == 1) {
                        this.children[index].generate(info, actions);
                        actions.add(new ValueAction(159, 0));
                    } else {
                        actions.add(new ValueAction(129, frameNumber));
                    }
                } else {
                    this.children[index].generate(info, actions);
                    actions.add(new ValueAction(159, 0));
                }
            } else if (this.sValue.equals("int")) {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 24);
            } else if (this.sValue.equals("length")) {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 20);
            } else if (this.sValue.equals("loadMovie")) {
                switch (count) {
                    case 2: {
                        if (this.children[0].sValue != null && this.children[1].sValue == null) {
                            String url = this.children[0].sValue;
                            String target = "_level" + this.children[1].iValue;
                            actions.add(new ValueAction(131, url, target));
                            break;
                        }
                        this.children[0].generate(info, actions);
                        this.children[1].generate(info, actions);
                        actions.add(new ValueAction(154, 64));
                        break;
                    }
                    case 3: {
                        this.children[0].generate(info, actions);
                        this.children[1].generate(info, actions);
                        if (this.children[2].sValue.toLowerCase().equals("get")) {
                            actions.add(new ValueAction(154, 65));
                            break;
                        }
                        actions.add(new ValueAction(154, 66));
                        break;
                    }
                }
            } else if (this.sValue.equals("loadVariables")) {
                switch (count) {
                    case 2: {
                        this.children[0].generate(info, actions);
                        this.children[1].generate(info, actions);
                        actions.add(new ValueAction(154, 192));
                        break;
                    }
                    case 3: {
                        this.children[0].generate(info, actions);
                        this.children[1].generate(info, actions);
                        if (this.children[2].sValue.toLowerCase().equals("get")) {
                            actions.add(new ValueAction(154, 193));
                            break;
                        }
                        actions.add(new ValueAction(154, 194));
                        break;
                    }
                }
            } else if (this.sValue.equals("mbchr")) {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 55);
            } else if (this.sValue.equals("mbord")) {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 54);
            } else if (this.sValue.equals("mbsubstring")) {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 53);
            } else if (this.sValue.equals("nextFrame")) {
                this.addAction(actions, 4);
            } else if (this.sValue.equals("nextScene")) {
                actions.add(new ValueAction(129, 0));
            } else if (this.sValue.equals("Number")) {
                this.children[0].generate(info, actions);
                this.addAction(actions, 74);
            } else if (this.sValue.equals("ord")) {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 50);
            } else if (this.sValue.equals("parseInt")) {
                for (int i = count - 1; i >= 0; --i) {
                    this.children[i].generate(info, actions);
                }
                this.addLiteral(actions, count);
                this.addReference(actions, info, name);
                this.addAction(actions, 61);
            } else if (this.sValue.equals("play")) {
                this.addAction(actions, 6);
            } else if (this.sValue.equals("prevFrame")) {
                this.addAction(actions, 5);
            } else if (this.sValue.equals("prevScene")) {
                actions.add(new ValueAction(129, 0));
            } else if (this.sValue.equals("print")) {
                this.children[0].generate(info, actions);
                this.addReference(actions, info, this.children[1].sValue);
                this.addAction(actions, 28);
                actions.add(new ValueAction(154, 0));
            } else if (this.sValue.equals("printNum")) {
                this.addReference(actions, info, this.children[1].sValue);
                if (this.children[0].type == 30) {
                    this.addReference(actions, info, "_level");
                    this.children[0].generate(info, actions);
                    actions.add(new Action(33));
                } else {
                    this.children[0].generate(info, actions);
                }
                actions.add(new ValueAction(154, 0));
            } else if (this.sValue.equals("printAsBitmap")) {
                this.children[0].generate(info, actions);
                this.addReference(actions, info, this.children[1].sValue);
                this.addAction(actions, 28);
                actions.add(new ValueAction(154, 0));
            } else if (this.sValue.equals("printAsBitmapNum")) {
                this.addReference(actions, info, this.children[1].sValue);
                if (this.children[0].type == 30) {
                    this.addReference(actions, info, "_level");
                    this.children[0].generate(info, actions);
                    actions.add(new Action(33));
                } else {
                    this.children[0].generate(info, actions);
                }
                actions.add(new ValueAction(154, 0));
            } else if (this.sValue.equals("random")) {
                this.children[0].generate(info, actions);
                this.addAction(actions, 48);
            } else if (this.sValue.equals("removeMovieClip")) {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 37);
            } else if (this.sValue.equals("set")) {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 29);
            } else if (this.sValue.equals("setProperty")) {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 35);
            } else if (this.sValue.equals("startDrag")) {
                if (count > 2) {
                    this.children[2].generate(info, actions);
                    this.children[3].generate(info, actions);
                    this.children[4].generate(info, actions);
                    this.children[5].generate(info, actions);
                    this.addLiteral(actions, 1);
                    if (this.children[1].getType() == 20) {
                        this.addLiteral(actions, this.children[1].bValue ? 1 : 0);
                    } else {
                        this.children[1].generate(info, actions);
                    }
                } else if (count == 2) {
                    this.addLiteral(actions, 0);
                    if (this.children[1].getType() == 20) {
                        this.addLiteral(actions, this.children[1].bValue ? 1 : 0);
                    } else {
                        this.children[1].generate(info, actions);
                    }
                } else {
                    this.addLiteral(actions, 0);
                    this.addLiteral(actions, 0);
                }
                this.children[0].generate(info, actions);
                this.addAction(actions, 39);
            } else if (this.sValue.equals("stop")) {
                this.addAction(actions, 7);
            } else if (this.sValue.equals("stopAllSounds")) {
                this.addAction(actions, 9);
            } else if (this.sValue.equals("stopDrag")) {
                this.addAction(actions, 40);
            } else if (this.sValue.equals("String")) {
                this.children[0].generate(info, actions);
                this.addAction(actions, 75);
            } else if (this.sValue.equals("substring")) {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 21);
            } else if (this.sValue.equals("targetPath")) {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 69);
            } else if (this.sValue.equals("toggleHighQuality")) {
                this.addAction(actions, 8);
            } else if (this.sValue.equals("trace")) {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 38);
            } else if (this.sValue.equals("typeof")) {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 68);
            } else if (this.sValue.equals("unloadMovie")) {
                if (this.children[0].sValue == null) {
                    actions.add(new ValueAction(131, "", "_level" + this.children[0].iValue));
                } else {
                    this.addLiteral(actions, "");
                    this.children[0].generate(info, actions);
                    actions.add(new ValueAction(154, 64));
                }
            } else if (this.sValue.equals("unloadMovieNum")) {
                if (this.children[0].sValue == null) {
                    actions.add(new ValueAction(131, "", "_level" + this.children[0].iValue));
                } else {
                    this.addLiteral(actions, "");
                    this.children[0].generate(info, actions);
                    actions.add(new ValueAction(154, 64));
                }
            } else if (this.sValue.equals("void")) {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addAction(actions, 23);
                this.addLiteral(actions, new Void());
            } else {
                for (int i = 0; i < count; ++i) {
                    this.children[i].generate(info, actions);
                }
                this.addReference(actions, info, name);
                this.addAction(actions, 61);
            }
            if (((Boolean)functions.get(name)).booleanValue() && this.discardValue) {
                this.addAction(actions, 23);
            }
        } else if (this.sValue.equals("parseInt")) {
            for (int i = count - 1; i >= 0; --i) {
                this.children[i].generate(info, actions);
            }
            this.addLiteral(actions, count);
            this.addReference(actions, info, name);
            this.addAction(actions, 61);
        } else if (this.sValue.equals("updateAfterEvent")) {
            for (int i = count - 1; i >= 0; --i) {
                this.children[i].generate(info, actions);
            }
            this.addLiteral(actions, count);
            this.addReference(actions, info, name);
            this.addAction(actions, 61);
        } else {
            for (int i = count - 1; i >= 0; --i) {
                this.children[i].generate(info, actions);
            }
            this.addLiteral(actions, count);
            this.addReference(actions, info, name);
            this.addAction(actions, 61);
            if (!valueFunctions.containsKey(name) && this.discardValue) {
                this.addAction(actions, 23);
            }
        }
        if (valueFunctions.containsKey(name) && this.discardValue) {
            this.addAction(actions, 23);
        }
    }

    private void addReference(ArrayList actions, ASInfo info, Object literal) {
        int value;
        if (info.useStrings && info.strings.contains(literal)) {
            literal = new TableIndex(info.strings.indexOf(literal));
        }
        if (literal instanceof Integer && (value = ((Integer)literal).intValue()) == 0) {
            literal = new Double(0.0);
        }
        if (actions.size() > 0) {
            Action action = (Action)actions.get(actions.size() - 1);
            if (action.type == 150) {
                ((Push)action).getValues().add(literal);
            } else {
                actions.add(new Push(literal));
            }
        } else {
            actions.add(new Push(literal));
        }
    }

    private void addLiteral(ArrayList actions, int value) {
        Number number = null;
        number = value == 0 ? (Number)new Double(0.0) : (Number)new Integer(value);
        if (actions.size() > 0) {
            Action action = (Action)actions.get(actions.size() - 1);
            if (action.type == 150) {
                ((Push)action).getValues().add(number);
            } else {
                actions.add(new Push(number));
            }
        } else {
            actions.add(new Push(number));
        }
    }

    private void addLiteral(ArrayList actions, Object literal) {
        int value;
        Action action = null;
        if (literal instanceof Integer && (value = ((Integer)literal).intValue()) == 0) {
            literal = new Double(0.0);
        }
        if (actions.size() > 0) {
            action = (Action)actions.get(actions.size() - 1);
        }
        if (action != null && action.type == 150) {
            ((Push)action).getValues().add(literal);
        } else {
            actions.add(new Push(literal));
        }
    }

    private void addAction(ArrayList actions, int type) {
        actions.add(new Action(type));
    }

    private int actionLength(ArrayList array, int version, String encoding) {
        int length = 0;
        for (Action action : array) {
            length += action.length(version, encoding);
        }
        return length;
    }

    private void discardValues() {
        this.discardValue = true;
        if (this.type == 5 || this.type == 4) {
            int count = this.count();
            for (int i = 0; i < count; ++i) {
                this.children[i].discardValues();
            }
        }
    }

    void validate() throws ParseException {
        boolean reportError = false;
        int count = this.count();
        ASNode node = this;
        switch (this.type) {
            case 2: {
                for (int i = 0; i < count; ++i) {
                    if (this.children[i].type == 14) continue;
                    reportError = true;
                }
                if (!reportError) break;
                this.reportError("OnOnly", this.number);
                break;
            }
            case 3: {
                for (int i = 0; i < count; ++i) {
                    if (this.children[i].getType() == 13) continue;
                    reportError = true;
                }
                if (!reportError) break;
                this.reportError("OnClipEventOnly", this.number);
                break;
            }
            case 15: {
                reportError = true;
                while (node != null) {
                    if (node.type == 8 || node.type == 9 || node.type == 11 || node.type == 10 || node.type == 96) {
                        reportError = false;
                    }
                    node = node.parent;
                }
                if (!reportError) break;
                this.reportError("CannotUseBreak", this.number);
                break;
            }
            case 17: {
                reportError = true;
                while (node != null) {
                    if (node.type == 8 || node.type == 9 || node.type == 11 || node.type == 10) {
                        reportError = false;
                    }
                    node = node.parent;
                }
                if (!reportError) break;
                this.reportError("CannotUseContinue", this.number);
                break;
            }
            case 16: {
                reportError = true;
                while (node != null) {
                    if (node.type == 36 || node.type == 39) {
                        reportError = false;
                    }
                    node = node.parent;
                }
                if (!reportError) break;
                this.reportError("CannotUseReturn", this.number);
                break;
            }
            case 33: {
                Object error = null;
                if (this.sValue.equals("delete")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("duplicateMovieClip")) {
                    if (count == 3) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("escape")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("eval")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("fscommand")) {
                    if (count >= 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("getProperty")) {
                    if (count == 2) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("getURL")) {
                    if (count >= 1 && count <= 3) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("getVersion")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("gotoAndPlay")) {
                    if (count >= 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("gotoAndStop")) {
                    if (count >= 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("hitTest")) {
                    if (count >= 1 && count <= 3) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("isFinite")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("isNaN")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("loadMovie")) {
                    if (count >= 1 && count <= 3) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("loadVariables")) {
                    if (count >= 1 && count <= 3) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("nextFrame")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("nextScene")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("Number")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("parseInt")) {
                    if (count >= 1 && count <= 2) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("parseFloat")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("play")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("prevFrame")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("prevScene")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("print")) {
                    if (count == 2) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("printAsBitmap")) {
                    if (count == 2) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("removeMovieClip")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("set")) {
                    if (count == 2) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("setProperty")) {
                    if (count == 3) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("startDrag")) {
                    if (count == 1 || count == 2 || count == 6) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("stop")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("stopAllSounds")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("stopDrag")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("String")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("targetPath")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("toggleHighQuality")) {
                    if (count == 0) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("trace")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("typeof")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("unescape")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (this.sValue.equals("unloadMovie")) {
                    if (count == 1) break;
                    this.reportError("IncorrectArgumentCount", this.number);
                    break;
                }
                if (!this.sValue.equals("void") || count == 1) break;
                this.reportError("IncorrectArgumentCount", this.number);
            }
        }
        for (int i = 0; i < count; ++i) {
            this.children[i].validate();
        }
    }

    private void reportError(String errorKey, int number) throws ParseException {
        ParseException parseError = new ParseException(errorKey);
        parseError.currentToken = new Token();
        parseError.currentToken.beginLine = number;
        throw parseError;
    }

    static {
        buttonEvents.put("rollOver", new Integer(1));
        buttonEvents.put("rollOut", new Integer(2));
        buttonEvents.put("press", new Integer(4));
        buttonEvents.put("release", new Integer(8));
        buttonEvents.put("dragOut", new Integer(16));
        buttonEvents.put("dragOver", new Integer(160));
        buttonEvents.put("releaseOutside", new Integer(64));
        buttonEvents.put("menuDragOver", new Integer(160));
        buttonEvents.put("menuDragOut", new Integer(256));
        buttonEvents.put("<left>", new Integer(512));
        buttonEvents.put("<right>", new Integer(1024));
        buttonEvents.put("<home>", new Integer(1536));
        buttonEvents.put("<end>", new Integer(2048));
        buttonEvents.put("<insert>", new Integer(2560));
        buttonEvents.put("<delete>", new Integer(3072));
        buttonEvents.put("<backspace>", new Integer(4096));
        buttonEvents.put("<enter>", new Integer(6656));
        buttonEvents.put("<up>", new Integer(7168));
        buttonEvents.put("<down>", new Integer(7680));
        buttonEvents.put("<pageUp>", new Integer(8192));
        buttonEvents.put("<pageDown>", new Integer(8704));
        buttonEvents.put("<tab>", new Integer(9216));
        buttonEvents.put("<escape>", new Integer(9728));
        buttonEvents.put("<space>", new Integer(16384));
        clipEvents.put("load", new Integer(1));
        clipEvents.put("enterFrame", new Integer(2));
        clipEvents.put("unload", new Integer(4));
        clipEvents.put("mouseMove", new Integer(8));
        clipEvents.put("mouseDown", new Integer(16));
        clipEvents.put("mouseUp", new Integer(32));
        clipEvents.put("keyDown", new Integer(64));
        clipEvents.put("keyUp", new Integer(128));
        clipEvents.put("data", new Integer(256));
        constants.put("Math.E", new Double(Math.E));
        constants.put("Math.LN2", new Double(Math.log(2.0)));
        constants.put("Math.LOG2E", new Double(Math.log(Math.E) / Math.log(2.0)));
        constants.put("Math.LN10", new Double(Math.log(10.0)));
        constants.put("Math.LOG10E", new Double(Math.log(Math.E) / Math.log(10.0)));
        constants.put("Math.PI", new Double(Math.PI));
        constants.put("Math.SQRT1_2", new Double(Math.sqrt(0.5)));
        constants.put("Math.SQRT2", new Double(Math.sqrt(2.0)));
        constants.put("Number.MAX_VALUE", new Double(Double.MAX_VALUE));
        constants.put("Number.MIN_VALUE", new Double(Double.MIN_VALUE));
        constants.put("Number.NaN", new Double(Double.NaN));
        constants.put("Number.NEGATIVE_INFINITY", new Double(Double.NEGATIVE_INFINITY));
        constants.put("Number.POSITIVE_INFINITY", new Double(Double.POSITIVE_INFINITY));
        constants.put("Key.BACKSPACE", new Integer(8));
        constants.put("Key.CAPSLOCK", new Integer(20));
        constants.put("Key.CONTROL", new Integer(17));
        constants.put("Key.DELETEKEY", new Integer(46));
        constants.put("Key.DOWN", new Integer(40));
        constants.put("Key.END", new Integer(35));
        constants.put("Key.ENTER", new Integer(13));
        constants.put("Key.ESCAPE", new Integer(27));
        constants.put("Key.HOME", new Integer(36));
        constants.put("Key.INSERT", new Integer(45));
        constants.put("Key.LEFT", new Integer(37));
        constants.put("Key.PGDN", new Integer(34));
        constants.put("Key.PGUP", new Integer(33));
        constants.put("Key.RIGHT", new Integer(39));
        constants.put("Key.SHIFT", new Integer(16));
        constants.put("Key.SPACE", new Integer(32));
        constants.put("Key.TAB", new Integer(9));
        constants.put("Key.UP", new Integer(38));
        constants.put("newline", new String("\n"));
        constants.put("undefined", null);
        earlyPropertyNames.put("_x", new Integer(0));
        earlyPropertyNames.put("_y", new Integer(1065353216));
        earlyPropertyNames.put("_xscale", new Integer(0x40000000));
        earlyPropertyNames.put("_yscale", new Integer(0x40400000));
        earlyPropertyNames.put("_currentframe", new Integer(0x40800000));
        earlyPropertyNames.put("_totalframes", new Integer(0x40A00000));
        earlyPropertyNames.put("_alpha", new Integer(0x40C00000));
        earlyPropertyNames.put("_visible", new Integer(0x40E00000));
        earlyPropertyNames.put("_width", new Integer(0x41000000));
        earlyPropertyNames.put("_height", new Integer(0x41100000));
        earlyPropertyNames.put("_rotation", new Integer(1092616192));
        earlyPropertyNames.put("_target", new Integer(1093664768));
        earlyPropertyNames.put("_framesloaded", new Integer(0x41400000));
        earlyPropertyNames.put("_name", new Integer(1095761920));
        earlyPropertyNames.put("_droptarget", new Integer(1096810496));
        earlyPropertyNames.put("_url", new Integer(1097859072));
        earlyPropertyNames.put("_highquality", new Integer(16));
        earlyPropertyNames.put("_focusrect", new Integer(17));
        earlyPropertyNames.put("_soundbuftime", new Integer(18));
        earlyPropertyNames.put("_quality", new Integer(19));
        earlyPropertyNames.put("_xmouse", new Integer(20));
        earlyPropertyNames.put("_ymouse", new Integer(21));
        propertyNames.put("_x", new Integer(0));
        propertyNames.put("_y", new Integer(1));
        propertyNames.put("_xscale", new Integer(2));
        propertyNames.put("_yscale", new Integer(3));
        propertyNames.put("_currentframe", new Integer(4));
        propertyNames.put("_totalframes", new Integer(5));
        propertyNames.put("_alpha", new Integer(6));
        propertyNames.put("_visible", new Integer(7));
        propertyNames.put("_width", new Integer(8));
        propertyNames.put("_height", new Integer(9));
        propertyNames.put("_rotation", new Integer(10));
        propertyNames.put("_target", new Integer(11));
        propertyNames.put("_framesloaded", new Integer(12));
        propertyNames.put("_name", new Integer(13));
        propertyNames.put("_droptarget", new Integer(14));
        propertyNames.put("_url", new Integer(15));
        propertyNames.put("_highquality", new Integer(16));
        propertyNames.put("_focusrect", new Integer(17));
        propertyNames.put("_soundbuftime", new Integer(18));
        propertyNames.put("_quality", new Integer(19));
        propertyNames.put("_xmouse", new Integer(20));
        propertyNames.put("_ymouse", new Integer(21));
        functions.put("call", new Boolean(false));
        functions.put("chr", new Boolean(true));
        functions.put("delete", new Boolean(false));
        functions.put("duplicateMovieClip", new Boolean(false));
        functions.put("eval", new Boolean(true));
        functions.put("fscommand", new Boolean(false));
        functions.put("getProperty", new Boolean(true));
        functions.put("getTimer", new Boolean(true));
        functions.put("getURL", new Boolean(false));
        functions.put("getVersion", new Boolean(true));
        functions.put("gotoAndPlay", new Boolean(false));
        functions.put("gotoAndStop", new Boolean(false));
        functions.put("ifFrameLoaded", new Boolean(false));
        functions.put("int", new Boolean(true));
        functions.put("loadMovie", new Boolean(false));
        functions.put("loadVariables", new Boolean(false));
        functions.put("length", new Boolean(true));
        functions.put("mbchr", new Boolean(true));
        functions.put("mbord", new Boolean(true));
        functions.put("mbsubstring", new Boolean(true));
        functions.put("nextFrame", new Boolean(false));
        functions.put("nextScene", new Boolean(false));
        functions.put("Number", new Boolean(false));
        functions.put("ord", new Boolean(true));
        functions.put("play", new Boolean(false));
        functions.put("prevFrame", new Boolean(false));
        functions.put("prevScene", new Boolean(false));
        functions.put("print", new Boolean(false));
        functions.put("printNum", new Boolean(false));
        functions.put("printAsBitmap", new Boolean(false));
        functions.put("printAsBitmapNum", new Boolean(false));
        functions.put("random", new Boolean(true));
        functions.put("removeMovieClip", new Boolean(false));
        functions.put("set", new Boolean(false));
        functions.put("setProperty", new Boolean(false));
        functions.put("startDrag", new Boolean(false));
        functions.put("stop", new Boolean(false));
        functions.put("stopAllSounds", new Boolean(false));
        functions.put("stopDrag", new Boolean(false));
        functions.put("String", new Boolean(false));
        functions.put("substring", new Boolean(true));
        functions.put("targetPath", new Boolean(false));
        functions.put("tellTarget", new Boolean(false));
        functions.put("toggleHighQuality", new Boolean(false));
        functions.put("trace", new Boolean(false));
        functions.put("typeof", new Boolean(true));
        functions.put("unloadMovie", new Boolean(false));
        functions.put("unloadMovieNum", new Boolean(false));
        functions.put("void", new Boolean(true));
        valueFunctions.put("attachAudio", null);
        valueFunctions.put("attachMovie", null);
        valueFunctions.put("escape", null);
        valueFunctions.put("getBounds", null);
        valueFunctions.put("getBytesLoaded", null);
        valueFunctions.put("getBytesTotal", null);
        valueFunctions.put("getVersion", null);
        valueFunctions.put("globalToLocal", null);
        valueFunctions.put("hitTest", null);
        valueFunctions.put("isFinite", null);
        valueFunctions.put("isNaN", null);
        valueFunctions.put("localToGlobal", null);
        valueFunctions.put("parseFloat", null);
        valueFunctions.put("parseInt", null);
        valueFunctions.put("swapDepths", null);
        valueFunctions.put("targetPath", null);
        valueFunctions.put("unescape", null);
        valueFunctions.put("updateAfterEvent", null);
        classes.put("Math", null);
        classes.put("Clip", null);
    }

    private class ExceptionHandler
    extends Action {
        private int register;
        private String variable;
        private int tryLength;
        private int catchLength;
        private int finalLength;
        private ArrayList tryActions;
        private ArrayList catchActions;
        private ArrayList finalActions;

        ExceptionHandler(int reg, String var, ArrayList tryArray, ArrayList catchArray, ArrayList finalArray) {
            super(143);
            this.register = 0;
            this.variable = null;
            this.tryLength = 0;
            this.catchLength = 0;
            this.finalLength = 0;
            this.tryActions = null;
            this.catchActions = null;
            this.finalActions = null;
            if (var != null) {
                this.variable = var;
            } else {
                this.register = reg;
            }
            this.tryActions = tryArray;
            this.catchActions = catchArray;
            this.finalActions = finalArray;
        }

        @Override
        int length(int version, String encoding) {
            this.length = 11;
            try {
                this.length = this.variable != null ? (this.length += this.variable.getBytes(encoding).length + 1) : ++this.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            Iterator i = this.tryActions.iterator();
            while (i.hasNext()) {
                this.tryLength += ((Coding)i.next()).length(version, encoding);
            }
            i = this.catchActions.iterator();
            while (i.hasNext()) {
                this.catchLength += ((Coding)i.next()).length(version, encoding);
            }
            i = this.finalActions.iterator();
            while (i.hasNext()) {
                this.finalLength += ((Coding)i.next()).length(version, encoding);
            }
            this.tryLength += 5;
            this.tryActions.add(new ValueAction(153, this.catchLength));
            return this.length + this.tryLength + this.catchLength + this.finalLength;
        }

        @Override
        void encode(Coder coder) {
            coder.encode(this.type, 1);
            coder.encode(this.length - 3, 2);
            int flags = 0;
            if (this.variable != null) {
                flags = 4;
            }
            if (this.catchLength != 0) {
                flags += 2;
            }
            if (this.finalLength != 0) {
                ++flags;
            }
            coder.encode(flags, 1);
            coder.encode(this.tryLength, 2);
            coder.encode(this.catchLength, 2);
            coder.encode(this.finalLength, 2);
            if (this.variable != null) {
                coder.encode(this.variable);
            } else {
                coder.encode(this.register, 1);
                coder.encode(0, 1);
            }
            Iterator j = this.tryActions.iterator();
            while (j.hasNext()) {
                ((Coding)j.next()).encode(coder);
            }
            j = this.catchActions.iterator();
            while (j.hasNext()) {
                ((Coding)j.next()).encode(coder);
            }
            j = this.finalActions.iterator();
            while (j.hasNext()) {
                ((Coding)j.next()).encode(coder);
            }
        }
    }

    private class NewFunction
    extends Action {
        private int actionLength;
        private String name;
        private ArrayList arguments;
        private ArrayList actions;

        NewFunction(String name, ArrayList arguments, ArrayList actions, int version, String encoding) {
            super(155);
            this.actionLength = 0;
            this.name = null;
            this.arguments = null;
            this.actions = null;
            this.name = name;
            this.arguments = arguments;
            this.actions = actions;
            this.length = 8 + name.length();
            Iterator i = arguments.iterator();
            while (i.hasNext()) {
                this.length += ((String)i.next()).length() + 1;
            }
            i = actions.iterator();
            while (i.hasNext()) {
                this.actionLength += ((Coding)i.next()).length(version, encoding);
            }
        }

        @Override
        int length(int version, String encoding) {
            return this.length + this.actionLength;
        }

        @Override
        void encode(Coder coder) {
            coder.encode(this.type, 1);
            coder.encode(this.length - 3, 2);
            coder.encode(this.name);
            coder.encode(this.arguments.size(), 2);
            Iterator i = this.arguments.iterator();
            while (i.hasNext()) {
                coder.encode((String)i.next());
            }
            coder.encode(this.actionLength, 2);
            Iterator j = this.actions.iterator();
            while (j.hasNext()) {
                ((Coding)j.next()).encode(coder);
            }
        }
    }

    private class Push
    extends Action {
        private ArrayList values;

        Push(Object value) {
            super(150);
            this.values = new ArrayList();
            this.values.add(value);
        }

        ArrayList getValues() {
            return this.values;
        }

        void add(Object anObject) {
            this.values.add(anObject);
        }

        @Override
        int length(int version, String encoding) {
            this.length = 3;
            for (Object anObject : this.values) {
                if (anObject instanceof Boolean) {
                    this.length += 2;
                    continue;
                }
                if (anObject instanceof Integer) {
                    this.length += 5;
                    continue;
                }
                if (anObject instanceof Double) {
                    this.length += 9;
                    continue;
                }
                if (anObject instanceof String) {
                    try {
                        this.length += ((String)anObject).getBytes(encoding).length + 2;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    continue;
                }
                if (anObject instanceof Null) {
                    ++this.length;
                    continue;
                }
                if (anObject instanceof Void) {
                    ++this.length;
                    continue;
                }
                if (anObject instanceof TableIndex) {
                    this.length += 2;
                    continue;
                }
                if (anObject instanceof RegisterIndex) {
                    this.length += 2;
                    continue;
                }
                if (!(anObject instanceof Property)) continue;
                this.length += 5;
            }
            return this.length;
        }

        @Override
        void encode(Coder coder) {
            coder.encode(this.type, 1);
            coder.encode(this.length - 3, 2);
            for (Object anObject : this.values) {
                if (anObject instanceof Boolean) {
                    coder.encode(5, 1);
                    coder.encode((Boolean)anObject != false ? 1 : 0, 1);
                    continue;
                }
                if (anObject instanceof Integer) {
                    coder.encode(7, 1);
                    coder.encode((Integer)anObject, 4);
                    continue;
                }
                if (anObject instanceof Double) {
                    coder.encode(6, 1);
                    long longValue = Double.doubleToLongBits((Double)anObject);
                    int lowerInt = (int)longValue;
                    int upperInt = (int)(longValue >>> 32);
                    coder.encode(upperInt, 4);
                    coder.encode(lowerInt, 4);
                    continue;
                }
                if (anObject instanceof Null) {
                    coder.encode(2, 1);
                    continue;
                }
                if (anObject instanceof Void) {
                    coder.encode(3, 1);
                    continue;
                }
                if (anObject instanceof RegisterIndex) {
                    coder.encode(4, 1);
                    coder.encode(((RegisterIndex)anObject).index, 1);
                    continue;
                }
                if (anObject instanceof TableIndex) {
                    coder.encode(8, 1);
                    coder.encode(((TableIndex)anObject).index, 1);
                    continue;
                }
                if (anObject instanceof Property) {
                    coder.encode(1, 1);
                    coder.encode(((Property)anObject).value, 4);
                    continue;
                }
                if (!(anObject instanceof String)) continue;
                coder.encode(0, 1);
                coder.encode((String)anObject);
            }
        }
    }

    private class Property {
        int value = 0;

        Property(int val) {
            this.value = val;
        }
    }

    private class RegisterIndex {
        int index = 0;

        RegisterIndex(int anIndex) {
            this.index = anIndex;
        }
    }

    private class TableIndex {
        int index = 0;

        TableIndex(int anIndex) {
            this.index = anIndex;
        }
    }

    private class Void {
        Void() {
        }
    }

    private class Null {
        Null() {
        }
    }

    private class Table
    extends Action {
        private ArrayList values;

        Table(ArrayList array) {
            super(136);
            this.values = null;
            this.values = array;
        }

        @Override
        int length(int version, String encoding) {
            this.length = 5;
            try {
                Iterator i = this.values.iterator();
                while (i.hasNext()) {
                    this.length += ((String)i.next()).getBytes(encoding).length + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.length;
        }

        @Override
        void encode(Coder coder) {
            coder.encode(this.type, 1);
            coder.encode(this.length - 3, 2);
            coder.encode(this.values.size(), 2);
            Iterator i = this.values.iterator();
            while (i.hasNext()) {
                coder.encode((String)i.next());
            }
        }
    }

    private class ValueAction
    extends Action {
        int iValue;
        String sValueA;
        String sValueB;

        ValueAction(int type, int value) {
            super(type);
            this.iValue = 0;
            this.sValueA = null;
            this.sValueB = null;
            switch (this.type) {
                case 135: 
                case 141: 
                case 154: 
                case 159: {
                    this.length = 4;
                    break;
                }
                default: {
                    this.length = 5;
                }
            }
            this.iValue = value;
        }

        ValueAction(int type, String value) {
            super(type);
            this.iValue = 0;
            this.sValueA = null;
            this.sValueB = null;
            this.length = 4 + value.length();
            this.sValueA = value;
        }

        ValueAction(int type, String a, String b) {
            super(type);
            this.iValue = 0;
            this.sValueA = null;
            this.sValueB = null;
            this.length = 5 + a.length() + b.length();
            this.sValueA = a;
            this.sValueB = b;
        }

        @Override
        void encode(Coder coder) {
            coder.encode(this.type, 1);
            coder.encode(this.length - 3, 2);
            if (this.sValueA != null) {
                coder.encode(this.sValueA);
                if (this.sValueB != null) {
                    coder.encode(this.sValueB);
                }
            } else {
                coder.encode(this.iValue, this.length - 3);
            }
        }
    }

    private class Action
    extends Coding {
        static final int NextFrame = 4;
        static final int PrevFrame = 5;
        static final int Play = 6;
        static final int Stop = 7;
        static final int ToggleQuality = 8;
        static final int StopSounds = 9;
        static final int IntegerAdd = 10;
        static final int Subtract = 11;
        static final int Multiply = 12;
        static final int Divide = 13;
        static final int IntegerEquals = 14;
        static final int IntegerLess = 15;
        static final int And = 16;
        static final int Or = 17;
        static final int Not = 18;
        static final int StringEquals = 19;
        static final int StringLength = 20;
        static final int StringExtract = 21;
        static final int Pop = 23;
        static final int ToInteger = 24;
        static final int GetVariable = 28;
        static final int SetVariable = 29;
        static final int SetTarget2 = 32;
        static final int StringAdd = 33;
        static final int GetProperty = 34;
        static final int SetProperty = 35;
        static final int CloneSprite = 36;
        static final int RemoveSprite = 37;
        static final int Trace = 38;
        static final int StartDrag = 39;
        static final int EndDrag = 40;
        static final int StringLess = 41;
        static final int Throw = 42;
        static final int Cast = 43;
        static final int Implements = 44;
        static final int RandomNumber = 48;
        static final int MBStringLength = 49;
        static final int CharToAscii = 50;
        static final int AsciiToChar = 51;
        static final int GetTime = 52;
        static final int MBStringExtract = 53;
        static final int MBCharToAscii = 54;
        static final int MBAsciiToChar = 55;
        static final int DeleteVariable = 58;
        static final int Delete = 59;
        static final int InitVariable = 60;
        static final int ExecuteFunction = 61;
        static final int Return = 62;
        static final int Modulo = 63;
        static final int NamedObject = 64;
        static final int NewVariable = 65;
        static final int NewArray = 66;
        static final int NewObject = 67;
        static final int GetType = 68;
        static final int GetTarget = 69;
        static final int Enumerate = 70;
        static final int Add = 71;
        static final int Less = 72;
        static final int Equals = 73;
        static final int ToNumber = 74;
        static final int ToString = 75;
        static final int Duplicate = 76;
        static final int Swap = 77;
        static final int GetAttribute = 78;
        static final int SetAttribute = 79;
        static final int Increment = 80;
        static final int Decrement = 81;
        static final int ExecuteMethod = 82;
        static final int NewMethod = 83;
        static final int InstanceOf = 84;
        static final int EnumerateObject = 85;
        static final int BitwiseAnd = 96;
        static final int BitwiseOr = 97;
        static final int BitwiseXOr = 98;
        static final int LogicalShiftLeft = 99;
        static final int ArithmeticShiftRight = 100;
        static final int LogicalShiftRight = 101;
        static final int StrictEqual = 102;
        static final int Greater = 103;
        static final int StringGreater = 104;
        static final int Extends = 105;
        static final int ExceptionHandler = 143;
        static final int Call = 158;
        static final int GotoFrame = 129;
        static final int GetUrl = 131;
        static final int RegisterCopy = 135;
        static final int WaitForFrame = 138;
        static final int SetTarget = 139;
        static final int GotoLabel = 140;
        static final int WaitForFrame2 = 141;
        static final int With = 148;
        static final int Jump = 153;
        static final int GetUrl2 = 154;
        static final int If = 157;
        static final int GotoFrame2 = 159;
        static final int Table = 136;
        static final int Push = 150;
        static final int NewFunction = 155;
        static final int MovieToLevel = 0;
        static final int MovieToLevelWithGet = 1;
        static final int MovieToLevelWithPost = 2;
        static final int MovieToTarget = 64;
        static final int MovieToTargetWithGet = 65;
        static final int MovieToTargetWithPost = 66;
        static final int VariablesToLevel = 128;
        static final int VariablesToLevelWithGet = 129;
        static final int VariablesToLevelWithPost = 130;
        static final int VariablesToTarget = 192;
        static final int VariablesToTargetWithGet = 193;
        static final int VariablesToTargetWithPost = 194;
        protected int type;
        protected int length;

        Action(int aType) {
            this.type = 0;
            this.length = 1;
            this.type = aType;
            if (this.type == 158) {
                this.length = 3;
            }
        }

        int type() {
            return this.type;
        }

        @Override
        int length(int version, String encoding) {
            return this.length;
        }

        @Override
        void encode(Coder coder) {
            coder.encode(this.type, 1);
            if (this.type == 158) {
                coder.encode(this.length - 3, 2);
            }
        }
    }

    private class ASEvent
    extends Coding {
        int type;
        int length;
        int event;
        int keyCode;
        ArrayList array;

        ASEvent(int type, int event, ArrayList array) {
            this.type = 0;
            this.length = 0;
            this.event = 0;
            this.keyCode = 0;
            this.array = new ArrayList();
            this.type = type;
            this.event = event;
            this.array = array;
        }

        ASEvent(int type, int event, int code, ArrayList array) {
            this.type = 0;
            this.length = 0;
            this.event = 0;
            this.keyCode = 0;
            this.array = new ArrayList();
            this.type = type;
            this.event = event;
            this.keyCode = code;
            this.array = array;
        }

        @Override
        int length(int version, String encoding) {
            switch (this.type) {
                case 3: {
                    this.length = 5 + (version > 5 ? 4 : 2);
                    if (version > 5 && (this.event & 0x20000) != 0) {
                        ++this.length;
                    }
                    Iterator i = this.array.iterator();
                    while (i.hasNext()) {
                        this.length += ((Coding)i.next()).length(version, encoding);
                    }
                    break;
                }
                case 2: {
                    this.length = 3;
                    Iterator i = this.array.iterator();
                    while (i.hasNext()) {
                        this.length += ((Coding)i.next()).length(version, encoding);
                    }
                    break;
                }
            }
            return this.length;
        }

        @Override
        void encode(Coder coder) {
            int eventSize = coder.version > 5 ? 4 : 2;
            switch (this.type) {
                case 3: {
                    coder.encode(this.event, eventSize);
                    coder.encode(this.length - (4 + eventSize), 4);
                    if (coder.version > 5 && (this.event & 0x20000) != 0) {
                        coder.encode(this.keyCode, 1);
                    }
                    Iterator i = this.array.iterator();
                    while (i.hasNext()) {
                        ((Coding)i.next()).encode(coder);
                    }
                    coder.encode(0, 1);
                    break;
                }
                case 2: {
                    coder.encode(this.event, 2);
                    Iterator i = this.array.iterator();
                    while (i.hasNext()) {
                        ((Coding)i.next()).encode(coder);
                    }
                    coder.encode(0, 1);
                }
            }
        }
    }

    private class ASArray
    extends Coding {
        int type;
        ArrayList array;

        ASArray(int type, ArrayList array) {
            this.type = 0;
            this.array = null;
            this.type = type;
            this.array = array;
        }

        void add(Coding object) {
            this.array.add(object);
        }

        @Override
        int length(int version, String encoding) {
            int length = 0;
            switch (this.type) {
                case 1: {
                    Iterator i = this.array.iterator();
                    while (i.hasNext()) {
                        length += ((Coding)i.next()).length(version, encoding);
                    }
                    break;
                }
                case 2: {
                    Iterator i = this.array.iterator();
                    while (i.hasNext()) {
                        length += 2 + ((Coding)i.next()).length(version, encoding);
                    }
                    break;
                }
                case 3: {
                    length += version > 5 ? 10 : 6;
                    Iterator i = this.array.iterator();
                    while (i.hasNext()) {
                        length += ((Coding)i.next()).length(version, encoding);
                    }
                    break;
                }
            }
            return length;
        }

        @Override
        void encode(Coder coder) {
            switch (this.type) {
                case 1: {
                    Iterator i = this.array.iterator();
                    while (i.hasNext()) {
                        ((Coding)i.next()).encode(coder);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.array.size(); ++i) {
                        Coding event = (Coding)this.array.get(i);
                        boolean lastEvent = i >= this.array.size() - 1;
                        coder.encode(!lastEvent ? event.length(coder.version, coder.encoding) + 2 : 0, 2);
                        event.encode(coder);
                    }
                    break;
                }
                case 3: {
                    int i;
                    int allEvents = 0;
                    int eventSize = coder.version > 5 ? 4 : 2;
                    for (i = 0; i < this.array.size(); ++i) {
                        allEvents |= ((ASEvent)this.array.get((int)i)).event;
                    }
                    coder.encode(0, 2);
                    coder.encode(allEvents, eventSize);
                    for (i = 0; i < this.array.size(); ++i) {
                        ((Coding)this.array.get(i)).encode(coder);
                    }
                    coder.encode(0, eventSize);
                }
            }
        }
    }

    private abstract class Coding {
        static final int Frame = 1;
        static final int Button = 2;
        static final int MovieClip = 3;

        private Coding() {
        }

        abstract int length(int var1, String var2);

        abstract void encode(Coder var1);
    }

    private class Coder {
        int version = 0;
        String encoding = null;
        byte[] data = null;
        int ptr = 0;

        Coder(byte[] bytes, String encoding) {
            this.encoding = encoding;
            this.data = bytes;
        }

        void encode(int value, int numberOfBytes) {
            int i = 0;
            while (i < numberOfBytes) {
                this.data[this.ptr] = (byte)value;
                ++i;
                ++this.ptr;
                value >>>= 8;
            }
        }

        void encode(String str) {
            try {
                byte[] bytes = str.getBytes(this.encoding);
                for (int i = 0; i < bytes.length; ++i) {
                    this.data[this.ptr++] = bytes[i];
                }
                this.data[this.ptr++] = 0;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private class ASInfo {
        int version = 0;
        String encoding = null;
        Stack nodes = new Stack();
        ArrayList strings = new ArrayList(256);
        boolean useStrings = false;
        Stack context = new Stack();

        ASInfo(int version, String encoding) {
            this.version = version;
            this.encoding = encoding;
        }

        void addString(String str) {
            if (this.strings.contains(str)) {
                this.useStrings = true;
            } else if (this.strings.size() < 256) {
                this.strings.add(str);
            }
        }

        void clearStrings() {
            this.strings.clear();
            this.useStrings = false;
        }
    }
}

