/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.encoder.swf.asencoder;

import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.ASNode;
import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.ASParserConstants;
import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.ASParserTokenManager;
import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.JavaCharStream;
import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.ParseException;
import com.neptunelabs.imagemanipulator.encoder.swf.asencoder.Token;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public final class ASParser
implements ASParserConstants {
    private final boolean Debug = false;
    public static String[] errorKeys = new String[]{"FileNotFound", "ReadError", "SingleDirective", "QuoteFileName", "ParseError", "OnOnly", "OnClipEventOnly", "UnknownMovieClipEvent", "UnknownButtonEvent", "IncorrectArgumentCount", "CannotUseBreak", "CannotUseContinue", "CannotUseReturn"};
    private static final String separator = System.getProperty("line.separator");
    private static final String wordDelimiters = " \t";
    private String _filename = "";
    private int _lineNumber = 0;
    private String _line = "";
    private String _error = "";
    private final ArrayList files = new ArrayList();
    private final ArrayList lines = new ArrayList();
    private final ArrayList codes = new ArrayList();
    private ArrayList pathNames = new ArrayList();
    public ASParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[62];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[29];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private final Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private final int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public ASParser() {
        this(System.in);
        this.pathNames.add(".");
    }

    public ArrayList getPaths() {
        return this.pathNames;
    }

    public void setPaths(ArrayList paths) {
        this.pathNames = paths;
    }

    public void setPaths(String paths) {
        StringTokenizer pathTokenizer = new StringTokenizer(paths, File.pathSeparator, false);
        this.pathNames.clear();
        while (pathTokenizer.hasMoreTokens()) {
            this.pathNames.add(pathTokenizer.nextToken());
        }
    }

    public void add(String path) {
        this.pathNames.add(path);
    }

    public String getFilename() {
        return this._filename;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getLine() {
        return this._line;
    }

    public String getError() {
        return this._error;
    }

    public ASNode parse(String script) throws ParseException {
        ASNode root = null;
        this.files.clear();
        this.lines.clear();
        this.codes.clear();
        try {
            if (script != null && script.length() > 0) {
                StringBuffer buffer = new StringBuffer();
                byte[] bytes = null;
                this.processDirectives("", script, buffer);
                try {
                    bytes = buffer.toString().getBytes("UTF-8");
                }
                catch (Exception e) {
                    throw new ParseException();
                }
                this.ReInit(new ByteArrayInputStream(bytes));
            }
            root = this.Script();
            root.validate();
        }
        catch (ParseException e) {
            int errorLine = e.currentToken.beginLine;
            if (errorLine == 0) {
                errorLine = 1;
            }
            this._error = e.tokenImage != null ? "ParseError" : e.getMessage();
            this._filename = (String)this.files.get(errorLine - 1);
            this._lineNumber = (Integer)this.lines.get(errorLine - 1);
            this._line = (String)this.codes.get(errorLine - 1);
            throw e;
        }
        return root;
    }

    private void processDirectives(String fileName, String script, StringBuffer out) throws ParseException {
        String[] statements = script.split("\\r?\\n|\\r\\n?");
        int currentLine = 1;
        int lineNumber = 0;
        boolean includeFile = false;
        for (int i = 0; i < statements.length; ++i) {
            String line = statements[i];
            if (line.indexOf("#include") != -1 || includeFile) {
                String[] words = line.split("\\s");
                for (int j = 0; j < words.length; ++j) {
                    String token = words[j];
                    if (token.equals("#include")) {
                        includeFile = true;
                        lineNumber = currentLine;
                        continue;
                    }
                    if (!includeFile) continue;
                    if (words.length > 2) {
                        this.reportError("SingleDirective", fileName, lineNumber, line);
                    }
                    if (!token.startsWith("\"") || !token.endsWith("\"")) {
                        this.reportError("QuoteFileName", fileName, lineNumber, line);
                    }
                    try {
                        String filename = token.substring(1, token.length() - 1);
                        this.processDirectives(filename, this.contentsOfFile(filename), out);
                    }
                    catch (FileNotFoundException e) {
                        this.reportError("FileNotFound", fileName, lineNumber, line);
                    }
                    catch (IOException e) {
                        this.reportError("ReadError", fileName, lineNumber, line);
                    }
                    includeFile = false;
                }
                continue;
            }
            out.append(line);
            out.append(separator);
            this.files.add(fileName);
            this.lines.add(new Integer(currentLine++));
            this.codes.add(line);
        }
    }

    private void reportError(String errorKey, String fileName, int lineNumber, String line) throws ParseException {
        ParseException parseError = new ParseException(errorKey);
        parseError.currentToken = new Token();
        parseError.currentToken.beginLine = lineNumber;
        this.files.add(fileName);
        this.lines.add(new Integer(lineNumber));
        this.codes.add(line);
        throw parseError;
    }

    private void reportError(String errorKey, Token token) throws ParseException {
        ParseException parseError = new ParseException(errorKey);
        parseError.currentToken = token;
        throw parseError;
    }

    private void reportError(String errorKey, int number) throws ParseException {
        ParseException parseError = new ParseException(errorKey);
        parseError.currentToken = new Token();
        parseError.currentToken.beginLine = number;
        throw parseError;
    }

    private String contentsOfFile(String fileName) throws FileNotFoundException, IOException {
        String script = "";
        boolean fileFound = false;
        Iterator i = this.pathNames.iterator();
        while (i.hasNext()) {
            File aFile = new File((String)i.next() + File.separator + fileName);
            if (!aFile.exists()) continue;
            byte[] fileIn = new byte[(int)aFile.length()];
            FileInputStream fileContents = new FileInputStream(aFile);
            fileContents.read(fileIn);
            script = new String(fileIn);
            fileContents.close();
            fileFound = true;
        }
        if (!fileFound) {
            throw new FileNotFoundException();
        }
        return script;
    }

    public final ASNode Literal() throws ParseException {
        ASNode node = new ASNode(18);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                Token t = this.jj_consume_token(8);
                node.setType(20);
                if (t.image.toLowerCase().equals("true")) {
                    node.setBoolValue(true);
                } else if (t.image.toLowerCase().equals("false")) {
                    node.setBoolValue(false);
                }
                return node;
            }
            case 10: {
                Integer i;
                Token t = this.jj_consume_token(10);
                boolean negative = false;
                try {
                    if (this.token.image.toLowerCase().startsWith("0x")) {
                        i = Integer.valueOf(t.image.substring(2), 16);
                    } else if (this.token.image.startsWith("+")) {
                        i = Integer.valueOf(this.token.image.substring(1));
                    } else if (this.token.image.startsWith("-")) {
                        i = Integer.valueOf(this.token.image.substring(1));
                        negative = true;
                    } else {
                        i = Integer.valueOf(this.token.image);
                    }
                }
                catch (NumberFormatException e) {
                    i = new Integer(0);
                }
                node.setType(21);
                node.setIntValue(negative ? -i.intValue() : i);
                return node;
            }
            case 13: {
                Double d;
                Token t = this.jj_consume_token(13);
                try {
                    d = this.token.image.endsWith("e") ? Double.valueOf(this.token.image + "0") : Double.valueOf(this.token.image);
                }
                catch (NumberFormatException e) {
                    d = new Double(0.0);
                }
                node.setType(22);
                node.setDoubleValue(d);
                return node;
            }
            case 15: {
                Token t = this.jj_consume_token(15);
                node.setType(23);
                node.setStringValue(t.image.substring(1, t.image.length() - 1));
                return node;
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                node.setType(24);
                return node;
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ASNode Identifier() throws ParseException {
        ASNode node = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            Token t = this.jj_consume_token(87);
            node = this.Function();
            node.setStringValue(t.image);
            node.setNumber(t.beginLine);
            return node;
        }
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            Token t = this.jj_consume_token(87);
            node = new ASNode(30, t.image);
            return node;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ASNode Script() throws ParseException {
        ASNode root = new ASNode(1);
        ASNode node = null;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 32: 
                case 42: 
                case 46: 
                case 47: 
                case 51: 
                case 52: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 69: 
                case 70: 
                case 71: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 83: 
                case 84: 
                case 87: 
                case 90: 
                case 92: 
                case 94: 
                case 98: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            node = this.Statement();
            if (node.getType() == 13) {
                root.setType(3);
            } else if (node.getType() == 14) {
                root.setType(2);
            }
            root.setNumber(this.token.beginLine);
            root.add(node);
        }
        return root;
    }

    public final ASNode Statement() throws ParseException {
        ASNode node = null;
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            node = this.BlockStatement();
            return node;
        }
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            node = this.FunctionDefinition();
            return node;
        }
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            node = this.ExpressionStatement();
            return node;
        }
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            node = this.IfStatement();
            return node;
        }
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            node = this.WithStatement();
            return node;
        }
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            node = this.WhileStatement();
            return node;
        }
        if (this.jj_2_9(Integer.MAX_VALUE)) {
            node = this.DoStatement();
            return node;
        }
        if (this.jj_2_10(Integer.MAX_VALUE)) {
            node = this.ForStatement();
            return node;
        }
        if (this.jj_2_11(Integer.MAX_VALUE)) {
            node = this.BreakStatement();
            return node;
        }
        if (this.jj_2_12(Integer.MAX_VALUE)) {
            node = this.ContinueStatement();
            return node;
        }
        if (this.jj_2_13(Integer.MAX_VALUE)) {
            node = this.ReturnStatement();
            return node;
        }
        if (this.jj_2_14(Integer.MAX_VALUE)) {
            node = this.OnClipEvent();
            return node;
        }
        if (this.jj_2_15(Integer.MAX_VALUE)) {
            node = this.On();
            return node;
        }
        if (this.jj_2_16(Integer.MAX_VALUE)) {
            node = this.TryStatement();
            return node;
        }
        if (this.jj_2_17(Integer.MAX_VALUE)) {
            node = this.ThrowStatement();
            return node;
        }
        if (this.jj_2_18(Integer.MAX_VALUE)) {
            node = this.SwitchStatement();
            return node;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ASNode FunctionDefinition() throws ParseException {
        ASNode node = new ASNode(36);
        Object name = null;
        ASNode args = null;
        ASNode body = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 76: {
                this.jj_consume_token(76);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        Token t = this.jj_consume_token(87);
        node.setStringValue(t.image);
        this.jj_consume_token(90);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 32: 
            case 42: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 71: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 92: 
            case 98: {
                args = this.ArgumentList();
                node.add(args);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.jj_consume_token(91);
        body = this.BlockStatement();
        node.add(body);
        return node;
    }

    public final ASNode BlockStatement() throws ParseException {
        ASNode list = new ASNode(4);
        ASNode node = null;
        this.jj_consume_token(92);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 32: 
                case 42: 
                case 46: 
                case 47: 
                case 51: 
                case 52: 
                case 63: 
                case 65: 
                case 66: 
                case 67: 
                case 69: 
                case 70: 
                case 71: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 83: 
                case 84: 
                case 87: 
                case 90: 
                case 92: 
                case 94: 
                case 98: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            node = this.Statement();
            list.add(node);
        }
        this.jj_consume_token(93);
        return list;
    }

    public final ASNode ExpressionStatement() throws ParseException {
        ASNode node = new ASNode(6);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 32: 
            case 42: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 87: 
            case 90: 
            case 92: 
            case 98: {
                node = this.ExpressionList();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        this.jj_consume_token(94);
        return node;
    }

    public final ASNode IfStatement() throws ParseException {
        ASNode ifnode = new ASNode(7);
        ASNode node = null;
        ifnode.add(new ASNode(6));
        Token t = this.jj_consume_token(63);
        this.jj_consume_token(90);
        node = this.ConditionalExpression();
        this.jj_consume_token(91);
        ifnode.set(0, node);
        node = this.Statement();
        ifnode.add(node);
        if (this.jj_2_19(2)) {
            this.jj_consume_token(64);
            node = this.Statement();
            ifnode.add(node);
        }
        return ifnode;
    }

    public final ASNode WithStatement() throws ParseException {
        ASNode withNode = new ASNode(12);
        ASNode node = null;
        this.jj_consume_token(74);
        this.jj_consume_token(90);
        node = this.ConditionalExpression();
        this.jj_consume_token(91);
        withNode.add(node);
        node = this.Statement();
        withNode.add(node);
        return withNode;
    }

    public final ASNode WhileStatement() throws ParseException {
        ASNode whileNode = new ASNode(10);
        ASNode node = null;
        whileNode.add(new ASNode(6));
        this.jj_consume_token(65);
        this.jj_consume_token(90);
        node = this.ConditionalExpression();
        this.jj_consume_token(91);
        whileNode.set(0, node);
        node = this.Statement();
        whileNode.add(node);
        return whileNode;
    }

    public final ASNode DoStatement() throws ParseException {
        ASNode doNode = new ASNode(11);
        ASNode node = null;
        doNode.add(new ASNode(6));
        this.jj_consume_token(66);
        node = this.Statement();
        doNode.set(0, node);
        this.jj_consume_token(65);
        this.jj_consume_token(90);
        node = this.ConditionalExpression();
        this.jj_consume_token(91);
        this.jj_consume_token(94);
        doNode.add(node);
        return doNode;
    }

    public final ASNode ForStatement() throws ParseException {
        ASNode forNode = null;
        ASNode node = null;
        if (this.jj_2_20(5)) {
            this.jj_consume_token(67);
            forNode = new ASNode(8);
            forNode.add(new ASNode(6));
            forNode.add(new ASNode(6));
            forNode.add(new ASNode(6));
            forNode.add(new ASNode(6));
            this.jj_consume_token(90);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 32: 
                case 42: 
                case 46: 
                case 47: 
                case 51: 
                case 52: 
                case 71: 
                case 75: 
                case 76: 
                case 77: 
                case 87: 
                case 90: 
                case 92: 
                case 98: {
                    node = this.ExpressionList();
                    forNode.set(0, node);
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                }
            }
            this.jj_consume_token(94);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 32: 
                case 42: 
                case 46: 
                case 47: 
                case 51: 
                case 52: 
                case 71: 
                case 75: 
                case 76: 
                case 87: 
                case 90: 
                case 92: 
                case 98: {
                    node = this.ConditionalExpression();
                    forNode.set(1, node);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                }
            }
            this.jj_consume_token(94);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 32: 
                case 42: 
                case 46: 
                case 47: 
                case 51: 
                case 52: 
                case 71: 
                case 75: 
                case 76: 
                case 77: 
                case 87: 
                case 90: 
                case 92: 
                case 98: {
                    node = this.ExpressionList();
                    forNode.set(2, node);
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                }
            }
            this.jj_consume_token(91);
            node = this.Statement();
            forNode.set(3, node);
            return forNode;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                forNode = new ASNode(9);
                this.jj_consume_token(90);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 77: {
                        this.jj_consume_token(77);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                Token t = this.jj_consume_token(87);
                forNode.add(new ASNode(30, t.image));
                this.jj_consume_token(68);
                node = this.ConditionalExpression();
                this.jj_consume_token(91);
                forNode.add(node);
                node = this.Statement();
                forNode.add(node);
                return forNode;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ASNode BreakStatement() throws ParseException {
        ASNode node = new ASNode(15);
        Token t = this.jj_consume_token(69);
        this.jj_consume_token(94);
        node.setNumber(t.beginLine);
        return node;
    }

    public final ASNode ContinueStatement() throws ParseException {
        ASNode node = new ASNode(17);
        Token t = this.jj_consume_token(70);
        this.jj_consume_token(94);
        node.setNumber(t.beginLine);
        return node;
    }

    public final ASNode ReturnStatement() throws ParseException {
        ASNode returnNode = new ASNode(16);
        ASNode node = null;
        Token t = this.jj_consume_token(73);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 32: 
            case 42: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 71: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 92: 
            case 98: {
                node = this.ConditionalExpression();
                returnNode.add(node);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(94);
        returnNode.setNumber(t.beginLine);
        return returnNode;
    }

    public final ASNode OnClipEvent() throws ParseException {
        ASNode eventNode = new ASNode(13);
        ASNode node = null;
        Token t = this.jj_consume_token(78);
        this.jj_consume_token(90);
        node = this.Identifier();
        if (node.getType() == 30) {
            if (ASNode.clipEvents.containsKey(node.getStringValue())) {
                int eventCode = (Integer)ASNode.clipEvents.get(node.getStringValue());
                eventNode.setIntValue(eventCode);
            } else {
                this.reportError("UnknownMovieClipEvent", t);
            }
        } else {
            this.reportError("UnknownMovieClipEvent", t);
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(95);
            node = this.Identifier();
            if (node.getType() == 30) {
                if (ASNode.clipEvents.containsKey(node.getStringValue())) {
                    int allEvents = eventNode.getIntValue();
                    int event = (Integer)ASNode.clipEvents.get(node.getStringValue());
                    eventNode.setIntValue(allEvents + event);
                    continue;
                }
                this.reportError("UnknownMovieClipEvent", t);
                continue;
            }
            this.reportError("UnknownMovieClipEvent", t);
        }
        this.jj_consume_token(91);
        node = this.Statement();
        eventNode.add(node);
        return eventNode;
    }

    public final ASNode On() throws ParseException {
        int event;
        ASNode eventNode = new ASNode(14);
        ASNode node = null;
        Token t = this.jj_consume_token(79);
        this.jj_consume_token(90);
        if (this.jj_2_21(2)) {
            node = this.Identifier();
            node = this.Literal();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    node = this.Identifier();
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (node.getType() == 30) {
            if (ASNode.buttonEvents.containsKey(node.getStringValue())) {
                int event2 = (Integer)ASNode.buttonEvents.get(node.getStringValue());
                eventNode.setIntValue(event2);
            } else {
                this.reportError("UnknownButtonEvent", t);
            }
        } else if (node.getType() == 23) {
            String key = node.getStringValue();
            event = 0;
            event = ASNode.buttonEvents.containsKey(key) ? (Integer)ASNode.buttonEvents.get(key) : key.charAt(0) << 9;
            eventNode.setIntValue(event);
        } else {
            this.reportError("UnknownButtonEvent", t);
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(95);
            if (this.jj_2_22(2)) {
                node = this.Identifier();
                node = this.Literal();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 87: {
                        node = this.Identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            if (node.getType() == 30) {
                if (ASNode.buttonEvents.containsKey(node.getStringValue())) {
                    int allEvents = eventNode.getIntValue();
                    event = (Integer)ASNode.buttonEvents.get(node.getStringValue());
                    eventNode.setIntValue(allEvents + event);
                    continue;
                }
                this.reportError("UnknownButtonEvent", t);
                continue;
            }
            if (node.getType() == 23) {
                String key = node.getStringValue();
                int allEvents = eventNode.getIntValue();
                int event3 = 0;
                event3 = ASNode.buttonEvents.containsKey(key) ? (Integer)ASNode.buttonEvents.get(key) : key.charAt(0) << 9;
                eventNode.setIntValue(allEvents + event3);
                continue;
            }
            this.reportError("UnknownButtonEvent", t);
        }
        this.jj_consume_token(91);
        node = this.Statement();
        eventNode.add(node);
        return eventNode;
    }

    public final ASNode TryStatement() throws ParseException {
        ASNode exceptionNode = new ASNode(92);
        ASNode node = null;
        ASNode catchNode = null;
        this.jj_consume_token(80);
        node = this.Statement();
        ASNode tryNode = new ASNode(93);
        tryNode.add(node);
        exceptionNode.add(tryNode);
        while (this.jj_2_23(2)) {
            this.jj_consume_token(81);
            this.jj_consume_token(90);
            node = this.ConditionalExpression();
            this.jj_consume_token(91);
            catchNode = new ASNode(94);
            exceptionNode.add(catchNode);
            node = this.Statement();
            catchNode.add(node);
        }
        if (this.jj_2_24(2)) {
            this.jj_consume_token(82);
            node = this.Statement();
            ASNode finallyNode = new ASNode(95);
            finallyNode.add(node);
            exceptionNode.add(finallyNode);
        }
        return exceptionNode;
    }

    public final ASNode ThrowStatement() throws ParseException {
        ASNode throwNode = new ASNode(97);
        ASNode node = null;
        this.jj_consume_token(83);
        node = this.ConditionalExpression();
        throwNode.add(node);
        this.jj_consume_token(94);
        return throwNode;
    }

    public final ASNode SwitchStatement() throws ParseException {
        ASNode switchNode = new ASNode(96);
        ASNode label = null;
        ASNode list = null;
        ASNode node = null;
        this.jj_consume_token(84);
        this.jj_consume_token(90);
        node = this.ConditionalExpression();
        this.jj_consume_token(91);
        switchNode.add(node);
        this.jj_consume_token(92);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 85: 
                case 86: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block6;
                }
            }
            label = this.SwitchLabel();
            switchNode.add(label);
            list = new ASNode(5);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 15: 
                    case 32: 
                    case 42: 
                    case 46: 
                    case 47: 
                    case 51: 
                    case 52: 
                    case 63: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 83: 
                    case 84: 
                    case 87: 
                    case 90: 
                    case 92: 
                    case 94: 
                    case 98: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block7;
                    }
                }
                node = this.Statement();
                list.add(node);
            }
            if (list.count() <= 0) continue;
            switchNode.add(list);
        }
        this.jj_consume_token(93);
        return switchNode;
    }

    public final ASNode SwitchLabel() throws ParseException {
        ASNode labelNode = new ASNode(98);
        ASNode node = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 85: {
                this.jj_consume_token(85);
                node = this.Expression();
                this.jj_consume_token(96);
                labelNode.add(node);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                this.jj_consume_token(96);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return labelNode;
    }

    public final ASNode ExpressionList() throws ParseException {
        ASNode block = new ASNode(5);
        ASNode node = null;
        node = this.Expression();
        block.add(node);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(95);
            node = this.Expression();
            block.add(node);
        }
        if (block.count() == 1) {
            return block.get(0);
        }
        return block;
    }

    public final ASNode ArgumentList() throws ParseException {
        ASNode block = new ASNode(5);
        ASNode node = null;
        node = this.ConditionalExpression();
        block.add(node);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(95);
            node = this.ConditionalExpression();
            block.add(node);
        }
        if (block.count() == 1) {
            return block.get(0);
        }
        return block;
    }

    public final ASNode Expression() throws ParseException {
        ASNode node = null;
        node = this.AssignmentExpression();
        return node;
    }

    public final ASNode AssignmentExpression() throws ParseException {
        boolean isVar = false;
        int type = 0;
        ASNode node = null;
        Object left = null;
        ASNode right = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 77: {
                this.jj_consume_token(77);
                isVar = true;
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        node = this.ConditionalExpression();
        if (isVar) {
            node.setType(41);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        this.jj_consume_token(18);
                        type = 70;
                        break;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        type = 71;
                        break;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        type = 72;
                        break;
                    }
                    case 21: {
                        this.jj_consume_token(21);
                        type = 73;
                        break;
                    }
                    case 22: {
                        this.jj_consume_token(22);
                        type = 74;
                        break;
                    }
                    case 23: {
                        this.jj_consume_token(23);
                        type = 75;
                        break;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        type = 76;
                        break;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        type = 77;
                        break;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        type = 78;
                        break;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        type = 79;
                        break;
                    }
                    case 28: {
                        this.jj_consume_token(28);
                        type = 80;
                        break;
                    }
                    case 29: {
                        this.jj_consume_token(29);
                        type = 81;
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                right = this.AssignmentExpression();
                node = new ASNode(type, node, right);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        return node;
    }

    public final ASNode ConditionalExpression() throws ParseException {
        ASNode node = null;
        ASNode cond = null;
        ASNode a = null;
        ASNode b = null;
        node = this.LogicalOrExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 97: {
                this.jj_consume_token(97);
                a = this.Expression();
                this.jj_consume_token(96);
                b = this.ConditionalExpression();
                cond = node;
                node = new ASNode(61);
                node.add(cond);
                node.add(a);
                node.add(b);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        return node;
    }

    public final ASNode LogicalOrExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.LogicalAndExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: 
                case 57: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    this.jj_consume_token(31);
                    type = 54;
                    break;
                }
                case 57: {
                    this.jj_consume_token(57);
                    type = 102;
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            right = this.LogicalAndExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode LogicalAndExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.InclusiveOrExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: 
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    this.jj_consume_token(30);
                    type = 53;
                    break;
                }
                case 56: {
                    this.jj_consume_token(56);
                    type = 101;
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            right = this.InclusiveOrExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode InclusiveOrExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.ExclusiveOrExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(40);
            type = 51;
            right = this.ExclusiveOrExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode ExclusiveOrExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.AndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(41);
            type = 52;
            right = this.AndExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode AndExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.EqualityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 39: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(39);
            type = 50;
            right = this.EqualityExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode EqualityExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.RelationalExpression();
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: 
                case 38: 
                case 53: 
                case 54: 
                case 58: 
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    break block11;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    this.jj_consume_token(33);
                    type = 55;
                    break;
                }
                case 38: {
                    this.jj_consume_token(38);
                    type = 56;
                    break;
                }
                case 53: {
                    this.jj_consume_token(53);
                    type = 84;
                    break;
                }
                case 54: {
                    this.jj_consume_token(54);
                    type = 85;
                    break;
                }
                case 58: {
                    this.jj_consume_token(58);
                    type = 87;
                    break;
                }
                case 59: {
                    this.jj_consume_token(59);
                    type = 88;
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            right = this.RelationalExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode RelationalExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.InstanceExpression();
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 60: 
                case 61: 
                case 62: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block12;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    this.jj_consume_token(35);
                    type = 58;
                    break;
                }
                case 34: {
                    this.jj_consume_token(34);
                    type = 57;
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    type = 60;
                    break;
                }
                case 36: {
                    this.jj_consume_token(36);
                    type = 59;
                    break;
                }
                case 61: {
                    this.jj_consume_token(61);
                    type = 90;
                    break;
                }
                case 60: {
                    this.jj_consume_token(60);
                    type = 89;
                    break;
                }
                case 62: {
                    this.jj_consume_token(62);
                    type = 91;
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            right = this.InstanceExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode InstanceExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.ShiftExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(72);
            type = 82;
            right = this.ShiftExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode ShiftExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.AdditiveExpression();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: 
                case 44: 
                case 45: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: {
                    this.jj_consume_token(43);
                    type = 47;
                    break;
                }
                case 44: {
                    this.jj_consume_token(44);
                    type = 49;
                    break;
                }
                case 45: {
                    this.jj_consume_token(45);
                    type = 48;
                    break;
                }
                default: {
                    this.jj_la1[38] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            right = this.AdditiveExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode AdditiveExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.MultiplicativeExpression();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: 
                case 47: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: {
                    this.jj_consume_token(46);
                    type = 42;
                    break;
                }
                case 47: {
                    this.jj_consume_token(47);
                    type = 43;
                    break;
                }
                case 55: {
                    this.jj_consume_token(55);
                    type = 86;
                    break;
                }
                default: {
                    this.jj_la1[40] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            right = this.MultiplicativeExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode MultiplicativeExpression() throws ParseException {
        int type = 0;
        ASNode left = null;
        ASNode right = null;
        left = this.UnaryExpression();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 48: 
                case 49: 
                case 50: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 48: {
                    this.jj_consume_token(48);
                    type = 44;
                    break;
                }
                case 49: {
                    this.jj_consume_token(49);
                    type = 45;
                    break;
                }
                case 50: {
                    this.jj_consume_token(50);
                    type = 46;
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            right = this.UnaryExpression();
            left = new ASNode(type, left, right);
        }
        return left;
    }

    public final ASNode UnaryExpression() throws ParseException {
        int type = 0;
        ASNode node = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: 
            case 47: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 46: {
                        this.jj_consume_token(46);
                        type = 64;
                        break;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        type = 65;
                        break;
                    }
                    default: {
                        this.jj_la1[43] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                node = this.UnaryExpression();
                return new ASNode(type, node);
            }
            case 51: 
            case 52: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        this.jj_consume_token(51);
                        type = 66;
                        break;
                    }
                    case 52: {
                        this.jj_consume_token(52);
                        type = 67;
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                node = this.PrimaryExpression();
                return new ASNode(type, node);
            }
            case 32: 
            case 42: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 42: {
                        this.jj_consume_token(42);
                        type = 63;
                        break;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        type = 62;
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                node = this.UnaryExpression();
                return new ASNode(type, node);
            }
            case 71: {
                this.jj_consume_token(71);
                type = 83;
                node = this.UnaryExpression();
                return new ASNode(type, node);
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 92: 
            case 98: {
                node = this.PostfixExpression();
                return node;
            }
        }
        this.jj_la1[46] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ASNode PostfixExpression() throws ParseException {
        int type = 0;
        ASNode node = null;
        node = this.PrimaryExpression();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: 
                case 52: {
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: {
                    this.jj_consume_token(51);
                    type = 68;
                    break;
                }
                case 52: {
                    this.jj_consume_token(52);
                    type = 69;
                    break;
                }
                default: {
                    this.jj_la1[48] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            node = new ASNode(type, node);
        }
        return node;
    }

    public final ASNode PrimaryExpression() throws ParseException {
        ASNode list = new ASNode(18);
        ASNode node = null;
        node = this.PrimaryPrefix();
        list.add(node);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 90: 
                case 98: 
                case 100: {
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                    break block3;
                }
            }
            node = this.PrimarySuffix();
            list.add(node);
        }
        if (list.count() == 1) {
            return list.get(0);
        }
        return list;
    }

    public final ASNode PrimaryPrefix() throws ParseException {
        ASNode node = null;
        if (this.jj_2_25(6)) {
            node = this.AnonymousArray();
            return node;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 92: {
                node = this.AnonymousObject();
                return node;
            }
            case 76: {
                node = this.MethodDefinition();
                return node;
            }
            case 75: {
                node = this.Constructor();
                return node;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: {
                node = this.Literal();
                return node;
            }
            case 87: {
                node = this.Identifier();
                return node;
            }
            case 90: {
                this.jj_consume_token(90);
                node = this.ConditionalExpression();
                this.jj_consume_token(91);
                return node;
            }
        }
        this.jj_la1[50] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ASNode PrimarySuffix() throws ParseException {
        ASNode node = null;
        Object name = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 98: {
                this.jj_consume_token(98);
                node = this.ConditionalExpression();
                this.jj_consume_token(99);
                return new ASNode(35, node);
            }
        }
        this.jj_la1[51] = this.jj_gen;
        if (this.jj_2_26(Integer.MAX_VALUE)) {
            this.jj_consume_token(100);
            Token t = this.jj_consume_token(87);
            node = this.Function();
            node.setType(32);
            node.setStringValue(t.image);
            return node;
        }
        if (this.jj_2_27(Integer.MAX_VALUE)) {
            this.jj_consume_token(100);
            Token t = this.jj_consume_token(87);
            node = new ASNode(31);
            node.setStringValue(t.image);
            return node;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                node = this.Function();
                return node;
            }
        }
        this.jj_la1[52] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ASNode Function() throws ParseException {
        ASNode node = new ASNode(33, "");
        ASNode arg = null;
        this.jj_consume_token(90);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 32: 
            case 42: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 71: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 92: 
            case 98: {
                arg = this.ConditionalExpression();
                node.add(arg);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 95: {
                            break;
                        }
                        default: {
                            this.jj_la1[53] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(95);
                    arg = this.ConditionalExpression();
                    node.add(arg);
                }
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        this.jj_consume_token(91);
        return node;
    }

    public final ASNode Constructor() throws ParseException {
        Token t;
        ASNode node = new ASNode(34);
        ASNode arg = null;
        this.jj_consume_token(75);
        if (this.jj_2_28(Integer.MAX_VALUE)) {
            t = this.jj_consume_token(87);
            this.jj_consume_token(90);
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 15: 
                case 32: 
                case 42: 
                case 46: 
                case 47: 
                case 51: 
                case 52: 
                case 71: 
                case 75: 
                case 76: 
                case 87: 
                case 90: 
                case 92: 
                case 98: {
                    arg = this.ConditionalExpression();
                    node.add(arg);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 95: {
                                break;
                            }
                            default: {
                                this.jj_la1[55] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_consume_token(95);
                        arg = this.ConditionalExpression();
                        node.add(arg);
                    }
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                }
            }
            this.jj_consume_token(91);
        } else if (this.jj_2_29(Integer.MAX_VALUE)) {
            t = this.jj_consume_token(87);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        node.setStringValue(t.image);
        return node;
    }

    public final ASNode AnonymousArray() throws ParseException {
        ASNode node = new ASNode(37);
        ASNode element = null;
        this.jj_consume_token(98);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 32: 
            case 42: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 71: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 92: 
            case 98: {
                element = this.ConditionalExpression();
                node.add(element);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 95: {
                            break;
                        }
                        default: {
                            this.jj_la1[57] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(95);
                    element = this.ConditionalExpression();
                    node.add(element);
                }
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        this.jj_consume_token(99);
        return node;
    }

    public final ASNode MethodDefinition() throws ParseException {
        ASNode node = new ASNode(39);
        ASNode args = null;
        ASNode body = null;
        this.jj_consume_token(76);
        this.jj_consume_token(90);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 32: 
            case 42: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 71: 
            case 75: 
            case 76: 
            case 87: 
            case 90: 
            case 92: 
            case 98: {
                args = this.ArgumentList();
                node.add(args);
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        this.jj_consume_token(91);
        body = this.BlockStatement();
        node.add(body);
        return node;
    }

    public final ASNode AnonymousObject() throws ParseException {
        ASNode node = new ASNode(38);
        ASNode attribute = null;
        this.jj_consume_token(92);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: {
                attribute = this.Attribute();
                node.add(attribute);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 95: {
                            break;
                        }
                        default: {
                            this.jj_la1[60] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(95);
                    attribute = this.Attribute();
                    node.add(attribute);
                }
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
            }
        }
        this.jj_consume_token(93);
        return node;
    }

    public final ASNode Attribute() throws ParseException {
        ASNode key = null;
        ASNode value = null;
        key = this.Identifier();
        this.jj_consume_token(96);
        value = this.ConditionalExpression();
        return new ASNode(40, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    private final boolean jj_3R_184() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        return this.jj_scan_token(91);
    }

    private final boolean jj_3R_183() {
        return this.jj_3R_48();
    }

    private final boolean jj_3R_182() {
        return this.jj_3R_49();
    }

    private final boolean jj_3R_181() {
        return this.jj_3R_190();
    }

    private final boolean jj_3R_180() {
        return this.jj_3R_189();
    }

    private final boolean jj_3R_179() {
        return this.jj_3R_188();
    }

    private final boolean jj_3_21() {
        if (this.jj_3R_48()) {
            return true;
        }
        return this.jj_3R_49();
    }

    private final boolean jj_3R_176() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_179()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_180()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_181()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_182()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_183()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_184()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_25() {
        return this.jj_3R_50();
    }

    private final boolean jj_3R_174() {
        return this.jj_scan_token(32);
    }

    private final boolean jj_3R_171() {
        return this.jj_scan_token(52);
    }

    private final boolean jj_3R_169() {
        return this.jj_scan_token(47);
    }

    private final boolean jj_3R_172() {
        Token xsp;
        if (this.jj_3R_176()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_177());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_59()) {
                return true;
            }
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_60());
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_44();
    }

    private final boolean jj_3R_187() {
        return this.jj_scan_token(52);
    }

    private final boolean jj_3R_186() {
        return this.jj_scan_token(51);
    }

    private final boolean jj_3R_178() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_186()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_187()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_175() {
        Token xsp;
        if (this.jj_3R_172()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_178());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_164() {
        return this.jj_3R_175();
    }

    private final boolean jj_3R_58() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        return this.jj_3R_48();
    }

    private final boolean jj_3R_173() {
        return this.jj_scan_token(42);
    }

    private final boolean jj_3R_163() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        return this.jj_3R_155();
    }

    private final boolean jj_3R_170() {
        return this.jj_scan_token(51);
    }

    private final boolean jj_3R_162() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_173()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_174()) {
                return true;
            }
        }
        return this.jj_3R_155();
    }

    private final boolean jj_3R_168() {
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_161() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_170()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_171()) {
                return true;
            }
        }
        return this.jj_3R_172();
    }

    private final boolean jj_3R_160() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_168()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_169()) {
                return true;
            }
        }
        return this.jj_3R_155();
    }

    private final boolean jj_3R_155() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_160()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_161()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_162()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_163()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_164()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_167() {
        return this.jj_scan_token(50);
    }

    private final boolean jj_3R_166() {
        return this.jj_scan_token(49);
    }

    private final boolean jj_3R_165() {
        return this.jj_scan_token(48);
    }

    private final boolean jj_3R_156() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_165()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_166()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_167()) {
                    return true;
                }
            }
        }
        return this.jj_3R_155();
    }

    private final boolean jj_3R_57() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_150() {
        Token xsp;
        if (this.jj_3R_155()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_156());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_39() {
        Token xsp;
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_3R_48()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_58());
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_44();
    }

    private final boolean jj_3R_159() {
        return this.jj_scan_token(55);
    }

    private final boolean jj_3R_158() {
        return this.jj_scan_token(47);
    }

    private final boolean jj_3R_157() {
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_151() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_157()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_158()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_159()) {
                    return true;
                }
            }
        }
        return this.jj_3R_150();
    }

    private final boolean jj_3R_38() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_57()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_148() {
        Token xsp;
        if (this.jj_3R_150()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_151());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_154() {
        return this.jj_scan_token(45);
    }

    private final boolean jj_3R_153() {
        return this.jj_scan_token(44);
    }

    private final boolean jj_3R_37() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_152() {
        return this.jj_scan_token(43);
    }

    private final boolean jj_3R_149() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_152()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_153()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_154()) {
                    return true;
                }
            }
        }
        return this.jj_3R_148();
    }

    private final boolean jj_3R_139() {
        Token xsp;
        if (this.jj_3R_148()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_149());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_78();
    }

    private final boolean jj_3R_46() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_78();
    }

    private final boolean jj_3R_140() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        return this.jj_3R_139();
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(77)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_44();
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_88();
    }

    private final boolean jj_3R_131() {
        Token xsp;
        if (this.jj_3R_139()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_140());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_147() {
        return this.jj_scan_token(62);
    }

    private final boolean jj_3R_146() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_145() {
        return this.jj_scan_token(61);
    }

    private final boolean jj_3R_144() {
        return this.jj_scan_token(36);
    }

    private final boolean jj_3R_143() {
        return this.jj_scan_token(37);
    }

    private final boolean jj_3R_142() {
        return this.jj_scan_token(34);
    }

    private final boolean jj_3R_141() {
        return this.jj_scan_token(35);
    }

    private final boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_56()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_20() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(94)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_46()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(94)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_44();
    }

    private final boolean jj_3R_132() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_141()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_142()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_143()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_144()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_145()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_146()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_147()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_131();
    }

    private final boolean jj_3R_129() {
        Token xsp;
        if (this.jj_3R_131()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_132());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_3R_44()) {
            return true;
        }
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_138() {
        return this.jj_scan_token(59);
    }

    private final boolean jj_3R_137() {
        return this.jj_scan_token(58);
    }

    private final boolean jj_3R_136() {
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_135() {
        return this.jj_scan_token(53);
    }

    private final boolean jj_3R_134() {
        return this.jj_scan_token(38);
    }

    private final boolean jj_3R_133() {
        return this.jj_scan_token(33);
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_44();
    }

    private final boolean jj_3R_130() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_133()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_134()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_135()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_136()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_137()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_138()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_129();
    }

    private final boolean jj_3R_127() {
        Token xsp;
        if (this.jj_3R_129()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_130());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_44();
    }

    private final boolean jj_3_19() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        return this.jj_3R_44();
    }

    private final boolean jj_3R_128() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        return this.jj_3R_127();
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_3R_44()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_125() {
        Token xsp;
        if (this.jj_3R_127()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_128());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_78();
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_126() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        return this.jj_3R_125();
    }

    private final boolean jj_3R_28() {
        Token xsp;
        if (this.jj_scan_token(92)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_52());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(93);
    }

    private final boolean jj_3R_109() {
        Token xsp;
        if (this.jj_3R_125()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_126());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_18() {
        return this.jj_3R_43();
    }

    private final boolean jj_3_17() {
        return this.jj_3R_42();
    }

    private final boolean jj_3_16() {
        return this.jj_3R_41();
    }

    private final boolean jj_3_15() {
        return this.jj_3R_40();
    }

    private final boolean jj_3_14() {
        return this.jj_3R_39();
    }

    private final boolean jj_3_13() {
        return this.jj_3R_38();
    }

    private final boolean jj_3R_110() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_109();
    }

    private final boolean jj_3_12() {
        return this.jj_3R_37();
    }

    private final boolean jj_3R_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(76)) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_53()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_28();
    }

    private final boolean jj_3_11() {
        return this.jj_3R_36();
    }

    private final boolean jj_3_10() {
        return this.jj_3R_35();
    }

    private final boolean jj_3_9() {
        return this.jj_3R_34();
    }

    private final boolean jj_3_8() {
        return this.jj_3R_33();
    }

    private final boolean jj_3R_77() {
        return this.jj_3R_43();
    }

    private final boolean jj_3R_103() {
        Token xsp;
        if (this.jj_3R_109()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_110());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_7() {
        return this.jj_3R_32();
    }

    private final boolean jj_3R_76() {
        return this.jj_3R_42();
    }

    private final boolean jj_3_6() {
        return this.jj_3R_31();
    }

    private final boolean jj_3R_75() {
        return this.jj_3R_41();
    }

    private final boolean jj_3_5() {
        return this.jj_3R_30();
    }

    private final boolean jj_3R_74() {
        return this.jj_3R_40();
    }

    private final boolean jj_3_4() {
        return this.jj_3R_29();
    }

    private final boolean jj_3R_73() {
        return this.jj_3R_39();
    }

    private final boolean jj_3_3() {
        return this.jj_3R_28();
    }

    private final boolean jj_3R_72() {
        return this.jj_3R_38();
    }

    private final boolean jj_3R_112() {
        return this.jj_scan_token(56);
    }

    private final boolean jj_3R_71() {
        return this.jj_3R_37();
    }

    private final boolean jj_3R_111() {
        return this.jj_scan_token(30);
    }

    private final boolean jj_3R_70() {
        return this.jj_3R_36();
    }

    private final boolean jj_3R_69() {
        return this.jj_3R_35();
    }

    private final boolean jj_3R_104() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_111()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_112()) {
                return true;
            }
        }
        return this.jj_3R_103();
    }

    private final boolean jj_3R_68() {
        return this.jj_3R_34();
    }

    private final boolean jj_3R_67() {
        return this.jj_3R_33();
    }

    private final boolean jj_3R_66() {
        return this.jj_3R_32();
    }

    private final boolean jj_3R_65() {
        return this.jj_3R_31();
    }

    private final boolean jj_3R_64() {
        return this.jj_3R_30();
    }

    private final boolean jj_3R_98() {
        Token xsp;
        if (this.jj_3R_103()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_104());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_29();
    }

    private final boolean jj_3R_62() {
        return this.jj_3R_28();
    }

    private final boolean jj_3R_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_64()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_65()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_66()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_67()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_68()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_69()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_70()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_71()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_72()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_73()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_74()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_75()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_76()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_77()) {
                                                                        return true;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_106() {
        return this.jj_scan_token(57);
    }

    private final boolean jj_3R_105() {
        return this.jj_scan_token(31);
    }

    private final boolean jj_3R_99() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_105()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_106()) {
                return true;
            }
        }
        return this.jj_3R_98();
    }

    private final boolean jj_3R_89() {
        Token xsp;
        if (this.jj_3R_98()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_99());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_3R_94()) {
            return true;
        }
        if (this.jj_scan_token(96)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private final boolean jj_3R_55() {
        if (this.jj_3R_89()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_90()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3_2() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3R_93() {
        return this.jj_3R_44();
    }

    private final boolean jj_3R_97() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private final boolean jj_3R_80() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3R_124() {
        return this.jj_scan_token(29);
    }

    private final boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_79()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_80()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private final boolean jj_3R_123() {
        return this.jj_scan_token(28);
    }

    private final boolean jj_3R_122() {
        return this.jj_scan_token(27);
    }

    private final boolean jj_3R_121() {
        return this.jj_scan_token(26);
    }

    private final boolean jj_3R_120() {
        return this.jj_scan_token(25);
    }

    private final boolean jj_3R_119() {
        return this.jj_scan_token(24);
    }

    private final boolean jj_3R_118() {
        return this.jj_scan_token(23);
    }

    private final boolean jj_3R_117() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_116() {
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_115() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_95() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        return this.jj_3R_94();
    }

    private final boolean jj_3R_114() {
        return this.jj_scan_token(19);
    }

    private final boolean jj_3R_113() {
        return this.jj_scan_token(18);
    }

    private final boolean jj_3R_108() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_113()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_114()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_115()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_116()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_117()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_118()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_119()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_120()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_121()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_122()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_123()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_124()) {
                                                        return true;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.jj_3R_102();
    }

    private final boolean jj_3R_107() {
        return this.jj_scan_token(77);
    }

    private final boolean jj_3R_201() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private final boolean jj_3R_85() {
        return this.jj_scan_token(9);
    }

    private final boolean jj_3R_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_107()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        return this.jj_3R_102();
    }

    private final boolean jj_3R_84() {
        return this.jj_scan_token(15);
    }

    private final boolean jj_3R_199() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        return this.jj_3R_198();
    }

    private final boolean jj_3R_88() {
        Token xsp;
        if (this.jj_3R_55()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_97());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_83() {
        return this.jj_scan_token(13);
    }

    private final boolean jj_3R_78() {
        Token xsp;
        if (this.jj_3R_94()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_95());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_101() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        return this.jj_scan_token(96);
    }

    private final boolean jj_3R_100() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_3R_94()) {
            return true;
        }
        return this.jj_scan_token(96);
    }

    private final boolean jj_3R_92() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_100()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_101()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_61() {
        Token xsp;
        if (this.jj_3R_92()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_93());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_200() {
        Token xsp;
        if (this.jj_3R_55()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_201());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_43() {
        Token xsp;
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_scan_token(92)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_61());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(93);
    }

    private final boolean jj_3R_87() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private final boolean jj_3R_82() {
        return this.jj_scan_token(10);
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_91() {
        return this.jj_3R_48();
    }

    private final boolean jj_3R_196() {
        return this.jj_3R_88();
    }

    private final boolean jj_3_24() {
        if (this.jj_scan_token(82)) {
            return true;
        }
        return this.jj_3R_44();
    }

    private final boolean jj_3_23() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_44();
    }

    private final boolean jj_3R_198() {
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_scan_token(96)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private final boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_81()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_82()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_83()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_84()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_85()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_81() {
        return this.jj_scan_token(8);
    }

    private final boolean jj_3R_195() {
        Token xsp;
        if (this.jj_3R_198()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_199());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_41() {
        Token xsp;
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_3R_44()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_23());
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3_24()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_188() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_195()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(93);
    }

    private final boolean jj_3R_189() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_196()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(91)) {
            return true;
        }
        return this.jj_3R_28();
    }

    private final boolean jj_3R_96() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        return this.jj_3R_55();
    }

    private final boolean jj_3R_86() {
        Token xsp;
        if (this.jj_3R_55()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_96());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_29() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3_28() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_scan_token(90);
    }

    private final boolean jj_3R_59() {
        return this.jj_3R_48();
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_86()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(99);
    }

    private final boolean jj_3R_197() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_200()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(91);
    }

    private final boolean jj_3R_190() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_197()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(87)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_51() {
        Token xsp;
        if (this.jj_3R_55()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_87());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_27() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        return this.jj_scan_token(87);
    }

    private final boolean jj_3_26() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_scan_token(90);
    }

    private final boolean jj_3R_177() {
        return this.jj_3R_185();
    }

    private final boolean jj_3_22() {
        if (this.jj_3R_48()) {
            return true;
        }
        return this.jj_3R_49();
    }

    private final boolean jj_3R_27() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(91);
    }

    private final boolean jj_3R_194() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_193() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        return this.jj_scan_token(87);
    }

    private final boolean jj_3R_60() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_91()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_192() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_3R_27();
    }

    private final boolean jj_3R_191() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        return this.jj_scan_token(99);
    }

    private final boolean jj_3R_185() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_191()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_192()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_193()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_194()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{42752, 42752, 0, 42752, 42752, 42752, 42752, 42752, 42752, 0, 0, 42752, 0, 0, 0, 0, 0, 42752, 0, 0, 0, 0, 1073479680, 1073479680, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x40000000, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42752, 0, 0, 0, 42752, 0, 0, 0, 42752, 0, 42752, 0, 42752, 42752, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, -2145860607, 0, 1623041, -2145860607, 1623041, 1623041, 1623041, 1623041, 0, 0, 1623041, 0, 0, 0, 0, 0, -2145860607, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0x2000000, 0x1000000, 0x1000000, 256, 512, 128, 207618114, 207618114, 1879048252, 1879048252, 0, 14336, 14336, 0x80C000, 0x80C000, 458752, 458752, 49152, 0x180000, 1025, 1623041, 0x180000, 0x180000, 0, 0, 0, 0, 0, 1623041, 0, 1623041, 0, 1623041, 1623041, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 1419378414, 4096, 343939200, 1419378414, 343947392, 343947392, 343939200, 343947392, 8192, 8, 343939200, Integer.MIN_VALUE, 0x800000, Integer.MIN_VALUE, 0x800000, 0x600000, 1419378414, 0x600000, Integer.MIN_VALUE, Integer.MIN_VALUE, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 343939200, 0, 0, 0x4000000, 343939072, 0, 0x4000000, Integer.MIN_VALUE, 343939200, Integer.MIN_VALUE, 343939200, Integer.MIN_VALUE, 343939200, 343939200, Integer.MIN_VALUE, 0x800000};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{0, 4, 0, 4, 4, 4, 4, 4, 4, 0, 0, 4, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 20, 0, 4, 0, 0, 4, 0, 4, 0, 4, 4, 0, 0};
    }

    public ASParser(InputStream stream) {
        this(stream, null);
    }

    public ASParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ASParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 62; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 62; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ASParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new ASParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 62; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 62; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ASParser(ASParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 62; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ASParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 62; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[101];
        for (i = 0; i < 101; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 62; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 101; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 29; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ASParser.jj_la1_0();
        ASParser.jj_la1_1();
        ASParser.jj_la1_2();
        ASParser.jj_la1_3();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

