/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.helper;

import com.neptunelabs.fsiframework.logging.FSILogger;
import java.util.ArrayList;
import java.util.TreeMap;

public final class Gradient {
    private final FSILogger logger;
    private final TreeMap<Integer, Integer> gradientMap = new TreeMap();
    private final ArrayList<Integer> gradientSlackyMap = new ArrayList();
    private int minGMPos = 255;
    private boolean hasStart = false;
    private int maxGMPos = 0;
    private boolean hasEnd = false;

    public Gradient(FSILogger logger) {
        this.logger = logger;
    }

    public void addGradientValue(int argb) {
        this.gradientSlackyMap.add(argb);
    }

    public void putGradientValue(int position, int argb) {
        if (position < 0 || position > 255) {
            this.logger.log(3601, position, "value", "position");
        } else {
            this.gradientMap.put(position, argb);
            if (!this.hasStart && position < this.minGMPos) {
                this.minGMPos = position;
                this.gradientMap.put(0, argb);
            }
            if (!this.hasEnd && position > this.maxGMPos) {
                this.maxGMPos = position;
                this.gradientMap.put(255, argb);
            }
        }
        if (position == 0) {
            this.hasStart = true;
        } else if (position == 255) {
            this.hasEnd = true;
        }
    }

    public int[] getPositions() {
        if (this.gradientSlackyMap.size() > 0 && this.gradientMap.size() == 0) {
            this.initGradientMap();
        }
        int[] positions = new int[this.gradientMap.size()];
        int c = 0;
        for (int p : this.gradientMap.keySet()) {
            positions[c++] = p;
        }
        return positions;
    }

    public int[] getValues() {
        if (this.gradientSlackyMap.size() > 0 && this.gradientMap.size() == 0) {
            this.initGradientMap();
        }
        int[] values = new int[this.gradientMap.size()];
        int c = 0;
        for (int p : this.gradientMap.values()) {
            values[c++] = p;
        }
        return values;
    }

    public int getValue(int position) {
        if (this.gradientSlackyMap.size() > 0 && this.gradientMap.size() == 0) {
            this.initGradientMap();
        }
        return this.gradientMap.get(position);
    }

    public int size() {
        return this.gradientMap.size();
    }

    public void initGradientMap() {
        int glen = this.gradientSlackyMap.size();
        int gsize = glen - 1;
        if (gsize > 0) {
            float steps = 255.0f / (float)gsize;
            int s = 0;
            for (int i = 0; i < glen; ++i) {
                s = Math.round((float)i * steps);
                this.putGradientValue(s, this.gradientSlackyMap.get(i));
            }
        } else {
            this.putGradientValue(0, this.gradientSlackyMap.get(0));
        }
    }
}

