/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.helper;

import com.neptunelabs.fsiframework.logging.FSILogger;
import java.util.Map;
import java.util.TreeMap;

public final class SmoothGradient {
    private final FSILogger logger;
    private final TreeMap<Float, Integer> gradientMap = new TreeMap();
    private float lowestKey = 1.0f;
    private float highestKey = 0.0f;

    public SmoothGradient(FSILogger logger) {
        this.logger = logger;
    }

    public void putGradientValue(float position, int argb) {
        if (position < 0.0f || position > 1.0f) {
            this.logger.log(3601, Float.valueOf(position), "value", "position");
        } else {
            this.gradientMap.put(Float.valueOf(position), argb);
            if (this.lowestKey > position) {
                this.gradientMap.put(Float.valueOf(0.0f), argb);
                this.lowestKey = position;
            }
            if (this.highestKey < position) {
                this.gradientMap.put(Float.valueOf(1.0f), argb);
                this.highestKey = position;
            }
        }
    }

    public int getValue(float position) {
        if (position < 0.0f) {
            position = 0.0f;
        } else if (position > 1.0f) {
            position = 1.0f;
        }
        Map.Entry<Float, Integer> largbE = this.gradientMap.floorEntry(Float.valueOf(position));
        Map.Entry<Float, Integer> hargbE = this.gradientMap.ceilingEntry(Float.valueOf(position));
        float dist = hargbE.getKey().floatValue() - largbE.getKey().floatValue();
        float p = dist > 0.0f ? (position - largbE.getKey().floatValue()) / dist : 0.0f;
        int largb = largbE.getValue();
        int hargb = hargbE.getValue();
        int la = largb >> 24 & 0xFF;
        int ha = hargb >> 24 & 0xFF;
        int da = ha - la;
        int na = Math.round((float)da * p) + la;
        int lr = largb >> 16 & 0xFF;
        int hr = hargb >> 16 & 0xFF;
        int dr = hr - lr;
        int nr = Math.round((float)dr * p) + lr;
        int lg = largb >> 8 & 0xFF;
        int hg = hargb >> 8 & 0xFF;
        int dg = hg - lg;
        int ng = Math.round((float)dg * p) + lg;
        int lb = largb & 0xFF;
        int hb = hargb & 0xFF;
        int db = hb - lb;
        int nb = Math.round((float)db * p) + lb;
        int result = na << 24 | nr << 16 | ng << 8 | nb;
        return result;
    }
}

