/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.metrics;

import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.helpers.ProcessingException;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.imagemanipulator.area.Gaussian;
import com.neptunelabs.imagemanipulator.area.LayerBlend;
import com.neptunelabs.imagemanipulator.color.AlphaMode;
import com.neptunelabs.imagemanipulator.color.BlendMode;
import com.neptunelabs.imagemanipulator.utils.BaseImageUtils;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.nio.ByteOrder;

public final class HistogramRenderer {
    private final FSILogger logger;
    private final SwapPool swapPool;
    private final ExecutorPool executorPool;
    private final Histogram histogram;
    private boolean drawShadow = false;
    private final float alpha = 0.65f;
    private final int[] colors = new int[]{0, 0xCC3D3D, 0x3DCC3D, 0xCCCC3D, 4031948, 6409277, 4050088, 0xFFFFFF};
    private final int transColor = 0xFFFFFF;
    private final int blackColor = -16777216;
    private final int grayColor = -3618616;
    private final int shadowBorderShift = 0;

    public HistogramRenderer(FSILogger logger, SwapPool swapPool, ExecutorPool executorPool, Histogram histogram) {
        this.logger = logger;
        this.swapPool = swapPool;
        this.executorPool = executorPool;
        this.histogram = histogram;
    }

    public FSIImageLimited drawHistogram(int priority, HistogramChannel channel) {
        if (channel == HistogramChannel.HUE) {
            return this.drawHueHistogram(priority);
        }
        return this.drawColorizedHistogram(priority, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSIImageLimited drawColorizedHistogram(int priority, HistogramChannel channel) {
        int gridWidth = 256;
        int gridHeight = 100;
        int width = 256;
        int height = 100;
        FSIImage image = new FSIImageLimited(this.logger, this.swapPool, ByteOrder.LITTLE_ENDIAN, 256, 100, null, FSIImageMode.ARGB);
        FSIImage histCanvas = ((FSIImage)image).createCompatibleImage();
        histCanvas.addAlpha();
        FSIImage gridBackup = null;
        try {
            int x;
            int x2;
            int y;
            byte[] redData = new byte[256];
            byte[] greenData = new byte[256];
            byte[] blueData = new byte[256];
            byte[] lumData = new byte[256];
            byte[] satData = new byte[256];
            for (int c = 0; c < 256; ++c) {
                if (channel == HistogramChannel.LUMINOSITY) {
                    lumData[c] = (byte)Math.round(Math.sqrt(this.histogram.statisticBrightness[c] * 10000.0f));
                    continue;
                }
                if (channel == HistogramChannel.SATURATION) {
                    satData[c] = (byte)Math.round(Math.sqrt(this.histogram.statisticSaturation[c] * 10000.0f));
                    continue;
                }
                redData[c] = (byte)Math.round(Math.sqrt(this.histogram.statisticRed[c] * 10000.0f));
                greenData[c] = (byte)Math.round(Math.sqrt(this.histogram.statisticGreen[c] * 10000.0f));
                blueData[c] = (byte)Math.round(Math.sqrt(this.histogram.statisticBlue[c] * 10000.0f));
            }
            for (y = 0; y < 100; ++y) {
                for (x2 = 0; x2 < 256; ++x2) {
                    ((FSIImage)image).setSample(x2, y, 0xFFFFFF);
                }
            }
            for (y = 0; y < 100; y += 25) {
                for (x2 = 0; x2 < 256; x2 += 2) {
                    ((FSIImage)image).setSample(x2, y, -3618616);
                }
            }
            for (x = 0; x < 256; x += 2) {
                ((FSIImage)image).setSample(x, 99, -3618616);
            }
            for (x = 0; x < 256; x += 64) {
                for (int y2 = 0; y2 < 100; y2 += 2) {
                    ((FSIImage)image).setSample(x, y2, -3618616);
                }
            }
            for (y = 0; y < 100; y += 2) {
                ((FSIImage)image).setSample(255, y, -3618616);
            }
            gridBackup = ((FSIImage)image).createCopy();
            if (this.drawShadow) {
                FSIImage shadow = ((FSIImage)image).createCompatibleImage();
                shadow.addAlpha();
                int x3 = 0;
                int p = 0;
                while (x3 < 256) {
                    int ypos;
                    int y3;
                    if (channel == HistogramChannel.RGB) {
                        int y4;
                        int yposR = Math.max(0, 100 - (redData[p] & 0xFF));
                        int yposG = Math.max(0, 100 - (greenData[p] & 0xFF));
                        int yposB = Math.max(0, 100 - (blueData[p] & 0xFF));
                        for (y4 = yposR; y4 < 100; ++y4) {
                            shadow.setSample(x3, y4, -16777216);
                        }
                        for (y4 = yposG; y4 < 100; ++y4) {
                            shadow.setSample(x3, y4, -16777216);
                        }
                        for (y4 = yposB; y4 < 100; ++y4) {
                            shadow.setSample(x3, y4, -16777216);
                        }
                    } else if (channel == HistogramChannel.LUMINOSITY) {
                        for (y3 = ypos = Math.max(0, 100 - (lumData[p] & 0xFF)); y3 < 100; ++y3) {
                            shadow.setSample(x3, y3, -16777216);
                        }
                    } else if (channel == HistogramChannel.SATURATION) {
                        for (y3 = ypos = Math.max(0, 100 - (satData[p] & 0xFF)); y3 < 100; ++y3) {
                            shadow.setSample(x3, y3, -16777216);
                        }
                    } else if (channel == HistogramChannel.R || channel == HistogramChannel.RED) {
                        for (y3 = ypos = Math.max(0, 100 - (redData[p] & 0xFF)); y3 < 100; ++y3) {
                            shadow.setSample(x3, y3, -16777216);
                        }
                    } else if (channel == HistogramChannel.G || channel == HistogramChannel.GREEN) {
                        for (y3 = ypos = Math.max(0, 100 - (greenData[p] & 0xFF)); y3 < 100; ++y3) {
                            shadow.setSample(x3, y3, -16777216);
                        }
                    } else if (channel == HistogramChannel.B || channel == HistogramChannel.BLUE) {
                        for (y3 = ypos = Math.max(0, 100 - (blueData[p] & 0xFF)); y3 < 100; ++y3) {
                            shadow.setSample(x3, y3, -16777216);
                        }
                    }
                    ++x3;
                    ++p;
                }
                Gaussian blur = new Gaussian(this.logger, this.executorPool, priority);
                shadow = blur.transform(shadow, 7, 0.0f, 0, 0.0f, false);
                LayerBlend lb = new LayerBlend(this.logger, this.executorPool, priority);
                image = lb.transform(image, shadow, 2, 0, BlendMode.NORMAL, AlphaMode.NORMAL, 100.0f, false);
                shadow.dispose();
            }
            int x4 = 0;
            int p = 0;
            while (x4 < 256) {
                int yposR = redData[p] & 0xFF;
                int yposG = greenData[p] & 0xFF;
                int yposB = blueData[p] & 0xFF;
                int yposS = satData[p] & 0xFF;
                int yposL = lumData[p] & 0xFF;
                for (int h = 0; h < 100; ++h) {
                    int colorSet = 0;
                    if (channel == HistogramChannel.RGB) {
                        if (h < yposR) {
                            colorSet |= 1;
                        }
                        if (h < yposG) {
                            colorSet |= 2;
                        }
                        if (h < yposB) {
                            colorSet |= 4;
                        }
                    } else if (channel == HistogramChannel.LUMINOSITY) {
                        if (h < yposL) {
                            colorSet = 7;
                        }
                    } else if (channel == HistogramChannel.SATURATION) {
                        if (h < yposS) {
                            colorSet = 7;
                        }
                    } else if (channel == HistogramChannel.R || channel == HistogramChannel.RED) {
                        if (h < yposR) {
                            colorSet = 1;
                        }
                    } else if (channel == HistogramChannel.G || channel == HistogramChannel.GREEN) {
                        if (h < yposG) {
                            colorSet = 2;
                        }
                    } else if ((channel == HistogramChannel.B || channel == HistogramChannel.BLUE) && h < yposB) {
                        colorSet = 4;
                    }
                    if (colorSet <= 0) continue;
                    int cColor = gridBackup.getSample(x4, 99 - h);
                    int nColor = HistogramRenderer.mixColor(cColor, this.colors[colorSet], 0.65f);
                    histCanvas.setSample(x4, 99 - h, nColor);
                }
                ++x4;
                ++p;
            }
            LayerBlend lb1 = new LayerBlend(this.logger, this.executorPool, priority);
            image = lb1.transform(image, histCanvas, 0, 0, BlendMode.NORMAL, AlphaMode.NORMAL, 100.0f, false);
        }
        catch (ProcessingException e) {
            if (image != null) {
                ((FSIImage)image).dispose();
            }
        }
        finally {
            if (gridBackup != null) {
                gridBackup.dispose();
            }
            histCanvas.dispose();
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSIImageLimited drawHueHistogram(int priority) {
        int gridWidth = 360;
        int statHeight = 299;
        int gridHeight = 300;
        int width = 360;
        int height = 300;
        FSIImage image = new FSIImageLimited(this.logger, this.swapPool, ByteOrder.LITTLE_ENDIAN, 360, 300, null, FSIImageMode.ARGB);
        FSIImage histCanvas = ((FSIImage)image).createCompatibleImage();
        histCanvas.addAlpha();
        FSIImage gridBackup = null;
        try {
            int x;
            int x2;
            int y;
            int[] sData = new int[360];
            double hMax = 0.0;
            for (int c = 0; c < 360; ++c) {
                hMax = Math.max(hMax, (double)this.histogram.statisticHue[c]);
            }
            double multi = 1.0 / hMax;
            double maxMulti = 89401.0;
            for (int c = 0; c < 360; ++c) {
                sData[c] = (int)Math.round(Math.sqrt((double)this.histogram.statisticHue[c] * multi * 89401.0));
            }
            for (y = 0; y < 300; ++y) {
                for (x2 = 0; x2 < 360; ++x2) {
                    ((FSIImage)image).setSample(x2, y, 0xFFFFFF);
                }
            }
            for (y = 0; y < 300; y += 75) {
                for (x2 = 0; x2 < 360; x2 += 2) {
                    ((FSIImage)image).setSample(x2, y, -3618616);
                }
            }
            for (x = 0; x < 360; x += 2) {
                ((FSIImage)image).setSample(x, 299, -3618616);
            }
            for (x = 0; x < 360; x += 45) {
                for (int y2 = 0; y2 < 300; y2 += 2) {
                    ((FSIImage)image).setSample(x, y2, -3618616);
                }
            }
            for (y = 0; y < 300; y += 2) {
                ((FSIImage)image).setSample(359, y, -3618616);
            }
            gridBackup = ((FSIImage)image).createCopy();
            if (this.drawShadow) {
                FSIImage shadow = ((FSIImage)image).createCompatibleImage();
                shadow.addAlpha();
                int x3 = 0;
                int p = 0;
                while (x3 < 360) {
                    int yposS;
                    for (int y3 = yposS = Math.max(0, 300 - sData[p]); y3 < 300; ++y3) {
                        shadow.setSample(x3, y3, -16777216);
                    }
                    ++x3;
                    ++p;
                }
                Gaussian blur = new Gaussian(this.logger, this.executorPool, priority);
                shadow = blur.transform(shadow, 7, 0.0f, 0, 0.0f, false);
                LayerBlend lb1 = new LayerBlend(this.logger, this.executorPool, priority);
                image = lb1.transform(image, shadow, 2, 0, BlendMode.NORMAL, AlphaMode.NORMAL, 100.0f, false);
                shadow.dispose();
            }
            int x4 = 0;
            int p = 0;
            while (x4 < 360) {
                int yposS = sData[p];
                int rColor = BaseImageUtils.floatRgbToIntRgb(BaseImageUtils.hslToRgb((float)p / 360.0f, 1.0f, 0.5f));
                for (int h = 0; h < 300; ++h) {
                    int colorSet = 0;
                    if (h < yposS) {
                        colorSet |= 1;
                    }
                    if (colorSet <= 0) continue;
                    int cColor = gridBackup.getSample(x4, 299 - h);
                    int nColor = HistogramRenderer.mixColor(cColor, rColor, 0.65f);
                    histCanvas.setSample(x4, 299 - h, nColor);
                }
                ++x4;
                ++p;
            }
            LayerBlend lb2 = new LayerBlend(this.logger, this.executorPool, priority);
            image = lb2.transform(image, histCanvas, 0, 0, BlendMode.NORMAL, AlphaMode.NORMAL, 100.0f, false);
        }
        catch (ProcessingException e) {
            if (image != null) {
                ((FSIImage)image).dispose();
            }
        }
        finally {
            if (gridBackup != null) {
                gridBackup.dispose();
            }
            histCanvas.dispose();
        }
        return image;
    }

    private static int mixColor(int col1, int col2, float a) {
        int r1 = col1 >> 16 & 0xFF;
        int g1 = col1 >> 8 & 0xFF;
        int b1 = col1 & 0xFF;
        int r2 = col2 >> 16 & 0xFF;
        int g2 = col2 >> 8 & 0xFF;
        int b2 = col2 & 0xFF;
        int r3 = (int)((1.0f - a) * (float)r1 + a * (float)r2);
        int g3 = (int)((1.0f - a) * (float)g1 + a * (float)g2);
        int b3 = (int)((1.0f - a) * (float)b1 + a * (float)b2);
        return 0xFF000000 | r3 << 16 | g3 << 8 | b3;
    }

    public static enum HistogramChannel {
        R,
        G,
        B,
        RED,
        GREEN,
        BLUE,
        RGB,
        HUE,
        SATURATION,
        LUMINOSITY;

    }
}

