/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.palette;

import java.util.ArrayList;
import java.util.Arrays;

public abstract class Palette {
    protected boolean alpha;
    protected int alphaIndex = -1;
    private int alphaR;
    private int alphaG;
    private int alphaB;
    protected int[] palette;
    protected int colors;
    protected int[] cacheRGB = new int[262144];

    Palette() {
    }

    public abstract Palette clone();

    public void setPalette(byte[] value, boolean alpha, int alphaColor) {
        int rawPalLen = value.length / 3;
        int[] rawPalette = new int[rawPalLen];
        int i = 0;
        int c = 0;
        while (i < rawPalLen) {
            rawPalette[i] = (value[c] & 0xFF) << 16 | (value[c + 1] & 0xFF) << 8 | value[c + 2] & 0xFF;
            ++i;
            c += 3;
        }
        Arrays.sort(rawPalette);
        ArrayList<Integer> sList = new ArrayList<Integer>();
        int oValue = 0;
        for (int i2 = 0; i2 < rawPalette.length; ++i2) {
            if (i2 > 0 && oValue == rawPalette[i2]) continue;
            sList.add(rawPalette[i2]);
            oValue = rawPalette[i2];
        }
        if (alpha) {
            sList.add(alphaColor);
        }
        this.colors = sList.size();
        this.palette = new int[sList.size() * 3];
        int c2 = 0;
        int p = 0;
        while (c2 < this.colors) {
            int rgb = (Integer)sList.get(c2);
            this.palette[p] = rgb >> 16 & 0xFF;
            this.palette[p + 1] = rgb >> 8 & 0xFF;
            this.palette[p + 2] = rgb & 0xFF;
            ++c2;
            p += 3;
        }
        this.alpha = alpha;
        if (alpha) {
            --this.colors;
            this.alphaIndex = this.colorCount() - 1;
            this.alphaR = alphaColor >> 16 & 0xFF;
            this.alphaG = alphaColor >> 16 & 0xFF;
            this.alphaB = alphaColor & 0xFF;
        }
    }

    public int colorCount() {
        return this.palette.length / 3;
    }

    public byte[] getPalette() {
        int len = this.colorCount();
        byte[] result = new byte[len * 3];
        for (int i = 0; i < this.palette.length; ++i) {
            result[i] = (byte)(this.palette[i] & 0xFF);
        }
        return result;
    }

    public int[] getColor(int index) {
        if (this.alpha && index == this.alphaIndex) {
            return new int[]{this.alphaR, this.alphaG, this.alphaB};
        }
        int p = index * 3;
        return new int[]{this.palette[p], this.palette[p + 1], this.palette[p + 2]};
    }

    public boolean hasAlpha() {
        return this.alpha;
    }

    public int getTransparentIndex() {
        return this.alphaIndex;
    }

    public abstract int findColorIndex(int var1);

    public int findColor(int argb) {
        int index = this.findColorIndex(argb);
        int result = this.palette[index * 3] << 16 | this.palette[index * 3 + 1] << 8 | this.palette[index * 3 + 2];
        return result;
    }

    public void dumpPalette() {
        System.out.println("---------------------");
        System.out.println("Palette " + this);
        int c = 0;
        int p = 0;
        while (c < this.palette.length) {
            int argbDest = this.palette[c] << 16 | this.palette[c + 1] << 8 | this.palette[c + 2];
            System.out.println("C:" + p + " = " + (this.palette[c] & 0xFF) + " " + (this.palette[c + 1] & 0xFF) + " " + (this.palette[c + 2] & 0xFF) + " = " + Integer.toHexString(argbDest));
            c += 3;
            ++p;
        }
        System.out.println("Palette contains alpha:" + this.alpha + " Index:" + this.alphaIndex);
    }
}

