/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.palette;

import com.neptunelabs.imagemanipulator.palette.Palette;

public class PaletteEuclideanSquareRGB
extends Palette {
    private int lastARGB;
    private int lastIndex;

    public static Palette getInstance() {
        return new PaletteEuclideanSquareRGB();
    }

    @Override
    public Palette clone() {
        Palette palNew = PaletteEuclideanSquareRGB.getInstance();
        palNew.alpha = this.alpha;
        palNew.alphaIndex = this.alphaIndex;
        palNew.palette = this.palette;
        palNew.colors = this.colors;
        return palNew;
    }

    private PaletteEuclideanSquareRGB() {
    }

    @Override
    public int findColorIndex(int argb) {
        if (this.alpha && (argb >> 24 & 0xFF) == 0) {
            return this.alphaIndex;
        }
        if (argb == this.lastARGB) {
            return this.lastIndex;
        }
        int sr = argb >> 16 & 0xFF;
        int sg = argb >> 8 & 0xFF;
        int sb = argb & 0xFF;
        int cacheKey = (argb & 0x3F0000) >> 4 | (argb & 0x3F00) >> 2 | argb & 0x3F;
        if (this.cacheRGB[cacheKey] != 0 && (this.cacheRGB[cacheKey] & 0xFFFFFF) == (argb & 0xFFFFFF)) {
            return this.cacheRGB[cacheKey] >>> 24;
        }
        int index = -1;
        int shortestDist = Integer.MAX_VALUE;
        int c = 0;
        for (int p = 0; p < this.colors; ++p) {
            int b2;
            int g2;
            int r2 = this.palette[c];
            int dist = (sr - r2) * (sr - r2);
            if (dist <= shortestDist && (dist += (sg - (g2 = this.palette[c + 1])) * (sg - g2)) <= shortestDist && (dist += (sb - (b2 = this.palette[c + 2])) * (sb - b2)) <= shortestDist) {
                if (dist == 0) {
                    index = c / 3;
                    break;
                }
                if (dist < shortestDist) {
                    shortestDist = dist;
                    index = c / 3;
                }
            }
            c += 3;
        }
        this.lastARGB = argb;
        this.lastIndex = index;
        this.cacheRGB[cacheKey] = index << 24 | argb & 0xFFFFFF;
        return index;
    }
}

