/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.quantizer;

import com.neptunelabs.imagemanipulator.quantizer.ExpandableArray;
import com.neptunelabs.imagemanipulator.quantizer.OctreeNode;
import com.neptunelabs.imagemanipulator.quantizer.Quantizer;
import com.neptunelabs.imagereader.image.FSIImage;

public final class ColorOctree
extends Quantizer {
    protected static final int MAXLEV = 16;
    int leaf_level;
    OctreeNode tree;
    ExpandableArray[] reduce;
    int numLeaves;
    int cacheCount;
    public ExpandableArray cachedONodes;
    public static final int MAXCACHE = 25;
    boolean caching;

    public ColorOctree(int maxColors, boolean hasAlpha, int sampleDepth) {
        super(maxColors, hasAlpha, sampleDepth);
        this.init();
    }

    private void init() {
        this.numLeaves = 0;
        this.cacheCount = 0;
        this.leaf_level = 16;
        this.reduce = new ExpandableArray[16];
        for (int i = 0; i < 16; ++i) {
            this.reduce[i] = new ExpandableArray(10, 10);
        }
        this.cachedONodes = new ExpandableArray(10);
        this.tree = new OctreeNode(this);
    }

    @Override
    public void addImageData(FSIImage src) {
        int sampleCount = (int)src.getIntSize();
        for (int i = 0; i < sampleCount; i += this.sampleDepth) {
            int color = src.getSample(i);
            int a = color >> 24 & 0xFF;
            if (a <= 0 && this.hasAlpha) continue;
            this.numLeaves += this.tree.insertColor(color, this.leaf_level);
            if (this.numLeaves <= this.maxColors) continue;
            this.reduceColors();
        }
    }

    @Override
    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    private void reduceColors() {
        this.caching = true;
        OctreeNode on = this.getReducible();
        this.numLeaves -= on.collapseOctree();
        on.leaf = true;
        ++this.numLeaves;
        if (on.level < this.leaf_level - 1) {
            this.leaf_level = on.level + 1;
        }
    }

    @Override
    public byte[] getPalette() {
        byte[] buf = new byte[1024];
        int size = this.tree.createPalette(buf, 0) / 3;
        size = Math.min(size, this.maxColors);
        byte[] result = new byte[size * 3];
        int bufidx = 0;
        int pidx = 0;
        while (bufidx < size * 3) {
            result[pidx++] = buf[bufidx++];
            result[pidx++] = buf[bufidx++];
            result[pidx++] = buf[bufidx++];
        }
        return result;
    }

    protected void markReducible(OctreeNode on) {
        on.marked = true;
        this.reduce[on.level].addElement(on);
    }

    private OctreeNode getReducible() {
        OctreeNode onLargest = null;
        int i = this.leaf_level - 1;
        while (this.reduce[i].size() == 0) {
            --i;
        }
        ExpandableArray v = this.reduce[i];
        int vSize = v.size();
        if (vSize > 0) {
            int largestIndex = 0;
            onLargest = (OctreeNode)v.elementAt(0);
            for (int j = 1; j < vSize; ++j) {
                OctreeNode on = (OctreeNode)v.elementAt(j);
                if (on.count < onLargest.count) continue;
                onLargest = on;
                largestIndex = j;
            }
            v.removeElementAt(largestIndex);
        }
        return onLargest;
    }

    protected OctreeNode getONode(ColorOctree oc, int level) {
        OctreeNode on;
        if (this.cacheCount > 0) {
            on = (OctreeNode)this.cachedONodes.lastElement();
            this.cachedONodes.removeElementAt(this.cacheCount - 1);
            --this.cacheCount;
            on.setFields(oc, level);
        } else {
            on = new OctreeNode(oc, level);
        }
        return on;
    }

    protected void cacheONode(OctreeNode on) {
        int n = on.level;
        OctreeNode.levCounts[n] = OctreeNode.levCounts[n] - 1;
        if (this.caching && this.cacheCount < 25) {
            this.cachedONodes.addElement(on);
            ++this.cacheCount;
        }
    }
}

