/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.quantizer;

import com.neptunelabs.imagemanipulator.quantizer.Quantizer;
import com.neptunelabs.imagereader.image.FSIImage;

public class NeuQuant
extends Quantizer {
    private final int netsize;
    private final int initrad;
    private final int maxnetpos;
    private final int initradius;
    private final int[] bias;
    private final int[] freq;
    private final int[] radpower;
    private static final int prime1 = 499;
    private static final int prime2 = 491;
    private static final int prime3 = 487;
    private static final int prime4 = 503;
    private static final int minpicturebytes = 1509;
    private static final int netbiasshift = 4;
    private static final int ncycles = 100;
    private static final int intbiasshift = 16;
    private static final int intbias = 65536;
    private static final int gammashift = 10;
    private static final int betashift = 10;
    private static final int beta = 64;
    private static final int betagamma = 65536;
    private static final int radiusbiasshift = 6;
    private static final int radiusbias = 64;
    private static final int radiusdec = 30;
    private static final int alphabiasshift = 10;
    private static final int initalpha = 1024;
    private int alphadec;
    private static final int radbiasshift = 8;
    private static final int radbias = 256;
    private static final int alpharadbshift = 18;
    private static final int alpharadbias = 262144;
    private int[][] network;
    private int[] netindex = new int[256];

    public NeuQuant(int maxColorsValue, boolean hasAlpha, int sampleDepth) {
        super(maxColorsValue, hasAlpha, sampleDepth);
        this.netsize = this.maxColors;
        this.initrad = this.netsize >> 3;
        this.maxnetpos = this.netsize - 1;
        this.initradius = this.initrad * 64;
        this.bias = new int[this.netsize];
        this.freq = new int[this.netsize];
        this.radpower = new int[this.initrad];
        this.init();
    }

    @Override
    public void addImageData(FSIImage src) {
        this.learn(src);
    }

    @Override
    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    @Override
    public byte[] getPalette() {
        this.unbiasnet();
        this.inxbuild();
        byte[] map = new byte[3 * this.netsize];
        int[] index = new int[this.netsize];
        for (int i = 0; i < this.netsize; ++i) {
            index[this.network[i][3]] = i;
        }
        int k = 0;
        for (int i = 0; i < this.netsize; ++i) {
            int j = index[i];
            map[k++] = (byte)this.network[j][0];
            map[k++] = (byte)this.network[j][1];
            map[k++] = (byte)this.network[j][2];
        }
        return map;
    }

    private void init() {
        this.network = new int[this.netsize][];
        for (int i = 0; i < this.netsize; ++i) {
            this.network[i] = new int[4];
            int[] p = this.network[i];
            p[1] = p[2] = (i << 12) / this.netsize;
            p[0] = p[2];
            this.freq[i] = 65536 / this.netsize;
            this.bias[i] = 0;
        }
    }

    private void inxbuild() {
        int j;
        int previouscol = 0;
        int startpos = 0;
        for (int i = 0; i < this.netsize; ++i) {
            int[] q;
            int[] p = this.network[i];
            int smallpos = i;
            int smallval = p[1];
            for (j = i + 1; j < this.netsize; ++j) {
                q = this.network[j];
                if (q[1] >= smallval) continue;
                smallpos = j;
                smallval = q[1];
            }
            q = this.network[smallpos];
            if (i != smallpos) {
                j = q[0];
                q[0] = p[0];
                p[0] = j;
                j = q[1];
                q[1] = p[1];
                p[1] = j;
                j = q[2];
                q[2] = p[2];
                p[2] = j;
                j = q[3];
                q[3] = p[3];
                p[3] = j;
            }
            if (smallval == previouscol) continue;
            this.netindex[previouscol] = startpos + i >> 1;
            for (j = previouscol + 1; j < smallval; ++j) {
                this.netindex[j] = i;
            }
            previouscol = smallval;
            startpos = i;
        }
        this.netindex[previouscol] = startpos + this.maxnetpos >> 1;
        for (j = previouscol + 1; j < 256; ++j) {
            this.netindex[j] = this.maxnetpos;
        }
    }

    private void learn(FSIImage src) {
        int i;
        int lengthcount = (int)src.getIntSize();
        boolean samplesPerPixel = true;
        int localSampleDepth = this.sampleDepth;
        if (lengthcount < 1509) {
            localSampleDepth = 1;
        }
        this.alphadec = 30 + (localSampleDepth - 1) / 1;
        int pix = 0;
        int lim = lengthcount;
        int samplepixels = lengthcount / (1 * localSampleDepth);
        int delta = samplepixels / 100;
        int alpha = 1024;
        int radius = this.initradius;
        int rad = radius >> 6;
        if (rad <= 1) {
            rad = 0;
        }
        for (i = 0; i < rad; ++i) {
            this.radpower[i] = alpha * ((rad * rad - i * i) * 256 / (rad * rad));
        }
        int step = lengthcount < 1509 ? 1 : (lengthcount % 499 != 0 ? 499 : (lengthcount % 491 != 0 ? 491 : (lengthcount % 487 != 0 ? 487 : 503)));
        i = 0;
        while (i < samplepixels) {
            int argb = src.getSample(pix);
            int b = (argb >> 16 & 0xFF) << 4;
            int g = (argb >> 8 & 0xFF) << 4;
            int r = (argb & 0xFF) << 4;
            int j = this.contest(b, g, r);
            this.altersingle(alpha, j, b, g, r);
            if (rad != 0) {
                this.alterneigh(rad, j, b, g, r);
            }
            if ((pix += step) >= lim) {
                pix -= lengthcount;
            }
            ++i;
            if (delta == 0) {
                delta = 1;
            }
            if (i % delta != 0) continue;
            alpha -= alpha / this.alphadec;
            if ((rad = (radius -= radius / 30) >> 6) <= 1) {
                rad = 0;
            }
            for (j = 0; j < rad; ++j) {
                this.radpower[j] = alpha * ((rad * rad - j * j) * 256 / (rad * rad));
            }
        }
    }

    private void unbiasnet() {
        for (int i = 0; i < this.netsize; ++i) {
            int[] nArray = this.network[i];
            nArray[0] = nArray[0] >> 4;
            int[] nArray2 = this.network[i];
            nArray2[1] = nArray2[1] >> 4;
            int[] nArray3 = this.network[i];
            nArray3[2] = nArray3[2] >> 4;
            this.network[i][3] = i;
        }
    }

    private void alterneigh(int rad, int i, int b, int g, int r) {
        int hi;
        int lo = i - rad;
        if (lo < -1) {
            lo = -1;
        }
        if ((hi = i + rad) > this.netsize) {
            hi = this.netsize;
        }
        int j = i + 1;
        int k = i - 1;
        int m = 1;
        while (j < hi || k > lo) {
            int[] p;
            int a = this.radpower[m++];
            if (j < hi) {
                p = this.network[j++];
                try {
                    p[0] = p[0] - a * (p[0] - b) / 262144;
                    p[1] = p[1] - a * (p[1] - g) / 262144;
                    p[2] = p[2] - a * (p[2] - r) / 262144;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (k <= lo) continue;
            p = this.network[k--];
            try {
                p[0] = p[0] - a * (p[0] - b) / 262144;
                p[1] = p[1] - a * (p[1] - g) / 262144;
                p[2] = p[2] - a * (p[2] - r) / 262144;
            }
            catch (Exception exception) {}
        }
    }

    private void altersingle(int alpha, int i, int b, int g, int r) {
        int[] n = this.network[i];
        n[0] = n[0] - alpha * (n[0] - b) / 1024;
        n[1] = n[1] - alpha * (n[1] - g) / 1024;
        n[2] = n[2] - alpha * (n[2] - r) / 1024;
    }

    private int contest(int b, int g, int r) {
        int bestpos;
        int bestd;
        int bestbiasd = bestd = Integer.MAX_VALUE;
        int bestbiaspos = bestpos = -1;
        int i = 0;
        while (i < this.netsize) {
            int biasdist;
            int a;
            int[] n = this.network[i];
            int dist = n[0] - b;
            if (dist < 0) {
                dist = -dist;
            }
            if ((a = n[1] - g) < 0) {
                a = -a;
            }
            dist += a;
            a = n[2] - r;
            if (a < 0) {
                a = -a;
            }
            if ((dist += a) < bestd) {
                bestd = dist;
                bestpos = i;
            }
            if ((biasdist = dist - (this.bias[i] >> 12)) < bestbiasd) {
                bestbiasd = biasdist;
                bestbiaspos = i;
            }
            int betafreq = this.freq[i] >> 10;
            int n2 = i;
            this.freq[n2] = this.freq[n2] - betafreq;
            int n3 = i++;
            this.bias[n3] = this.bias[n3] + (betafreq << 10);
        }
        int n = bestpos;
        this.freq[n] = this.freq[n] + 64;
        int n4 = bestpos;
        this.bias[n4] = this.bias[n4] - 65536;
        return bestbiaspos;
    }
}

