/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.quantizer;

import com.neptunelabs.imagemanipulator.quantizer.ColorOctree;

class OctreeNode {
    static boolean debug;
    static int[] levCounts;
    public static int numNodes;
    boolean leaf;
    boolean marked;
    long sumR;
    long sumG;
    long sumB;
    int count;
    OctreeNode r0g0b0;
    OctreeNode r0g0b1;
    OctreeNode r0g1b0;
    OctreeNode r0g1b1;
    OctreeNode r1g0b0;
    OctreeNode r1g0b1;
    OctreeNode r1g1b0;
    OctreeNode r1g1b1;
    int childCount;
    int level;
    int redMask;
    int greenMask;
    int blueMask;
    int pIndex;
    ColorOctree oc;

    public String toString() {
        String str = "l " + this.leaf;
        str = str + " m " + this.marked;
        str = str + " count " + this.count;
        str = str + " childCount " + this.childCount;
        str = str + " level " + this.level;
        if (this.r0g0b0 != null) {
            str = str + " r0g0b0 ";
        }
        if (this.r0g0b1 != null) {
            str = str + " r0g0b1 ";
        }
        if (this.r0g1b0 != null) {
            str = str + " r0g1b0 ";
        }
        if (this.r0g1b1 != null) {
            str = str + " r0g1b1 ";
        }
        if (this.r1g0b0 != null) {
            str = str + " r1g0b0 ";
        }
        if (this.r1g0b1 != null) {
            str = str + " r1g0b1 ";
        }
        if (this.r1g1b0 != null) {
            str = str + " r1g1b0 ";
        }
        if (this.r1g1b1 != null) {
            str = str + " r1g1b1 ";
        }
        return str;
    }

    public void dump(String pre) {
        System.out.println(pre + "[" + this.level + "]" + this.toString());
        if (this.r1g1b1 != null) {
            this.r1g1b1.dump(pre + "111 ");
        }
        if (this.r1g1b0 != null) {
            this.r1g1b0.dump(pre + "110 ");
        }
        if (this.r1g0b1 != null) {
            this.r1g0b1.dump(pre + "101 ");
        }
        if (this.r1g0b0 != null) {
            this.r1g0b0.dump(pre + "100 ");
        }
        if (this.r0g1b1 != null) {
            this.r0g1b1.dump(pre + "011 ");
        }
        if (this.r0g1b0 != null) {
            this.r0g1b0.dump(pre + "010 ");
        }
        if (this.r0g0b1 != null) {
            this.r0g0b1.dump(pre + "001 ");
        }
        if (this.r0g0b0 != null) {
            this.r0g0b0.dump(pre + "000 ");
        }
    }

    OctreeNode(ColorOctree oc) {
        this(oc, 0);
    }

    OctreeNode(ColorOctree oc, int level) {
        ++numNodes;
        this.setFields(oc, level);
    }

    protected void setFields(ColorOctree oc, int level) {
        this.count = 0;
        this.sumR = 0L;
        this.sumG = 0L;
        this.sumB = 0L;
        this.level = level;
        this.pIndex = -1;
        this.childCount = 0;
        this.leaf = false;
        this.marked = false;
        this.r1g1b1 = null;
        this.r1g1b0 = null;
        this.r1g0b1 = null;
        this.r1g0b0 = null;
        this.r0g1b1 = null;
        this.r0g1b0 = null;
        this.r0g0b1 = null;
        this.r0g0b0 = null;
        if (level != 16) {
            this.blueMask = 128 >> level;
            this.greenMask = this.blueMask << 8;
            this.redMask = this.greenMask << 8;
        }
        this.oc = oc;
        int n = level;
        levCounts[n] = levCounts[n] + 1;
    }

    private OctreeNode findChild(int color) {
        if (this.childCount == 0) {
            return this;
        }
        int rb = color & this.redMask;
        int gb = color & this.greenMask;
        int bb = color & this.blueMask;
        if (rb == 0) {
            if (gb == 0) {
                if (bb == 0) {
                    if (this.r0g0b0 != null) {
                        return this.r0g0b0.findChild(color);
                    }
                    return this;
                }
                if (this.r0g0b1 != null) {
                    return this.r0g0b1.findChild(color);
                }
                return this;
            }
            if (bb == 0) {
                if (this.r0g1b0 != null) {
                    return this.r0g1b0.findChild(color);
                }
                return this;
            }
            if (this.r0g1b1 != null) {
                return this.r0g1b1.findChild(color);
            }
            return this;
        }
        if (gb == 0) {
            if (bb == 0) {
                if (this.r1g0b0 != null) {
                    return this.r1g0b0.findChild(color);
                }
                return this;
            }
            if (this.r1g0b1 != null) {
                return this.r1g0b1.findChild(color);
            }
            return this;
        }
        if (bb == 0) {
            if (this.r1g1b0 != null) {
                return this.r1g1b0.findChild(color);
            }
            return this;
        }
        if (this.r1g1b1 != null) {
            return this.r1g1b1.findChild(color);
        }
        return this;
    }

    protected int insertColor(int color, int leaf_level) {
        int leafCount = 0;
        int nextLev = this.level + 1;
        ++this.count;
        this.sumR += (long)((color & 0xFF0000) >> 16);
        this.sumG += (long)((color & 0xFF00) >> 8);
        this.sumB += (long)(color & 0xFF);
        if (!this.leaf) {
            int rb = color & this.redMask;
            int gb = color & this.greenMask;
            int bb = color & this.blueMask;
            if (rb == 0) {
                if (gb == 0) {
                    if (bb == 0) {
                        if (this.r0g0b0 == null) {
                            this.r0g0b0 = this.oc.getONode(this.oc, nextLev);
                            if (nextLev >= leaf_level) {
                                this.r0g0b0.leaf = true;
                                ++leafCount;
                            }
                            ++this.childCount;
                        }
                        leafCount += this.r0g0b0.insertColor(color, leaf_level);
                    } else {
                        if (this.r0g0b1 == null) {
                            this.r0g0b1 = this.oc.getONode(this.oc, nextLev);
                            if (nextLev >= leaf_level) {
                                this.r0g0b1.leaf = true;
                                ++leafCount;
                            }
                            ++this.childCount;
                        }
                        leafCount += this.r0g0b1.insertColor(color, leaf_level);
                    }
                } else if (bb == 0) {
                    if (this.r0g1b0 == null) {
                        this.r0g1b0 = this.oc.getONode(this.oc, nextLev);
                        if (nextLev >= leaf_level) {
                            this.r0g1b0.leaf = true;
                            ++leafCount;
                        }
                        ++this.childCount;
                    }
                    leafCount += this.r0g1b0.insertColor(color, leaf_level);
                } else {
                    if (this.r0g1b1 == null) {
                        this.r0g1b1 = this.oc.getONode(this.oc, nextLev);
                        if (nextLev >= leaf_level) {
                            this.r0g1b1.leaf = true;
                            ++leafCount;
                        }
                        ++this.childCount;
                    }
                    leafCount += this.r0g1b1.insertColor(color, leaf_level);
                }
            } else if (gb == 0) {
                if (bb == 0) {
                    if (this.r1g0b0 == null) {
                        this.r1g0b0 = this.oc.getONode(this.oc, nextLev);
                        if (nextLev >= leaf_level) {
                            this.r1g0b0.leaf = true;
                            ++leafCount;
                        }
                        ++this.childCount;
                    }
                    leafCount += this.r1g0b0.insertColor(color, leaf_level);
                } else {
                    if (this.r1g0b1 == null) {
                        this.r1g0b1 = this.oc.getONode(this.oc, nextLev);
                        if (nextLev >= leaf_level) {
                            this.r1g0b1.leaf = true;
                            ++leafCount;
                        }
                        ++this.childCount;
                    }
                    leafCount += this.r1g0b1.insertColor(color, leaf_level);
                }
            } else if (bb == 0) {
                if (this.r1g1b0 == null) {
                    this.r1g1b0 = this.oc.getONode(this.oc, nextLev);
                    if (nextLev >= leaf_level) {
                        this.r1g1b0.leaf = true;
                        ++leafCount;
                    }
                    ++this.childCount;
                }
                leafCount += this.r1g1b0.insertColor(color, leaf_level);
            } else {
                if (this.r1g1b1 == null) {
                    this.r1g1b1 = this.oc.getONode(this.oc, nextLev);
                    if (nextLev >= leaf_level) {
                        this.r1g1b1.leaf = true;
                        ++leafCount;
                    }
                    ++this.childCount;
                }
                leafCount += this.r1g1b1.insertColor(color, leaf_level);
            }
            if (this.childCount > 1 && !this.marked) {
                this.oc.markReducible(this);
            }
        }
        return leafCount;
    }

    protected int collapseOctree() {
        int leavesCollapsed = 0;
        if (this.childCount == 0) {
            return 0;
        }
        if (this.r0g0b0 != null) {
            if (this.r0g0b0.leaf) {
                ++leavesCollapsed;
            }
            leavesCollapsed += this.r0g0b0.collapseOctree();
            this.oc.cacheONode(this.r0g0b0);
        }
        if (this.r0g0b1 != null) {
            if (this.r0g0b1.leaf) {
                ++leavesCollapsed;
            }
            leavesCollapsed += this.r0g0b1.collapseOctree();
            this.oc.cacheONode(this.r0g0b1);
        }
        if (this.r0g1b0 != null) {
            if (this.r0g1b0.leaf) {
                ++leavesCollapsed;
            }
            leavesCollapsed += this.r0g1b0.collapseOctree();
            this.oc.cacheONode(this.r0g1b0);
        }
        if (this.r0g1b1 != null) {
            if (this.r0g1b1.leaf) {
                ++leavesCollapsed;
            }
            leavesCollapsed += this.r0g1b1.collapseOctree();
            this.oc.cacheONode(this.r0g1b1);
        }
        if (this.r1g0b0 != null) {
            if (this.r1g0b0.leaf) {
                ++leavesCollapsed;
            }
            leavesCollapsed += this.r1g0b0.collapseOctree();
            this.oc.cacheONode(this.r1g0b0);
        }
        if (this.r1g0b1 != null) {
            if (this.r1g0b1.leaf) {
                ++leavesCollapsed;
            }
            leavesCollapsed += this.r1g0b1.collapseOctree();
            this.oc.cacheONode(this.r1g0b1);
        }
        if (this.r1g1b0 != null) {
            if (this.r1g1b0.leaf) {
                ++leavesCollapsed;
            }
            leavesCollapsed += this.r1g1b0.collapseOctree();
            this.oc.cacheONode(this.r1g1b0);
        }
        if (this.r1g1b1 != null) {
            if (this.r1g1b1.leaf) {
                ++leavesCollapsed;
            }
            leavesCollapsed += this.r1g1b1.collapseOctree();
            this.oc.cacheONode(this.r1g1b1);
        }
        this.r0g0b0 = null;
        this.r0g0b1 = null;
        this.r0g1b0 = null;
        this.r0g1b1 = null;
        this.r1g0b0 = null;
        this.r1g0b1 = null;
        this.r1g1b0 = null;
        this.r1g1b1 = null;
        this.childCount = 0;
        return leavesCollapsed;
    }

    protected int createPalette(byte[] p, int base) {
        int entryCount = 0;
        if (this.leaf) {
            p[base] = (byte)(this.sumR / (long)this.count);
            p[base + 1] = (byte)(this.sumG / (long)this.count);
            p[base + 2] = (byte)(this.sumB / (long)this.count);
            this.pIndex = base;
            entryCount += 3;
        }
        if (this.childCount > 0) {
            if (this.r0g0b0 != null) {
                entryCount += this.r0g0b0.createPalette(p, base + entryCount);
            }
            if (this.r0g0b1 != null) {
                entryCount += this.r0g0b1.createPalette(p, base + entryCount);
            }
            if (this.r0g1b0 != null) {
                entryCount += this.r0g1b0.createPalette(p, base + entryCount);
            }
            if (this.r0g1b1 != null) {
                entryCount += this.r0g1b1.createPalette(p, base + entryCount);
            }
            if (this.r1g0b0 != null) {
                entryCount += this.r1g0b0.createPalette(p, base + entryCount);
            }
            if (this.r1g0b1 != null) {
                entryCount += this.r1g0b1.createPalette(p, base + entryCount);
            }
            if (this.r1g1b0 != null) {
                entryCount += this.r1g1b0.createPalette(p, base + entryCount);
            }
            if (this.r1g1b1 != null) {
                entryCount += this.r1g1b1.createPalette(p, base + entryCount);
            }
        }
        return entryCount;
    }

    static {
        levCounts = new int[17];
        for (int i = 0; i < 17; ++i) {
            OctreeNode.levCounts[i] = 0;
        }
        numNodes = 0;
    }
}

