/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.utils;

import com.neptunelabs.imagereader.converter.FastMath;

public final class BaseImageUtils {
    protected BaseImageUtils() {
    }

    public static final float clamp(float v) {
        if (v < 0.0f) {
            return 0.0f;
        }
        if (v > 1.0f) {
            return 1.0f;
        }
        return v;
    }

    public static final double clamp(double v) {
        if (v < 0.0) {
            return 0.0;
        }
        if (v > 1.0) {
            return 1.0;
        }
        return v;
    }

    public static final int clampFT255(double x) {
        if (x < 0.0) {
            return 0;
        }
        if (x > 255.0) {
            return 255;
        }
        return (int)(x + 0.5);
    }

    public static final int clampFT(float x, int l, int h) {
        if (x < (float)l) {
            return 0;
        }
        if (x > (float)h) {
            return 255;
        }
        return (int)(x + 0.5f);
    }

    public static final int clampFT255(float x) {
        if (x < 0.0f) {
            return 0;
        }
        if (x > 255.0f) {
            return 255;
        }
        return (int)(x + 0.5f);
    }

    public static final int clampFT(int x, int l, int h) {
        if (x < l) {
            return 0;
        }
        if (x > h) {
            return 255;
        }
        return x;
    }

    public static final float[] rgbToHsl(float r, float g, float b) {
        float fmin = Math.min(Math.min(r, g), b);
        float fmax = Math.max(Math.max(r, g), b);
        float delta = fmax - fmin;
        float h = 0.0f;
        float s = 0.0f;
        float l = 0.0f;
        l = (fmax + fmin) / 2.0f;
        if ((double)delta == 0.0) {
            h = 0.0f;
            s = 0.0f;
        } else {
            s = l < 0.5f ? delta / (fmax + fmin) : delta / (2.0f - fmax - fmin);
            float deltaR = ((fmax - r) / 6.0f + delta / 2.0f) / delta;
            float deltaG = ((fmax - g) / 6.0f + delta / 2.0f) / delta;
            float deltaB = ((fmax - b) / 6.0f + delta / 2.0f) / delta;
            if (r == fmax) {
                h = deltaB - deltaG;
            } else if (g == fmax) {
                h = 0.33333334f + deltaR - deltaB;
            } else if (b == fmax) {
                h = 0.6666667f + deltaG - deltaR;
            }
            if (h < 0.0f) {
                h += 1.0f;
            } else if (h > 1.0f) {
                h -= 1.0f;
            }
        }
        return new float[]{h, s, l};
    }

    public static final float[] hslToRgb(float h, float s, float l) {
        float[] rgb = new float[3];
        if (s == 0.0f) {
            rgb[0] = l;
            rgb[1] = l;
            rgb[2] = l;
        } else {
            float m2 = (double)l <= 0.5 ? l * (1.0f + s) : l + s - l * s;
            float m1 = 2.0f * l - m2;
            rgb[0] = BaseImageUtils.hueToRgb(m1, m2, h + 0.3333333f);
            rgb[1] = BaseImageUtils.hueToRgb(m1, m2, h);
            rgb[2] = BaseImageUtils.hueToRgb(m1, m2, h - 0.3333333f);
        }
        return rgb;
    }

    private static final float hueToRgb(float m1, float m2, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (h * 6.0f < 1.0f) {
            return m1 + (m2 - m1) * h * 6.0f;
        }
        if (h * 2.0f < 1.0f) {
            return m2;
        }
        if (h * 3.0f < 2.0f) {
            return m1 + (m2 - m1) * (0.6666667f - h) * 6.0f;
        }
        return m1;
    }

    public static final float[] rgbToHsb(int rgb) {
        float hue;
        int cmin;
        int cmax;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        float[] result = new float[]{hue, saturation, brightness};
        return result;
    }

    public static final int[] hslToSRGBInt(int h, int s, int l) {
        int[] hsl = new int[3];
        if (s == 0) {
            hsl[0] = l;
            hsl[1] = l;
            hsl[2] = l;
        } else {
            float m2 = l < 128 ? (float)(l * (255 + s)) / 65025.0f : ((float)(l + s) - (float)(l * s) / 255.0f) / 255.0f;
            float m1 = (float)l / 127.5f - m2;
            hsl[0] = BaseImageUtils.hslValueInt(m1, m2, h + 85);
            hsl[1] = BaseImageUtils.hslValueInt(m1, m2, h);
            hsl[2] = BaseImageUtils.hslValueInt(m1, m2, h - 85);
        }
        return hsl;
    }

    public static final int hslValueInt(float n1, float n2, float hue) {
        if (hue > 255.0f) {
            hue -= 255.0f;
        } else if (hue < 0.0f) {
            hue += 255.0f;
        }
        float value = (double)hue < 42.5 ? n1 + (n2 - n1) * hue / 42.5f : ((double)hue < 127.5 ? n2 : (hue < 170.0f ? n1 + (n2 - n1) * (170.0f - hue) / 42.5f : n1));
        return FastMath.round((double)value * 255.0);
    }

    public static final int[] srgbToHSLInt(int r, int g, int b) {
        float h;
        float s;
        int min;
        int max;
        if (r > g) {
            max = Math.max(r, b);
            min = Math.min(g, b);
        } else {
            max = Math.max(g, b);
            min = Math.min(r, b);
        }
        float l = (float)(max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            int delta = max - min;
            s = l < 128.0f ? (float)(255 * delta) / (float)(max + min) : 255.0f * (float)delta / (float)(511 - max - min);
            h = r == max ? (float)(g - b) / (float)delta : (g == max ? 2.0f + (float)(b - r) / (float)delta : 4.0f + (float)(r - g) / (float)delta);
            if ((h *= 42.5f) < 0.0f) {
                h += 255.0f;
            } else if (h > 255.0f) {
                h -= 255.0f;
            }
        }
        int[] rgb = new int[]{FastMath.round(h), FastMath.round(s), FastMath.round(l)};
        return rgb;
    }

    public static final int floatRgbToIntRgb(float[] f) {
        int result = BaseImageUtils.clampFT255(f[0] * 255.0f + 0.5f) << 16 | BaseImageUtils.clampFT255(f[1] * 255.0f + 0.5f) << 8 | BaseImageUtils.clampFT255(f[2] * 255.0f + 0.5f);
        return result;
    }

    public static final float[] rgbToYiq(float r, float g, float b) {
        return new float[]{0.299f * r + 0.587f * g + 0.114f * b, 0.595716f * r - 0.274453f * g - 0.321263f * b, 0.211456f * r - 0.522591f * g + 0.311135f * b};
    }

    public static final float[] yiqToRgb(float y, float i, float q) {
        return new float[]{y + 0.9563f * i + 0.621f * q, y - 0.2721f * i - 0.6474f * q, y - 1.107f * i + 1.7046f * q};
    }

    public static final float getBrightnessRGB(int r, int g, int b) {
        return 0.298839f * (float)r + 0.586811f * (float)g + 0.11435f * (float)b;
    }

    public static final float getBrightnessLinear(int r, int g, int b) {
        return 0.33333f * (float)r + 0.33333f * (float)g + 0.33333f * (float)b;
    }

    public static final float getBrightnessSRGB(int r, int g, int b) {
        return 0.2126f * (float)r + 0.7152f * (float)g + 0.0722f * (float)b;
    }

    public static final float[] RGBtoHSY(float r, float g, float b) {
        float[] trgb;
        float Lxyz;
        float Smax;
        float[] hsl = BaseImageUtils.rgbToHsl(r, g, b);
        float hue = hsl[0];
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float sat = max - min;
        float lum = r * 0.298839f + g * 0.586811f + b * 0.11435f;
        if (lum > 255.0f) {
            lum = 255.0f;
        }
        if (lum < 0.0f) {
            lum = 0.0f;
        }
        if (sat > (Smax = lum >= (Lxyz = (r = (trgb = BaseImageUtils.hslToRgb(hue, 1.0f, 0.5f))[0] * 255.0f) * 0.298839f + (g = trgb[1] * 255.0f) * 0.586811f + (b = trgb[2] * 255.0f) * 0.11435f) ? 255.0f * (255.0f - lum) / (255.0f - Lxyz) : lum / Lxyz * 255.0f)) {
            sat = Smax;
        }
        if (sat < 0.0f) {
            sat = 0.0f;
        }
        r = BaseImageUtils.scaleValue(r, 0.0f, 255.0f, 0.0f, sat);
        g = BaseImageUtils.scaleValue(g, 0.0f, 255.0f, 0.0f, sat);
        b = BaseImageUtils.scaleValue(b, 0.0f, 255.0f, 0.0f, sat);
        float tempL = r * 0.298839f + g * 0.586811f + b * 0.11435f;
        tempL = lum - tempL;
        return new float[]{r += tempL, g += tempL, b += tempL};
    }

    public static final float[] RGBtoHLSho(int r, int g, int b) {
        float s;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float l = 0.333333f * (rf + gf + bf);
        float v = 0.866025f * (gf - bf);
        float u = rf - 0.5f * (gf + bf);
        float h = (float)Math.atan2(v, u);
        if (h < 0.0f) {
            h += 360.0f;
        }
        float t = 1.73205f * u;
        if (v > 0.0f) {
            if (t > v) {
                s = u + 0.57735f * v;
            } else if (-t > v) {
                s = -u * 0.57735f * v;
            }
            s = 1.154701f * v;
        } else {
            if (t > -v) {
                s = u - 0.57735f * v;
            } else if (-t > -v) {
                s = -u - 0.57735f * v;
            }
            s = -1.154701f * v;
        }
        return new float[]{h, s, l};
    }

    public static final float scaleValue(float value, float from, float to, float min, float max) {
        return (max - min) / (to - from) * value + min;
    }

    public static final int scaleToIntValue(float value, float from, float to, float min, float max) {
        return (int)((max - min) / (to - from) * value + min);
    }

    public static final float[] rgbToFloat1(int rgb) {
        float[] f = new float[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
        return f;
    }

    public static final float[] argbToFloat1(int rgb) {
        float[] f;
        f = new float[]{(float)(rgb >>> 24) / 255.0f, (float)(rgb >> 16 & 0xFF) / 255.0f * f[0], (float)(rgb >> 8 & 0xFF) / 255.0f * f[0], (float)(rgb & 0xFF) / 255.0f * f[0]};
        return f;
    }

    public static final double[] argbToDouble1(int rgb) {
        double[] f;
        f = new double[]{(double)(rgb >>> 24) / 255.0, (double)(rgb >> 16 & 0xFF) / 255.0 * f[0], (double)(rgb >> 8 & 0xFF) / 255.0 * f[0], (double)(rgb & 0xFF) / 255.0 * f[0]};
        return f;
    }

    public static final float[] rgbD65toXYZ(float r, float g, float b) {
        return new float[]{r * 0.4124564f + g * 0.3575761f + b * 0.1804375f, r * 0.2126729f + g * 0.7151522f + b * 0.072175f, r * 0.0193339f + g * 0.119192f + b * 0.9503041f};
    }

    public static final float[] rgbD65toXYZ(float[] rgb) {
        return new float[]{rgb[0] * 0.4124564f + rgb[1] * 0.3575761f + rgb[2] * 0.1804375f, rgb[0] * 0.2126729f + rgb[1] * 0.7151522f + rgb[2] * 0.072175f, rgb[0] * 0.0193339f + rgb[1] * 0.119192f + rgb[2] * 0.9503041f};
    }

    public static final float[] rgb2xyz(float[] rgb) {
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : (r /= 12.92);
        g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : (g /= 12.92);
        b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : (b /= 12.92);
        return new float[]{(float)(r * 0.4124564 + g * 0.3575761 + b * 0.1804375), (float)(r * 0.2126729 + g * 0.7151522 + b * 0.072175), (float)(r * 0.0193339 + g * 0.119192 + b * 0.9503041)};
    }

    public static final float[] xyz2rgb(float[] xyz) {
        double x = xyz[0];
        double y = xyz[1];
        double z = xyz[2];
        if (x < 0.0) {
            x = 0.0;
        } else if (x > 0.95047) {
            x = 0.95047;
        }
        double r = x * 3.2406 + y * -1.5372 + z * -0.4986;
        double g = x * -0.9689 + y * 1.8758 + z * 0.0415;
        double b = x * 0.0557 + y * -0.204 + z * 1.057;
        r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666567325592) - 0.055 : 12.92 * r;
        g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666567325592) - 0.055 : 12.92 * g;
        b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666567325592) - 0.055 : 12.92 * b;
        return new float[]{(float)BaseImageUtils.clamp(r), (float)BaseImageUtils.clamp(g), (float)BaseImageUtils.clamp(b)};
    }

    public static final float[] xyz2lab(float[] xyz) {
        double x = (double)xyz[0] / 0.95047;
        double y = xyz[1];
        double z = (double)xyz[2] / 1.08883;
        x = x > 0.008856 ? Math.pow(x, 0.3333333432674408) : 7.787 * x + 0.13793103448275862;
        y = y > 0.008856 ? Math.pow(y, 0.3333333432674408) : 7.787 * y + 0.13793103448275862;
        z = z > 0.008856 ? Math.pow(z, 0.3333333432674408) : 7.787 * z + 0.13793103448275862;
        return new float[]{(float)(116.0 * y - 16.0), (float)(500.0 * (x - y)), (float)(200.0 * (y - z))};
    }

    public static final float[] lab2xyz(float[] lab) {
        double y = (lab[0] + 16.0f) / 116.0f;
        double x = (double)(lab[1] / 500.0f) + y;
        double z = y - (double)(lab[2] / 200.0f);
        y = Math.pow(y, 3.0) > 0.008856 ? Math.pow(y, 3.0) : (y - 0.0) / 7.787;
        x = Math.pow(x, 3.0) > 0.008856 ? Math.pow(x, 3.0) : (x - 0.0) / 7.787;
        z = Math.pow(z, 3.0) > 0.008856 ? Math.pow(z, 3.0) : (z - 0.0) / 7.787;
        return new float[]{(float)(x * 0.95047), (float)y, (float)(z * 1.08883)};
    }

    public static final int double1ToARGB(double[] f) {
        int result = BaseImageUtils.clampFT255(f[0] * 255.0 + 0.5) << 24 | BaseImageUtils.clampFT255(f[1] * 255.0 + 0.5) << 16 | BaseImageUtils.clampFT255(f[2] * 255.0 + 0.5) << 8 | BaseImageUtils.clampFT255(f[3] * 255.0 + 0.5);
        return result;
    }
}

