/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.imagemanipulator.utils;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.imagereader.image.FSIImage;

public abstract class EffectThreadAbstract
implements Runnable,
PriorityExecutor.Important {
    private final int priority;
    protected final int fromY;
    protected final int toY;
    protected FSIImage baseImage;
    protected FSIImage newImage;
    protected int baseWidth;
    protected int baseHeight;
    byte[] alphaSelection = null;

    public EffectThreadAbstract(int priority, int fromY, int toY) {
        this.priority = priority;
        this.fromY = fromY;
        this.toY = toY;
    }

    public void setAlphaSelection(byte[] alphaSelection) {
        this.alphaSelection = alphaSelection;
    }

    public void setImages(FSIImage baseImage, FSIImage imageNew) {
        this.baseImage = baseImage.createSlice();
        this.newImage = imageNew.createSlice();
        this.baseWidth = baseImage.getWidth();
        this.baseHeight = baseImage.getHeight();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected static int blend(int baseARGB, int layerARGB, int alpha) {
        float alpha1f = (float)alpha / 255.0f;
        int ba = baseARGB >> 24 & 0xFF;
        int br = baseARGB >> 16 & 0xFF;
        int bg = baseARGB >> 8 & 0xFF;
        int bb = baseARGB & 0xFF;
        int la = layerARGB >> 24 & 0xFF;
        int lr = layerARGB >> 16 & 0xFF;
        int lg = layerARGB >> 8 & 0xFF;
        int lb = layerARGB & 0xFF;
        int naf = EffectThreadAbstract.clampFT255((1.0f - alpha1f) * (float)ba + alpha1f * (float)la);
        int rr = EffectThreadAbstract.clampFT255((1.0f - alpha1f) * (float)br + alpha1f * (float)lr);
        int rg = EffectThreadAbstract.clampFT255((1.0f - alpha1f) * (float)bg + alpha1f * (float)lg);
        int rb = EffectThreadAbstract.clampFT255((1.0f - alpha1f) * (float)bb + alpha1f * (float)lb);
        return naf << 24 | rr << 16 | rg << 8 | rb;
    }

    protected static final int clampFT255(float x) {
        if (x < 0.0f) {
            return 0;
        }
        if (x > 255.0f) {
            return 255;
        }
        return (int)(x + 0.5f);
    }

    protected static final int clampFT255(double x) {
        if (x < 0.0) {
            return 0;
        }
        if (x > 255.0) {
            return 255;
        }
        return (int)(x + 0.5);
    }

    protected static final float[] argbToFloat1(int rgb) {
        float[] f;
        f = new float[]{(float)(rgb >>> 24) / 255.0f, (float)(rgb >> 16 & 0xFF) / 255.0f * f[0], (float)(rgb >> 8 & 0xFF) / 255.0f * f[0], (float)(rgb & 0xFF) / 255.0f * f[0]};
        return f;
    }

    protected static final double[] argbToDouble1(int rgb) {
        double[] f;
        f = new double[]{(double)(rgb >>> 24) / 255.0, (double)(rgb >> 16 & 0xFF) / 255.0 * f[0], (double)(rgb >> 8 & 0xFF) / 255.0 * f[0], (double)(rgb & 0xFF) / 255.0 * f[0]};
        return f;
    }

    protected static final int double1ToARGB(double[] f) {
        int result = EffectThreadAbstract.clampFT255(f[0] * 255.0) << 24 | EffectThreadAbstract.clampFT255(f[1] * 255.0) << 16 | EffectThreadAbstract.clampFT255(f[2] * 255.0) << 8 | EffectThreadAbstract.clampFT255(f[3] * 255.0);
        return result;
    }
}

